/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.tile;

import com.google.common.base.Strings;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.api.grid.ISortingInventory;
import net.blay09.mods.refinedrelocation.capability.CapabilityRootFilter;
import net.blay09.mods.refinedrelocation.capability.CapabilitySimpleFilter;
import net.blay09.mods.refinedrelocation.capability.CapabilitySortingGridMember;
import net.blay09.mods.refinedrelocation.capability.CapabilitySortingInventory;
import net.blay09.mods.refinedrelocation.tile.TileMod;
import net.blay09.mods.refinedrelocation.util.DoorAnimator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileSortingChest
extends TileMod
implements ITickable {
    private final ItemStackHandler itemHandler = new ItemStackHandler(27){

        protected void onContentsChanged(int slot) {
            TileSortingChest.this.func_70296_d();
            TileSortingChest.this.sortingInventory.onSlotChanged(slot);
        }
    };
    private final DoorAnimator doorAnimator = new DoorAnimator(this, 0, 1);
    private final ISortingInventory sortingInventory = (ISortingInventory)CapabilitySortingInventory.CAPABILITY.getDefaultInstance();
    private final IRootFilter rootFilter = (IRootFilter)CapabilityRootFilter.CAPABILITY.getDefaultInstance();
    private String customName = "";

    public TileSortingChest() {
        this.doorAnimator.setOpenRadius((float)Math.PI);
        this.doorAnimator.setSoundEventOpen(SoundEvents.field_187657_V);
        this.doorAnimator.setSoundEventClose(SoundEvents.field_187651_T);
    }

    public void func_73660_a() {
        this.sortingInventory.onUpdate(this);
        this.doorAnimator.update();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.sortingInventory.onInvalidate(this);
    }

    public DoorAnimator getDoorAnimator() {
        return this.doorAnimator;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.itemHandler.deserializeNBT(compound.func_74775_l("ItemHandler"));
        this.sortingInventory.deserializeNBT((NBTBase)compound.func_74775_l("SortingInventory"));
        this.rootFilter.deserializeNBT((NBTBase)compound.func_150295_c("RootFilter", 10));
    }

    @Override
    public void readFromNBTSynced(NBTTagCompound compound) {
        this.customName = compound.func_74779_i("CustomName");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("ItemHandler", (NBTBase)this.itemHandler.serializeNBT());
        compound.func_74782_a("SortingInventory", this.sortingInventory.serializeNBT());
        compound.func_74782_a("RootFilter", this.rootFilter.serializeNBT());
        return compound;
    }

    @Override
    public NBTTagCompound writeToNBTSynced(NBTTagCompound compound) {
        compound.func_74778_a("CustomName", this.customName);
        return compound;
    }

    public boolean func_145842_c(int id, int type) {
        return this.doorAnimator.receiveClientEvent(id, type) || super.func_145842_c(id, type);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilitySortingInventory.CAPABILITY || capability == CapabilitySortingGridMember.CAPABILITY || capability == CapabilityRootFilter.CAPABILITY || capability == CapabilitySimpleFilter.CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        if (capability == CapabilitySortingInventory.CAPABILITY || capability == CapabilitySortingGridMember.CAPABILITY) {
            return (T)this.sortingInventory;
        }
        if (capability == CapabilityRootFilter.CAPABILITY || capability == CapabilitySimpleFilter.CAPABILITY) {
            return (T)this.rootFilter;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public boolean hasCustomName() {
        return !Strings.isNullOrEmpty((String)this.customName);
    }

    public ITextComponent func_145748_c_() {
        return !Strings.isNullOrEmpty((String)this.customName) ? new TextComponentString(this.customName) : new TextComponentTranslation("container.refinedrelocation:sortingChest", new Object[0]);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }
}

