/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.compat.ironchest;

import cpw.mods.ironchest.BlockIronChest;
import cpw.mods.ironchest.ChestChangerType;
import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.ItemChestChanger;
import cpw.mods.ironchest.TileEntityIronChest;
import cpw.mods.ironchest.client.GUIChest;
import java.util.Locale;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.ModBlocks;
import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.ISortingUpgradable;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.api.TileOrMultipart;
import net.blay09.mods.refinedrelocation.api.container.ITileGuiHandler;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.api.grid.ISortingInventory;
import net.blay09.mods.refinedrelocation.compat.RefinedAddon;
import net.blay09.mods.refinedrelocation.compat.ironchest.BlockSortingIronChest;
import net.blay09.mods.refinedrelocation.compat.ironchest.ItemBlockSortingIronChest;
import net.blay09.mods.refinedrelocation.compat.ironchest.RenderSortingIronChest;
import net.blay09.mods.refinedrelocation.compat.ironchest.TileSortingIronChest;
import net.blay09.mods.refinedrelocation.tile.TileSortingChest;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IronChestAddon
extends RefinedAddon {
    private static Block ironChest;
    private static BlockSortingIronChest sortingIronChest;

    @Override
    public void preInit() {
        ironChest = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("ironchest", "BlockIronChest"));
        sortingIronChest = new BlockSortingIronChest(ironChest);
        GameRegistry.register((IForgeRegistryEntry)sortingIronChest);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockSortingIronChest(sortingIronChest));
        GameRegistry.registerTileEntity(TileSortingIronChest.class, (String)sortingIronChest.getRegistryName().toString());
        GameRegistry.registerTileEntity(TileSortingIronChest.Dirt.class, (String)(sortingIronChest.getRegistryName().toString() + "_dirt"));
        GameRegistry.registerTileEntity(TileSortingIronChest.Obsidian.class, (String)(sortingIronChest.getRegistryName().toString() + "_obsidian"));
        GameRegistry.registerTileEntity(TileSortingIronChest.Crystal.class, (String)(sortingIronChest.getRegistryName().toString() + "_crystal"));
        GameRegistry.registerTileEntity(TileSortingIronChest.Diamond.class, (String)(sortingIronChest.getRegistryName().toString() + "_diamond"));
        GameRegistry.registerTileEntity(TileSortingIronChest.Copper.class, (String)(sortingIronChest.getRegistryName().toString() + "_copper"));
        GameRegistry.registerTileEntity(TileSortingIronChest.Gold.class, (String)(sortingIronChest.getRegistryName().toString() + "_gold"));
        GameRegistry.registerTileEntity(TileSortingIronChest.Silver.class, (String)(sortingIronChest.getRegistryName().toString() + "_silver"));
        final Object modInstance = ((ModContainer)Loader.instance().getIndexedModList().get("ironchest")).getMod();
        ITileGuiHandler tileGuiHandler = new ITileGuiHandler(){

            @Override
            public void openGui(EntityPlayer player, TileOrMultipart tileEntity) {
                TileSortingIronChest tileIronChest = (TileSortingIronChest)tileEntity.getTileEntity();
                if (tileIronChest != null) {
                    player.openGui(modInstance, tileIronChest.getType().ordinal(), tileEntity.getWorld(), tileEntity.getPos().func_177958_n(), tileEntity.getPos().func_177956_o(), tileEntity.getPos().func_177952_p());
                }
            }
        };
        RefinedRelocationAPI.registerGuiHandler(TileSortingIronChest.class, tileGuiHandler);
        RefinedRelocationAPI.registerGuiHandler(TileSortingIronChest.Dirt.class, tileGuiHandler);
        RefinedRelocationAPI.registerGuiHandler(TileSortingIronChest.Obsidian.class, tileGuiHandler);
        RefinedRelocationAPI.registerGuiHandler(TileSortingIronChest.Crystal.class, tileGuiHandler);
        RefinedRelocationAPI.registerGuiHandler(TileSortingIronChest.Diamond.class, tileGuiHandler);
        RefinedRelocationAPI.registerGuiHandler(TileSortingIronChest.Copper.class, tileGuiHandler);
        RefinedRelocationAPI.registerGuiHandler(TileSortingIronChest.Gold.class, tileGuiHandler);
        RefinedRelocationAPI.registerGuiHandler(TileSortingIronChest.Silver.class, tileGuiHandler);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void preInitClient() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileSortingIronChest.class, (TileEntitySpecialRenderer)new RenderSortingIronChest(sortingIronChest));
        Item sortingIronChestItem = Item.func_150898_a((Block)sortingIronChest);
        if (sortingIronChestItem != null) {
            ModelLoader.setCustomMeshDefinition((Item)sortingIronChestItem, (ItemMeshDefinition)new ItemMeshDefinition(){

                public ModelResourceLocation func_178113_a(ItemStack stack) {
                    return new ModelResourceLocation(sortingIronChest.getRegistryName(), "variant=" + IronChestType.VALUES[stack.func_77952_i()].name().toLowerCase(Locale.ENGLISH));
                }
            });
        }
    }

    @Override
    public void init() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)sortingIronChest, 1, IronChestType.IRON.ordinal()), (Object[])new Object[]{" B ", "RCR", " H ", Character.valueOf('B'), Items.field_151099_bA, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('C'), new ItemStack(ironChest, 1, IronChestType.IRON.ordinal()), Character.valueOf('H'), Blocks.field_150438_bZ});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)sortingIronChest, 1, IronChestType.GOLD.ordinal()), (Object[])new Object[]{" B ", "RCR", " H ", Character.valueOf('B'), Items.field_151099_bA, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('C'), new ItemStack(ironChest, 1, IronChestType.GOLD.ordinal()), Character.valueOf('H'), Blocks.field_150438_bZ});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)sortingIronChest, 1, IronChestType.DIAMOND.ordinal()), (Object[])new Object[]{" B ", "RCR", " H ", Character.valueOf('B'), Items.field_151099_bA, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('C'), new ItemStack(ironChest, 1, IronChestType.DIAMOND.ordinal()), Character.valueOf('H'), Blocks.field_150438_bZ});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)sortingIronChest, 1, IronChestType.COPPER.ordinal()), (Object[])new Object[]{" B ", "RCR", " H ", Character.valueOf('B'), Items.field_151099_bA, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('C'), new ItemStack(ironChest, 1, IronChestType.COPPER.ordinal()), Character.valueOf('H'), Blocks.field_150438_bZ});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)sortingIronChest, 1, IronChestType.SILVER.ordinal()), (Object[])new Object[]{" B ", "RCR", " H ", Character.valueOf('B'), Items.field_151099_bA, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('C'), new ItemStack(ironChest, 1, IronChestType.SILVER.ordinal()), Character.valueOf('H'), Blocks.field_150438_bZ});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)sortingIronChest, 1, IronChestType.CRYSTAL.ordinal()), (Object[])new Object[]{" B ", "RCR", " H ", Character.valueOf('B'), Items.field_151099_bA, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('C'), new ItemStack(ironChest, 1, IronChestType.CRYSTAL.ordinal()), Character.valueOf('H'), Blocks.field_150438_bZ});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)sortingIronChest, 1, IronChestType.OBSIDIAN.ordinal()), (Object[])new Object[]{" B ", "RCR", " H ", Character.valueOf('B'), Items.field_151099_bA, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('C'), new ItemStack(ironChest, 1, IronChestType.OBSIDIAN.ordinal()), Character.valueOf('H'), Blocks.field_150438_bZ});
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)sortingIronChest, 1, IronChestType.DIRTCHEST9000.ordinal()), (Object[])new Object[]{" B ", "RCR", " H ", Character.valueOf('B'), Items.field_151099_bA, Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('C'), new ItemStack(ironChest, 1, IronChestType.DIRTCHEST9000.ordinal()), Character.valueOf('H'), Blocks.field_150438_bZ});
    }

    @SubscribeEvent
    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        EnumFacing previousFacing;
        ItemStack[] previousContent;
        if (event.getWorld().field_72995_K || event.getItemStack() == null || !(event.getItemStack().func_77973_b() instanceof ItemChestChanger)) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        ChestChangerType type = ((ItemChestChanger)event.getItemStack().func_77973_b()).type;
        if (type.canUpgrade(IronChestType.WOOD) ? state.func_177230_c() != ModBlocks.sortingChest : state != sortingIronChest.func_176203_a(IronChestType.valueOf((String)type.source.func_176610_l().toUpperCase()).ordinal())) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return;
        }
        IRootFilter rootFilter = (IRootFilter)tileEntity.getCapability(Capabilities.ROOT_FILTER, null);
        ISortingInventory sortingInventory = (ISortingInventory)tileEntity.getCapability(Capabilities.SORTING_INVENTORY, null);
        if (tileEntity instanceof TileSortingIronChest) {
            previousContent = ((TileSortingIronChest)tileEntity).chestContents;
            previousFacing = ((TileSortingIronChest)tileEntity).getFacing();
        } else if (tileEntity instanceof TileSortingChest) {
            previousFacing = (EnumFacing)state.func_177229_b((IProperty)BlockChest.field_176459_a);
            TileSortingChest tileSortingChest = (TileSortingChest)tileEntity;
            if (tileSortingChest.getDoorAnimator().getNumPlayersUsing() > 0) {
                return;
            }
            previousContent = new ItemStack[tileSortingChest.getItemHandler().getSlots()];
            for (int i = 0; i < previousContent.length; ++i) {
                previousContent[i] = tileSortingChest.getItemHandler().getStackInSlot(i);
            }
        } else {
            return;
        }
        tileEntity.func_145836_u();
        world.func_175713_t(pos);
        world.func_175698_g(pos);
        IBlockState newState = sortingIronChest.func_176223_P().func_177226_a((IProperty)BlockIronChest.VARIANT_PROP, (Comparable)type.target);
        world.func_180501_a(pos, newState, 3);
        TileEntity newTileEntity = world.func_175625_s(pos);
        if (newTileEntity instanceof TileSortingIronChest) {
            ((TileSortingIronChest)newTileEntity).setContents(previousContent);
            ((TileSortingIronChest)newTileEntity).setFacing(previousFacing);
            IRootFilter newRootFilter = (IRootFilter)newTileEntity.getCapability(Capabilities.ROOT_FILTER, null);
            newRootFilter.deserializeNBT(rootFilter.serializeNBT());
            ISortingInventory newSortingInventory = (ISortingInventory)newTileEntity.getCapability(Capabilities.SORTING_INVENTORY, null);
            newSortingInventory.deserializeNBT(sortingInventory.serializeNBT());
        }
        event.getItemStack().field_77994_a = event.getEntityPlayer().field_71075_bZ.field_75098_d ? event.getItemStack().field_77994_a : event.getItemStack().field_77994_a - 1;
        event.setCanceled(true);
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent.TileEntity event) {
        if (event.getTileEntity() instanceof TileEntityIronChest && !(event.getTileEntity() instanceof TileSortingIronChest)) {
            event.addCapability(new ResourceLocation("refinedrelocation", "SortingUpgradable"), (ICapabilityProvider)new IronChestCapabilityProvider());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onInitGui(GuiScreenEvent.InitGuiEvent event) {
        if (event.getGui() instanceof GUIChest) {
            GuiContainer guiContainer = (GuiContainer)event.getGui();
            TileEntityIronChest tileIronChest = (TileEntityIronChest)((Slot)guiContainer.field_147002_h.field_75151_b.get((int)0)).field_75224_c;
            if (tileIronChest instanceof TileSortingIronChest) {
                GuiButton button = RefinedRelocationAPI.createOpenFilterButton(guiContainer, (TileEntity)tileIronChest, -1);
                button.field_146128_h += 7;
                button.field_146129_i += 3;
                event.getButtonList().add(button);
            }
        }
    }

    private class IronChestCapabilityProvider
    implements ICapabilityProvider,
    ISortingUpgradable {
        private IronChestCapabilityProvider() {
        }

        public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == Capabilities.SORTING_UPGRADABLE;
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            return (T)(capability == Capabilities.SORTING_UPGRADABLE ? this : null);
        }

        @Override
        public boolean applySortingUpgrade(TileEntity tileEntity, ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
            TileEntityIronChest tileIronChest = (TileEntityIronChest)tileEntity;
            if (tileIronChest.lidAngle > 0.0f) {
                return false;
            }
            NBTTagCompound storedData = tileIronChest.func_189515_b(new NBTTagCompound());
            tileIronChest.func_174888_l();
            IBlockState oldState = world.func_180495_p(pos);
            world.func_175656_a(pos, sortingIronChest.func_176223_P().func_177226_a((IProperty)BlockIronChest.VARIANT_PROP, oldState.func_177229_b((IProperty)BlockIronChest.VARIANT_PROP)));
            TileSortingIronChest sortingIronChest = (TileSortingIronChest)world.func_175625_s(pos);
            if (sortingIronChest == null) {
                return false;
            }
            sortingIronChest.func_145839_a(storedData);
            return true;
        }
    }
}

