/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.compat.ironchest;

import cpw.mods.ironchest.BlockIronChest;
import cpw.mods.ironchest.IronChestType;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.api.RefinedRelocationAPI;
import net.blay09.mods.refinedrelocation.block.BlockModTile;
import net.blay09.mods.refinedrelocation.compat.ironchest.TileSortingIronChest;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSortingIronChest
extends BlockModTile {
    private final Block baseBlock;

    public BlockSortingIronChest(Block baseBlock) {
        super(Material.field_151573_f, "sorting_iron_chest");
        this.baseBlock = baseBlock;
        this.func_149711_c(3.0f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.baseBlock.func_185496_a(state, source, pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (player.func_70093_af() && (tileEntity = world.func_175625_s(pos)) instanceof TileSortingIronChest) {
            RefinedRelocationAPI.openRootFilterGui(player, tileEntity);
        }
        return this.baseBlock.func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((IronChestType)state.func_177229_b((IProperty)BlockIronChest.VARIANT_PROP)) {
            case GOLD: {
                return new TileSortingIronChest.Gold();
            }
            case DIAMOND: {
                return new TileSortingIronChest.Diamond();
            }
            case COPPER: {
                return new TileSortingIronChest.Copper();
            }
            case SILVER: {
                return new TileSortingIronChest.Silver();
            }
            case CRYSTAL: {
                return new TileSortingIronChest.Crystal();
            }
            case OBSIDIAN: {
                return new TileSortingIronChest.Obsidian();
            }
            case DIRTCHEST9000: {
                return new TileSortingIronChest.Dirt();
            }
        }
        return new TileSortingIronChest();
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (IronChestType type : IronChestType.VALUES) {
            if (!type.isValidForCreativeMode()) continue;
            list.add(new ItemStack(item, 1, type.ordinal()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockIronChest.VARIANT_PROP, (Comparable)IronChestType.VALUES[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((IronChestType)state.func_177229_b((IProperty)BlockIronChest.VARIANT_PROP)).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockIronChest.VARIANT_PROP});
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState blockState) {
        this.baseBlock.func_176213_c(world, pos, blockState);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityLiving, ItemStack itemStack) {
        this.baseBlock.func_180633_a(world, pos, state, entityLiving, itemStack);
    }

    public int func_180651_a(IBlockState state) {
        return this.baseBlock.func_180651_a(state);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.baseBlock.func_180663_b(world, pos, state);
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return this.baseBlock.getExplosionResistance(world, pos, exploder, explosion);
    }

    public boolean func_149740_M(IBlockState state) {
        return this.baseBlock.func_149740_M(state);
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return this.baseBlock.func_180641_l(state, world, pos);
    }

    public EnumFacing[] getValidRotations(World worldObj, BlockPos pos) {
        return this.baseBlock.getValidRotations(worldObj, pos);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        return this.baseBlock.rotateBlock(world, pos, axis);
    }
}

