/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.client.gui.base.element;

import net.blay09.mods.refinedrelocation.client.ClientProxy;
import net.blay09.mods.refinedrelocation.client.gui.base.IParentScreen;
import net.blay09.mods.refinedrelocation.client.gui.base.element.GuiElement;
import net.blay09.mods.refinedrelocation.client.gui.base.element.IScrollTarget;
import net.blay09.mods.refinedrelocation.client.util.TextureAtlasRegion;

public class GuiScrollBar
extends GuiElement {
    private final TextureAtlasRegion scrollbarTop;
    private final TextureAtlasRegion scrollbarMiddle;
    private final TextureAtlasRegion scrollbarBottom;
    private final IScrollTarget scrollTarget;
    private int barY;
    private int barHeight;
    private int indexWhenClicked;
    private int lastNumberOfMoves;
    private int mouseClickY = -1;
    private int lastRowCount;
    private int lastVisibleRows;
    private int lastOffset;

    public GuiScrollBar(int x, int y, int height, IScrollTarget scrollTarget) {
        this.scrollTarget = scrollTarget;
        this.setPosition(x, y);
        this.setSize(7, height);
        this.updatePosition();
        this.scrollbarTop = ClientProxy.TEXTURE_ATLAS.getSprite("refinedrelocation:scrollbar_top");
        this.scrollbarMiddle = ClientProxy.TEXTURE_ATLAS.getSprite("refinedrelocation:scrollbar_middle");
        this.scrollbarBottom = ClientProxy.TEXTURE_ATLAS.getSprite("refinedrelocation:scrollbar_bottom");
    }

    @Override
    public void mouseWheelMoved(int mouseX, int mouseY, int delta) {
        this.setCurrentOffset(delta > 0 ? this.scrollTarget.getCurrentOffset() - 1 : this.scrollTarget.getCurrentOffset() + 1);
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int state) {
        if (this.mouseClickY != -1) {
            this.mouseClickY = -1;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && mouseX >= this.getAbsoluteX() && mouseX < this.getAbsoluteX() + this.getWidth() && mouseY >= this.barY && mouseY < this.barY + this.barHeight) {
            this.mouseClickY = mouseY;
            this.indexWhenClicked = this.scrollTarget.getCurrentOffset();
            return true;
        }
        return false;
    }

    @Override
    public void updatePosition() {
        super.updatePosition();
        this.barHeight = (int)((double)this.getHeight() * Math.min(1.0, (double)this.scrollTarget.getVisibleRows() / Math.ceil(this.scrollTarget.getRowCount())));
        this.barY = this.getAbsoluteY() + (this.getHeight() - this.barHeight) * this.scrollTarget.getCurrentOffset() / Math.max(1, (int)Math.ceil(this.scrollTarget.getRowCount()) - this.scrollTarget.getVisibleRows());
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.updatePosition();
    }

    @Override
    public void update() {
        super.update();
        if (this.lastRowCount != this.scrollTarget.getRowCount() || this.lastVisibleRows != this.scrollTarget.getVisibleRows() || this.lastOffset != this.scrollTarget.getCurrentOffset()) {
            this.updatePosition();
            this.lastRowCount = this.scrollTarget.getRowCount();
            this.lastVisibleRows = this.scrollTarget.getVisibleRows();
            this.lastOffset = this.scrollTarget.getCurrentOffset();
        }
    }

    @Override
    public void drawBackground(IParentScreen parentScreen, int mouseX, int mouseY) {
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        if (this.mouseClickY != -1 && (pixelsPerFilter = (float)(this.getHeight() - this.barHeight) / (float)Math.max(1, (int)Math.ceil(this.scrollTarget.getRowCount()) - this.scrollTarget.getVisibleRows())) != 0.0f && (numberOfFiltersMoved = (int)((float)(mouseY - this.mouseClickY) / pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentOffset(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        this.scrollbarTop.draw(this.getAbsoluteX() - 2, this.getAbsoluteY() - 1, this.field_73735_i);
        this.scrollbarBottom.draw(this.getAbsoluteX() - 2, this.getAbsoluteY() + this.getHeight() - 1, this.field_73735_i);
        this.scrollbarMiddle.draw(this.getAbsoluteX() - 2, this.getAbsoluteY() + 2, this.scrollbarMiddle.func_94211_a(), this.getHeight() - 3, this.field_73735_i);
        GuiScrollBar.func_73734_a((int)this.getAbsoluteX(), (int)this.barY, (int)(this.getAbsoluteX() + this.getWidth()), (int)(this.barY + this.barHeight), (int)-5592406);
        super.drawBackground(parentScreen, mouseX, mouseY);
    }

    public void setCurrentOffset(int offset) {
        int currentOffset = Math.max(0, Math.min(offset, (int)(Math.ceil(this.scrollTarget.getRowCount()) - (double)this.scrollTarget.getVisibleRows())));
        this.scrollTarget.setCurrentOffset(currentOffset);
        this.updatePosition();
    }
}

