/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.handler;

import biomesoplenty.api.achievement.BOPAchievements;
import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.enums.BOPTrees;
import biomesoplenty.api.item.BOPItems;
import biomesoplenty.common.block.BlockBOPFlower;
import biomesoplenty.common.block.BlockBOPLog;
import biomesoplenty.common.block.BlockBOPPlant;
import biomesoplenty.common.block.BlockBOPSapling;
import biomesoplenty.common.block.IBOPBlock;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.IJsonSerializable;
import net.minecraft.util.JsonSerializableSet;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class AchievementEventHandler {
    private static final Set<Biome> BOP_BIOMES_TO_EXPLORE = Sets.union(BOPBiomes.REG_INSTANCE.getPresentBiomes(), (Set)Biome.field_150597_n);

    @SubscribeEvent
    public void onItemPickup(PlayerEvent.ItemPickupEvent event) {
        ItemStack stack = event.pickedUp.func_92059_d();
        Item item = stack.func_77973_b();
        Block block = Block.func_149634_a((Item)item);
        EntityPlayer player = event.player;
        if (block instanceof IBOPBlock) {
            IBlockState state;
            IBlockState iBlockState = state = block != null && item instanceof ItemBlock ? block.func_176203_a(item.func_77647_b(stack.func_77960_j())) : null;
            if (block instanceof BlockBOPLog) {
                player.func_71029_a((StatBase)AchievementList.field_187983_g);
            }
            if (block != null && block == BOPBlocks.coral) {
                player.func_71029_a((StatBase)BOPAchievements.obtain_coral);
            }
            if (block != null && state == BlockBOPFlower.paging.getVariantState(BOPFlowers.MINERS_DELIGHT)) {
                player.func_71029_a((StatBase)BOPAchievements.obtain_miners_delight);
            }
            if (block != null && state == BlockBOPPlant.paging.getVariantState(BOPPlants.THORN)) {
                player.func_71029_a((StatBase)BOPAchievements.obtain_thorn);
            }
            if (block != null && state == BlockBOPFlower.paging.getVariantState(BOPFlowers.DEATHBLOOM)) {
                player.func_71029_a((StatBase)BOPAchievements.obtain_deathbloom);
            }
            if (block != null && state == BlockBOPFlower.paging.getVariantState(BOPFlowers.WILTED_LILY)) {
                player.func_71029_a((StatBase)BOPAchievements.obtain_wilted_lily);
            }
        }
        if (block != null && block instanceof BlockBOPFlower || block == Blocks.field_150328_O || block == Blocks.field_150327_N) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_flowers);
        }
        if (item != null && item == BOPItems.berries) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_berry);
        }
        if (item != null && item == BOPItems.turnip) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_turnip);
        }
        if (item != null && item == BOPItems.soul) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_soul);
        }
        if (item != null && item == BOPItems.filled_honeycomb) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_honeycomb);
        }
        if (item != null && item == BOPItems.pixie_dust) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_pixie_dust);
        }
        if (item != null && item == BOPItems.crystal_shard) {
            player.func_71029_a((StatBase)BOPAchievements.obtain_celestial_crystal);
        }
    }

    @SubscribeEvent
    public void onItemUsed(PlayerInteractEvent event) {
    }

    @SubscribeEvent
    public void onItemUsed(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getItem();
        Item item = stack.func_77973_b();
        if (event.getEntity() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            if (item == BOPItems.shroompowder) {
                player.func_71029_a((StatBase)BOPAchievements.eat_shroom_powder);
            }
        }
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.PlaceEvent event) {
        EntityPlayer player = event.getPlayer();
        IBlockState state = event.getPlacedBlock();
        if (player != null && state != null && state == BlockBOPSapling.paging.getVariantState(BOPTrees.SACRED_OAK)) {
            player.func_71029_a((StatBase)BOPAchievements.grow_sacred_oak);
        }
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        Item item = event.crafting.func_77973_b();
        EntityPlayer player = event.player;
        if (item != null && item == BOPItems.ambrosia) {
            player.func_71029_a((StatBase)BOPAchievements.craft_ambrosia);
        }
        if (item != null && item == BOPItems.flax_string) {
            player.func_71029_a((StatBase)BOPAchievements.craft_flax_string);
        }
        if (item != null && item == BOPItems.mud_pickaxe) {
            player.func_71029_a((StatBase)BOPAchievements.craft_muddy_pickaxe);
        }
        if (item != null && item == BOPItems.terrestrial_artifact) {
            player.func_71029_a((StatBase)BOPAchievements.craft_terrestrial_artifact);
        }
    }

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
    }

    private void updateBiomeRadarExplore(EntityPlayerMP player) {
        Biome currentBiome = player.field_70170_p.func_180494_b(new BlockPos(MathHelper.func_76128_c((double)player.field_70165_t), 0, MathHelper.func_76128_c((double)player.field_70161_v)));
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            int biomeIdToFind;
            if (stack == null || stack.func_77973_b() != BOPItems.biome_finder || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("biomeIDToFind") || (biomeIdToFind = stack.func_77978_p().func_74762_e("biomeIDToFind")) != Biome.func_185362_a((Biome)currentBiome)) continue;
            player.func_71029_a((StatBase)BOPAchievements.use_biome_finder);
            return;
        }
    }

    private void updateBiomesExplored(EntityPlayerMP player) {
        Biome currentBiome = player.field_70170_p.func_180494_b(new BlockPos(MathHelper.func_76128_c((double)player.field_70165_t), 0, MathHelper.func_76128_c((double)player.field_70161_v)));
        String biomeName = currentBiome.func_185359_l();
        JsonSerializableSet exploredBiomeNames = (JsonSerializableSet)player.func_147099_x().func_150870_b((StatBase)BOPAchievements.explore_all_biomes);
        if (exploredBiomeNames == null) {
            exploredBiomeNames = (JsonSerializableSet)player.func_147099_x().func_150872_a((StatBase)BOPAchievements.explore_all_biomes, (IJsonSerializable)new JsonSerializableSet());
        }
        exploredBiomeNames.add((Object)biomeName);
        if (player.func_147099_x().func_77442_b(BOPAchievements.explore_all_biomes) && exploredBiomeNames.size() >= BOP_BIOMES_TO_EXPLORE.size()) {
            HashSet set = Sets.newHashSet(BOP_BIOMES_TO_EXPLORE);
            for (String exploredBiomeName : exploredBiomeNames) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Biome biome = (Biome)iterator.next();
                    if (!biome.func_185359_l().equals(exploredBiomeName)) continue;
                    iterator.remove();
                }
                if (!set.isEmpty()) continue;
                break;
            }
            if (set.isEmpty()) {
                player.func_71029_a((StatBase)BOPAchievements.explore_all_biomes);
            }
        }
    }
}

