/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.entities;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityButterfly
extends EntityFlying
implements IMob {
    private static final DataParameter<Byte> TYPE = EntityDataManager.func_187226_a(EntityButterfly.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityButterfly(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70765_h = new ButterflyMoveHelper();
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIButterflyRandomFly());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74768_a("ButterflyType", this.getButterflyType());
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.setButterflyType(tagCompund.func_74762_e("ButterflyType"));
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        int i = this.field_70146_Z.nextInt(3);
        boolean flag = false;
        if (livingdata instanceof ButterflyTypeData) {
            i = ((ButterflyTypeData)livingdata).typeData;
            flag = true;
        } else {
            livingdata = new ButterflyTypeData(i);
        }
        this.setButterflyType(i);
        return livingdata;
    }

    public int getButterflyType() {
        return ((Byte)this.field_70180_af.func_187225_a(TYPE)).byteValue();
    }

    public void setButterflyType(int butterflyTypeId) {
        this.field_70180_af.func_187227_b(TYPE, (Object)((byte)butterflyTypeId));
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70601_bi() {
        BlockPos blockpos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (blockpos.func_177956_o() <= this.field_70170_p.func_181545_F()) {
            return false;
        }
        if (blockpos.func_177956_o() >= 90) {
            return false;
        }
        int light = this.field_70170_p.func_175671_l(blockpos);
        return light > 8 && super.func_70601_bi();
    }

    public static class ButterflyTypeData
    implements IEntityLivingData {
        public int typeData;

        public ButterflyTypeData(int type) {
            this.typeData = type;
        }
    }

    class AIButterflyRandomFly
    extends EntityAIBase {
        private EntityButterfly butterfly;
        private ButterflyMoveTargetPos targetPos;

        public AIButterflyRandomFly() {
            this.butterfly = EntityButterfly.this;
            this.targetPos = new ButterflyMoveTargetPos();
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !this.butterfly.func_70605_aq().func_75640_a();
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            Random rand = this.butterfly.func_70681_au();
            if (this.tryGoingRandomDirection(rand, 2.0)) {
                return;
            }
            if (this.tryGoingRandomDirection(rand, 2.0)) {
                return;
            }
            List<EnumFacing> directions = Arrays.asList(EnumFacing.values());
            Collections.shuffle(directions);
            for (EnumFacing facing : directions) {
                if (!this.tryGoingAlongAxis(rand, facing, 1.0)) continue;
                return;
            }
        }

        public boolean tryGoingRandomDirection(Random rand, double maxDistance) {
            double dirX = (rand.nextDouble() * 2.0 - 1.0) * maxDistance;
            double dirY = (rand.nextDouble() * 2.0 - 1.1) * maxDistance;
            double dirZ = (rand.nextDouble() * 2.0 - 1.0) * maxDistance;
            return this.tryGoing(dirX, dirY, dirZ);
        }

        public boolean tryGoingAlongAxis(Random rand, EnumFacing facing, double maxDistance) {
            double dirX = 0.0;
            double dirY = 0.0;
            double dirZ = 0.0;
            switch (facing.func_176740_k()) {
                case X: {
                    dirX = rand.nextDouble() * (double)facing.func_176743_c().func_179524_a() * maxDistance;
                    break;
                }
                case Y: {
                    dirY = rand.nextDouble() * (double)facing.func_176743_c().func_179524_a() * maxDistance;
                    break;
                }
                default: {
                    dirZ = rand.nextDouble() * (double)facing.func_176743_c().func_179524_a() * maxDistance;
                }
            }
            return this.tryGoing(dirX, dirY, dirZ);
        }

        public boolean tryGoing(double dirX, double dirY, double dirZ) {
            this.targetPos.setTarget(this.butterfly.field_70165_t + dirX, this.butterfly.field_70163_u + dirY, this.butterfly.field_70161_v + dirZ);
            boolean result = this.targetPos.isPathClear(5.0);
            if (result) {
                this.butterfly.func_70605_aq().func_75642_a(this.targetPos.posX, this.targetPos.posY, this.targetPos.posZ, 1.0);
            }
            return result;
        }
    }

    class ButterflyMoveHelper
    extends EntityMoveHelper {
        private EntityButterfly butterfly;
        private int courseChangeCooldown;
        private double closeEnough;
        private ButterflyMoveTargetPos targetPos;

        public ButterflyMoveHelper() {
            super((EntityLiving)EntityButterfly.this);
            this.butterfly = EntityButterfly.this;
            this.courseChangeCooldown = 0;
            this.closeEnough = 0.3;
            this.targetPos = new ButterflyMoveTargetPos();
        }

        public void func_75642_a(double x, double y, double z, double speedIn) {
            super.func_75642_a(x, y, z, speedIn);
            this.targetPos.setTarget(x, y, z);
        }

        public void func_75641_c() {
            if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO) {
                return;
            }
            if (this.courseChangeCooldown-- > 0) {
                return;
            }
            this.courseChangeCooldown += this.butterfly.func_70681_au().nextInt(2) + 2;
            this.targetPos.refresh();
            double acceleration = 0.1;
            this.butterfly.field_70159_w += this.targetPos.aimX * acceleration;
            this.butterfly.field_70181_x += this.targetPos.aimY * acceleration;
            this.butterfly.field_70179_y += this.targetPos.aimZ * acceleration;
            this.butterfly.field_70761_aq = this.butterfly.field_70177_z = -((float)Math.atan2(this.targetPos.distX, this.targetPos.distZ)) * 180.0f / (float)Math.PI;
            if (!this.targetPos.isPathClear(5.0)) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
            } else if (this.targetPos.dist < this.closeEnough) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
            }
        }
    }

    class ButterflyMoveTargetPos {
        private EntityButterfly butterfly;
        public double posX;
        public double posY;
        public double posZ;
        public double distX;
        public double distY;
        public double distZ;
        public double dist;
        public double aimX;
        public double aimY;
        public double aimZ;

        public ButterflyMoveTargetPos() {
            this(0.0, 0.0, 0.0);
        }

        public ButterflyMoveTargetPos(double posX, double posY, double posZ) {
            this.butterfly = EntityButterfly.this;
            this.setTarget(posX, posY, posZ);
        }

        public void setTarget(double posX, double posY, double posZ) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.refresh();
        }

        public void refresh() {
            this.distX = this.posX - this.butterfly.field_70165_t;
            this.distY = this.posY - this.butterfly.field_70163_u;
            this.distZ = this.posZ - this.butterfly.field_70161_v;
            this.dist = MathHelper.func_76133_a((double)(this.distX * this.distX + this.distY * this.distY + this.distZ * this.distZ));
            if (this.dist == 0.0) {
                this.aimX = 0.0;
                this.aimY = 0.0;
                this.aimZ = 0.0;
            } else {
                this.aimX = this.distX / this.dist;
                this.aimY = this.distY / this.dist;
                this.aimZ = this.distZ / this.dist;
            }
        }

        public boolean isBoxBlocked(AxisAlignedBB box) {
            return !this.butterfly.field_70170_p.func_184144_a((Entity)this.butterfly, box).isEmpty();
        }

        public boolean isPathClear(double howFar) {
            howFar = Math.min(howFar, this.dist);
            AxisAlignedBB box = this.butterfly.func_174813_aQ();
            for (double i = 0.5; i < howFar; i += 1.0) {
                if (!this.isBoxBlocked(box.func_72317_d(this.aimX * i, this.aimY * i, this.aimZ * i))) continue;
                return false;
            }
            return !this.isBoxBlocked(box.func_72317_d(this.aimX * howFar, this.aimY * howFar, this.aimZ * howFar));
        }
    }
}

