/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen.trees.overworld;

import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.world.worldgen.trees.BaseTreeGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.IPlantable;

public class OverworldTreeGenerator
extends BaseTreeGenerator {
    public final int minTreeHeight;
    public final int treeHeightRange;
    public final IBlockState log;
    public final IBlockState leaves;
    public final boolean seekHeight;
    public final boolean isSapling;

    public OverworldTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves, boolean seekHeight, boolean isSapling) {
        this.minTreeHeight = treeHeight;
        this.treeHeightRange = treeRange;
        this.log = log;
        this.leaves = leaves;
        this.seekHeight = seekHeight;
        this.isSapling = isSapling;
    }

    public OverworldTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves) {
        this(treeHeight, treeRange, log, leaves, true, false);
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
    }

    @Override
    public void generateTree(Random random, World world, BlockPos pos) {
        int height = random.nextInt(this.treeHeightRange) + this.minTreeHeight;
        if (this.seekHeight && (pos = this.findGround(world, pos)).func_177956_o() < 0) {
            return;
        }
        int yPos = pos.func_177956_o();
        if (yPos >= 1 && yPos + height + 1 <= 256) {
            boolean isSoil;
            IBlockState state = world.func_180495_p(pos.func_177977_b());
            Block soil = state.func_177230_c();
            boolean bl = isSoil = soil != null && soil.canSustainPlant(state, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)NaturaOverworld.overworldSapling);
            if (isSoil) {
                if (!this.checkClear(world, pos.func_177958_n(), yPos, pos.func_177956_o(), height)) {
                    return;
                }
                soil.onPlantGrow(state, world, pos.func_177977_b(), pos);
                this.placeCanopy(world, random, pos, height);
                this.placeTrunk(world, pos, height);
            }
        }
    }

    boolean checkClear(World world, int x, int y, int z, int treeHeight) {
        for (int yPos = 0; yPos < treeHeight + 1; ++yPos) {
            int range = 1;
            if (yPos == 0) {
                range = 0;
            } else if (yPos >= treeHeight - 1) {
                range = 2;
            }
            for (int xPos = range; xPos <= range; ++xPos) {
                for (int zPos = range; zPos <= range; ++zPos) {
                    BlockPos blockpos = new BlockPos(x + xPos, y + yPos, z + zPos);
                    IBlockState state = world.func_180495_p(blockpos);
                    if ((state.func_177230_c() == null || state.func_177230_c() == NaturaOverworld.overworldSapling) && state.func_177230_c().isLeaves(state, (IBlockAccess)world, blockpos)) continue;
                    return true;
                }
            }
        }
        return true;
    }

    BlockPos findGround(World world, BlockPos pos) {
        int returnHeight = 0;
        int height = pos.func_177956_o();
        if (world.func_175624_G() == WorldType.field_77138_c && this.isSapling) {
            do {
                BlockPos position;
                Block block;
                if ((block = world.func_180495_p(position = new BlockPos(pos.func_177958_n(), height, pos.func_177952_p())).func_177230_c()) != Blocks.field_150346_d && block != Blocks.field_150349_c || world.func_180495_p(position.func_177984_a()).func_185913_b()) continue;
                returnHeight = height + 1;
                break;
            } while (--height > Config.flatSeaLevel);
            return new BlockPos(pos.func_177958_n(), returnHeight, pos.func_177952_p());
        }
        do {
            BlockPos position;
            Block block;
            if ((block = world.func_180495_p(position = new BlockPos(pos.func_177958_n(), height, pos.func_177952_p())).func_177230_c()) != Blocks.field_150346_d && block != Blocks.field_150349_c || world.func_180495_p(position.func_177984_a()).func_185913_b()) continue;
            returnHeight = height + 1;
            break;
        } while (--height > Config.seaLevel);
        return new BlockPos(pos.func_177958_n(), returnHeight, pos.func_177952_p());
    }

    protected void placeCanopy(World world, Random random, BlockPos pos, int height) {
        for (int y = pos.func_177956_o() - 3 + height; y <= pos.func_177956_o() + height; ++y) {
            int subract = y - (pos.func_177956_o() + height);
            int subract2 = 1 - subract / 2;
            for (int x = pos.func_177958_n() - subract2; x <= pos.func_177958_n() + subract2; ++x) {
                int mathX = x - pos.func_177958_n();
                for (int z = pos.func_177952_p() - subract2; z <= pos.func_177952_p() + subract2; ++z) {
                    BlockPos blockpos;
                    IBlockState state;
                    int mathZ = z - pos.func_177952_p();
                    if (Math.abs(mathX) == subract2 && Math.abs(mathZ) == subract2 && (random.nextInt(2) == 0 || subract == 0) || !(state = world.func_180495_p(blockpos = new BlockPos(x, y, z))).func_177230_c().isAir(state, (IBlockAccess)world, blockpos) && !state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, blockpos)) continue;
                    world.func_180501_a(blockpos, this.leaves, 2);
                }
            }
        }
    }

    protected void placeTrunk(World world, BlockPos pos, int height) {
        for (int localHeight = 0; localHeight < height; ++localHeight) {
            BlockPos blockpos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + localHeight, pos.func_177952_p());
            IBlockState state = world.func_180495_p(blockpos);
            Block block = state.func_177230_c();
            if (!block.isAir(state, (IBlockAccess)world, blockpos) && block != null && !block.isLeaves(state, (IBlockAccess)world, blockpos)) continue;
            world.func_180501_a(blockpos, this.log, 2);
        }
    }
}

