/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen.trees.overworld;

import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.overworld.NaturaOverworld;
import com.progwml6.natura.world.worldgen.trees.BaseTreeGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.IPlantable;

public class HopseedTreeGenerator
extends BaseTreeGenerator {
    public final int minTreeHeight;
    public final int treeHeightRange;
    public final IBlockState log;
    public final IBlockState leaves;
    public final boolean seekHeight;
    public final boolean isSapling;

    public HopseedTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves, boolean seekHeight, boolean isSapling) {
        this.minTreeHeight = treeHeight;
        this.treeHeightRange = treeRange;
        this.log = log;
        this.leaves = leaves;
        this.seekHeight = seekHeight;
        this.isSapling = isSapling;
    }

    public HopseedTreeGenerator(int treeHeight, int treeRange, IBlockState log, IBlockState leaves) {
        this(treeHeight, treeRange, log, leaves, true, false);
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
    }

    @Override
    public void generateTree(Random random, World worldIn, BlockPos position) {
        int height = random.nextInt(this.treeHeightRange) + this.minTreeHeight;
        if (this.seekHeight && (position = this.findGround(worldIn, position)).func_177956_o() < 0) {
            return;
        }
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            int l;
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + height; ++j) {
                int k = 2;
                if (j == position.func_177956_o()) {
                    k = 1;
                }
                if (j >= position.func_177956_o() + 1 + height - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos mutableblockpos = new BlockPos.MutableBlockPos();
                for (l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < 256) {
                            if (this.isReplaceable(worldIn, (BlockPos)mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (flag) {
                boolean isSoil;
                BlockPos downPosition = position.func_177977_b();
                IBlockState state = worldIn.func_180495_p(downPosition);
                boolean bl = isSoil = state.func_177230_c() != null && state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, downPosition, EnumFacing.UP, (IPlantable)NaturaOverworld.overworldSapling2);
                if (isSoil && position.func_177956_o() < 256 - height - 1) {
                    this.onPlantGrow(worldIn, downPosition, position);
                    this.onPlantGrow(worldIn, downPosition.func_177974_f(), position);
                    this.onPlantGrow(worldIn, downPosition.func_177968_d(), position);
                    this.onPlantGrow(worldIn, downPosition.func_177968_d().func_177974_f(), position);
                    this.growLogs(worldIn, position);
                    this.growLeaves(worldIn, random, position, height);
                    for (l = 0; l < height; ++l) {
                        BlockPos blockpos = position.func_177981_b(l);
                        IBlockState newState = worldIn.func_180495_p(blockpos);
                        if (newState.func_177230_c() == Blocks.field_150350_a || newState.func_177230_c() == null || newState.func_177230_c().isLeaves(newState, (IBlockAccess)worldIn, blockpos)) {
                            worldIn.func_180501_a(blockpos, this.log, 0);
                        }
                        if (l >= height - 1) continue;
                        blockpos = position.func_177982_a(1, l, 0);
                        newState = worldIn.func_180495_p(blockpos);
                        if (newState.func_177230_c() == Blocks.field_150350_a || newState.func_177230_c() == null || newState.func_177230_c().isLeaves(newState, (IBlockAccess)worldIn, blockpos)) {
                            worldIn.func_180501_a(blockpos, this.log, 0);
                        }
                        if ((newState = worldIn.func_180495_p(blockpos = position.func_177982_a(1, l, 1))).func_177230_c() == Blocks.field_150350_a || newState.func_177230_c() == null || newState.func_177230_c().isLeaves(newState, (IBlockAccess)worldIn, blockpos)) {
                            worldIn.func_180501_a(blockpos, this.log, 0);
                        }
                        if ((newState = worldIn.func_180495_p(blockpos = position.func_177982_a(0, l, 1))).func_177230_c() != Blocks.field_150350_a && newState.func_177230_c() != null && !newState.func_177230_c().isLeaves(newState, (IBlockAccess)worldIn, blockpos)) continue;
                        worldIn.func_180501_a(blockpos, this.log, 0);
                    }
                }
            }
        }
    }

    BlockPos findGround(World world, BlockPos pos) {
        if (world.func_175624_G() == WorldType.field_77138_c && this.isSapling) {
            int returnHeight = 0;
            boolean foundGround = false;
            int height = Config.flatSeaLevel + 64;
            do {
                BlockPos position;
                Block underBlock;
                if ((underBlock = world.func_180495_p(position = new BlockPos(pos.func_177958_n(), --height, pos.func_177952_p())).func_177230_c()) != Blocks.field_150346_d && underBlock != Blocks.field_150349_c && height >= Config.flatSeaLevel) continue;
                returnHeight = height + 1;
                foundGround = true;
            } while (!foundGround);
            return new BlockPos(pos.func_177958_n(), returnHeight, pos.func_177952_p());
        }
        int returnHeight = 0;
        boolean foundGround = false;
        int height = Config.seaLevel + 64;
        do {
            BlockPos position;
            Block underBlock;
            if ((underBlock = world.func_180495_p(position = new BlockPos(pos.func_177958_n(), --height, pos.func_177952_p())).func_177230_c()) != Blocks.field_150346_d && underBlock != Blocks.field_150349_c && height >= Config.seaLevel) continue;
            returnHeight = height + 1;
            foundGround = true;
        } while (!foundGround);
        return new BlockPos(pos.func_177958_n(), returnHeight, pos.func_177952_p());
    }

    private void growLogs(World worldIn, BlockPos position) {
        this.setBlockAndMetadata(worldIn, position, this.log);
        this.setBlockAndMetadata(worldIn, position.func_177982_a(1, 0, 0), this.log);
        this.setBlockAndMetadata(worldIn, position.func_177982_a(0, 0, 1), this.log);
        this.setBlockAndMetadata(worldIn, position.func_177982_a(1, 0, 1), this.log);
        this.setBlockAndMetadata(worldIn, position.func_177982_a(0, 1, 0), this.log);
        this.setBlockAndMetadata(worldIn, position.func_177982_a(1, 1, 0), this.log);
        this.setBlockAndMetadata(worldIn, position.func_177982_a(0, 1, 1), this.log);
        this.setBlockAndMetadata(worldIn, position.func_177982_a(1, 1, 1), this.log);
    }

    protected void growLeaves(World world, Random random, BlockPos pos, int height) {
        for (int y = pos.func_177956_o() - 2 + height; y <= pos.func_177956_o() + height; ++y) {
            int subract = y - (pos.func_177956_o() + height);
            int subract2 = 3 - subract;
            for (int x = pos.func_177958_n() - subract2; x <= pos.func_177958_n() + subract2; ++x) {
                int mathX = x - pos.func_177958_n();
                for (int z = pos.func_177952_p() - subract2; z <= pos.func_177952_p() + subract2; ++z) {
                    int mathZ = z - pos.func_177952_p();
                    BlockPos blockpos = new BlockPos(x, y, z);
                    IBlockState state = world.func_180495_p(blockpos);
                    if (mathX < 0 && mathZ < 0 && mathX * mathX + mathZ * mathZ > subract2 * subract2 || (mathX > 0 || mathZ > 0) && mathX * mathX + mathZ * mathZ > (subract2 + 1) * (subract2 + 1) || random.nextInt(4) == 0 && mathX * mathX + mathZ * mathZ > (subract2 - 1) * (subract2 - 1) || !state.func_177230_c().isAir(state, (IBlockAccess)world, blockpos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)world, blockpos) && !state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, blockpos)) continue;
                    this.setBlockAndMetadata(world, blockpos, this.leaves);
                }
            }
        }
    }

    protected void setBlockAndMetadata(World world, BlockPos pos, IBlockState stateNew) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos) || block.func_176196_c(world, pos) || world.func_180495_p(pos) == this.leaves) {
            world.func_180501_a(pos, stateNew, 2);
        }
    }

    public boolean isReplaceable(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) || state.func_177230_c().isWood((IBlockAccess)world, pos);
    }

    private void onPlantGrow(World world, BlockPos pos, BlockPos source) {
        IBlockState state = world.func_180495_p(pos);
        state.func_177230_c().onPlantGrow(state, world, pos, source);
    }
}

