/*
 * Decompiled with CFR 0.152.
 */
package com.progwml6.natura.world.worldgen;

import com.progwml6.natura.common.config.Config;
import com.progwml6.natura.nether.NaturaNether;
import com.progwml6.natura.world.worldgen.vine.ThornvinesGenerator;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class VineGenerator
implements IWorldGenerator {
    public static VineGenerator INSTANCE = new VineGenerator();
    ThornvinesGenerator thornvinesGen = new ThornvinesGenerator(NaturaNether.netherThornVines.func_176223_P());

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        this.generateNether(random, chunkX, chunkZ, world);
    }

    public void retroGen(Random random, int chunkX, int chunkZ, World world) {
        this.generateNether(random, chunkX, chunkZ, world);
        world.func_72964_e(chunkX, chunkZ).func_76630_e();
    }

    public void generateNether(Random random, int chunkX, int chunkZ, World world) {
        int xPos = chunkX * 16 + 8;
        int zPos = chunkZ * 16 + 8;
        BlockPos chunkPos = new BlockPos(xPos, 0, zPos);
        Biome biome = world.func_175726_f(chunkPos).func_177411_a(chunkPos, world.func_72959_q());
        if (biome == null) {
            return;
        }
        if (BiomeDictionary.isBiomeOfType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) && Config.generateThornvines && random.nextInt(Config.thornSpawnRarity) == 0) {
            int ySpawn = 108;
            for (int i = 0; i < 20; ++i) {
                IBlockState vine = this.thornvinesGen.getRandomizedVine(random);
                int xSpawn = xPos + random.nextInt(16);
                int zSpawn = zPos + random.nextInt(16);
                int size = random.nextInt(25) + 1;
                int height = ySpawn - (random.nextInt(size) + random.nextInt(size) + random.nextInt(size));
                for (int yHeight = ySpawn; yHeight > height; --yHeight) {
                    BlockPos position = new BlockPos(xSpawn, yHeight, zSpawn);
                    this.thornvinesGen.generateVines(random, world, position, vine);
                }
            }
        }
    }
}

