/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.powerSystem.mixin;

import cofh.api.energy.IEnergyContainerItem;
import net.minecraft.item.ItemStack;
import reborncore.api.power.IEnergyInterfaceItem;
import reborncore.common.RebornCoreConfig;
import reborncore.mixin.api.Inject;
import reborncore.mixin.api.Mixin;

@Mixin(target="")
public class RFItemPowerMixin
implements IEnergyContainerItem {
    @Override
    @Inject
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (!RebornCoreConfig.getRebornPower().rf()) {
            return 0;
        }
        if (!this.getRFInterface().canAcceptEnergy(container)) {
            return 0;
        }
        int energyReceived = Math.min(this.getMaxEnergyStored(container) - this.getEnergyStored(container), Math.min((int)this.getRFInterface().getMaxTransfer(container) * RebornCoreConfig.euPerRF, maxReceive *= RebornCoreConfig.euPerRF));
        if (!simulate) {
            this.getRFInterface().setEnergy(this.getRFInterface().getEnergy(container) + (double)energyReceived, container);
        }
        return energyReceived / RebornCoreConfig.euPerRF;
    }

    @Override
    @Inject
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (!RebornCoreConfig.getRebornPower().rf()) {
            return 0;
        }
        if (!this.getRFInterface().canAcceptEnergy(container)) {
            return 0;
        }
        int energyExtracted = Math.min(this.getEnergyStored(container), Math.min(maxExtract *= RebornCoreConfig.euPerRF, maxExtract));
        if (!simulate) {
            this.getRFInterface().setEnergy(this.getRFInterface().getEnergy(container) - (double)energyExtracted, container);
        }
        return energyExtracted / RebornCoreConfig.euPerRF;
    }

    @Override
    @Inject
    public int getEnergyStored(ItemStack container) {
        if (!RebornCoreConfig.getRebornPower().rf()) {
            return 0;
        }
        return (int)this.getRFInterface().getEnergy(container) / RebornCoreConfig.euPerRF;
    }

    @Override
    @Inject
    public int getMaxEnergyStored(ItemStack container) {
        if (!RebornCoreConfig.getRebornPower().rf()) {
            return 0;
        }
        return (int)this.getRFInterface().getMaxPower(container) / RebornCoreConfig.euPerRF;
    }

    @Inject
    public IEnergyInterfaceItem getRFInterface() {
        return (IEnergyInterfaceItem)((Object)this);
    }
}

