/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterChannel;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IWriter;
import com.raoulvdberge.refinedstorage.tile.TileMultipartNode;
import com.raoulvdberge.refinedstorage.tile.TileReader;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class TileWriter
extends TileMultipartNode
implements IWriter {
    private static final String NBT_CHANNEL = "Channel";
    private static final TileDataParameter<String> CHANNEL = TileReader.createChannelParameter();
    private String channel = "";
    private int redstoneStrength;
    private int lastRedstoneStrength;

    public TileWriter() {
        this.dataManager.addWatchedParameter(CHANNEL);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.writerUsage;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.func_145831_w().field_72995_K && this.getRedstoneStrength() != this.lastRedstoneStrength) {
            this.lastRedstoneStrength = this.getRedstoneStrength();
            this.func_145831_w().func_175685_c(this.field_174879_c, (Block)RSBlocks.WRITER);
        }
    }

    @Override
    public void updateNode() {
    }

    @Override
    public int getRedstoneStrength() {
        return this.connected ? this.redstoneStrength : 0;
    }

    @Override
    public void setRedstoneStrength(int strength) {
        this.redstoneStrength = strength;
    }

    @Override
    public String getTitle() {
        return "gui.refinedstorage:writer";
    }

    @Override
    public String getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(String channel) {
        IReaderWriterChannel networkChannel;
        if (this.network != null && channel.equals("") && (networkChannel = this.network.getReaderWriterChannel(this.channel)) != null) {
            for (IReaderWriterHandler handler : networkChannel.getHandlers()) {
                handler.onWriterDisabled(this);
            }
        }
        this.channel = channel;
    }

    @Override
    public TileDataParameter<String> getChannelParameter() {
        return CHANNEL;
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_74764_b(NBT_CHANNEL)) {
            this.channel = tag.func_74779_i(NBT_CHANNEL);
        }
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_74778_a(NBT_CHANNEL, this.channel);
        return tag;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (super.hasCapability(capability, facing)) {
            return true;
        }
        if (facing != this.getDirection() || this.network == null) {
            return false;
        }
        IReaderWriterChannel channel = this.network.getReaderWriterChannel(this.channel);
        if (channel == null) {
            return false;
        }
        for (IReaderWriterHandler handler : channel.getHandlers()) {
            if (!handler.hasCapability(this, capability)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        T foundCapability = super.getCapability(capability, facing);
        if (foundCapability == null) {
            if (facing != this.getDirection() || this.network == null) {
                return null;
            }
            IReaderWriterChannel channel = this.network.getReaderWriterChannel(this.channel);
            if (channel == null) {
                return null;
            }
            for (IReaderWriterHandler handler : channel.getHandlers()) {
                foundCapability = handler.getCapability(this, capability);
                if (foundCapability == null) continue;
                return foundCapability;
            }
        }
        return foundCapability;
    }

    @Override
    public void setDirection(EnumFacing direction) {
        super.setDirection(direction);
        this.func_145831_w().func_175685_c(this.field_174879_c, (Block)RSBlocks.WRITER);
    }

    public void onOpened(EntityPlayer entity) {
        if (this.isConnected()) {
            this.network.sendReaderWriterChannelUpdate((EntityPlayerMP)entity);
        }
    }
}

