/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.apiimpl.storage.fluid.FluidStorageNBT;
import com.raoulvdberge.refinedstorage.apiimpl.storage.item.ItemStorageNBT;
import com.raoulvdberge.refinedstorage.block.EnumFluidStorageType;
import com.raoulvdberge.refinedstorage.block.EnumItemStorageType;
import com.raoulvdberge.refinedstorage.inventory.IItemValidator;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBasic;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFluid;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.tile.TileDiskDrive;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.tile.data.ITileDataConsumer;
import com.raoulvdberge.refinedstorage.tile.data.ITileDataProducer;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class TileDiskManipulator
extends TileNode
implements IComparable,
IFilterable,
IType {
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> MODE = IFilterable.createParameter();
    public static final TileDataParameter<Integer> TYPE = IType.createParameter();
    public static final int IO_MODE_INSERT = 0;
    public static final int IO_MODE_EXTRACT = 1;
    public static final TileDataParameter<Integer> IO_MODE = new TileDataParameter<Integer>(DataSerializers.field_187192_b, 0, new ITileDataProducer<Integer, TileDiskManipulator>(){

        @Override
        public Integer getValue(TileDiskManipulator tile) {
            return tile.ioMode;
        }
    }, new ITileDataConsumer<Integer, TileDiskManipulator>(){

        @Override
        public void setValue(TileDiskManipulator tile, Integer value) {
            tile.ioMode = value;
            tile.func_70296_d();
        }
    });
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_IO_MODE = "IOMode";
    private int compare = 3;
    private int mode = 0;
    private int type = 0;
    private int ioMode = 0;
    private ItemStorage[] itemStorages = new ItemStorage[6];
    private FluidStorage[] fluidStorages = new FluidStorage[6];
    private Integer[] diskState = new Integer[6];
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (TileEntity)this, 2, 4);
    private ItemHandlerBasic inputDisks = new ItemHandlerBasic(3, this, new IItemValidator[]{IItemValidator.STORAGE_DISK}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                RSUtils.createStorages(this.getStackInSlot(slot), slot, TileDiskManipulator.this.itemStorages, TileDiskManipulator.this.fluidStorages, s -> new ItemStorage((ItemStack)s), s -> new FluidStorage((ItemStack)s));
                TileDiskManipulator.this.updateBlock();
            }
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (TileDiskManipulator.this.itemStorages[slot] != null) {
                TileDiskManipulator.this.itemStorages[slot].writeToNBT();
            }
            if (TileDiskManipulator.this.fluidStorages[slot] != null) {
                TileDiskManipulator.this.fluidStorages[slot].writeToNBT();
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    private ItemHandlerBasic outputDisks = new ItemHandlerBasic(3, this, new IItemValidator[]{IItemValidator.STORAGE_DISK}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                RSUtils.createStorages(this.getStackInSlot(slot), 3 + slot, TileDiskManipulator.this.itemStorages, TileDiskManipulator.this.fluidStorages, s -> new ItemStorage((ItemStack)s), s -> new FluidStorage((ItemStack)s));
                TileDiskManipulator.this.updateBlock();
            }
        }
    };
    private ItemHandlerBasic itemFilters = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemHandlerFluid fluidFilters = new ItemHandlerFluid(9, this);

    public TileDiskManipulator() {
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(TYPE);
        this.dataManager.addWatchedParameter(IO_MODE);
        TileDiskDrive.initDiskState(this.diskState);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.diskManipulatorUsage + this.upgrades.getEnergyUsage();
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }

    @Override
    public void updateNode() {
        int slot;
        if (this.ticks % this.upgrades.getSpeed() != 0) {
            return;
        }
        if (this.type == 0) {
            for (slot = 0; slot < 3 && this.itemStorages[slot] == null; ++slot) {
            }
            if (slot == 3) {
                return;
            }
            ItemStorage storage = this.itemStorages[slot];
            if (this.ioMode == 0) {
                this.insertIntoNetwork(storage, slot);
            } else if (this.ioMode == 1) {
                this.extractFromNetwork(storage, slot);
            }
        } else if (this.type == 1) {
            while (slot < 3 && this.fluidStorages[slot] == null) {
                ++slot;
            }
            if (slot == 3) {
                return;
            }
            FluidStorage storage = this.fluidStorages[slot];
            if (this.ioMode == 0) {
                this.insertIntoNetwork(storage, slot);
            } else if (this.ioMode == 1) {
                this.extractFromNetwork(storage, slot);
            }
        }
    }

    private void insertIntoNetwork(ItemStorage storage, int slot) {
        if (storage.getStored() == 0) {
            this.moveDriveToOutput(slot);
            return;
        }
        for (int i = 0; i < storage.getStacks().size(); ++i) {
            ItemStack extracted;
            ItemStack stack = storage.getStacks().get(i);
            if (stack == null || (extracted = storage.extractItem(stack, this.upgrades.getInteractStackSize(), this.compare, false)) == null) continue;
            ItemStack remainder = this.network.insertItem(extracted, extracted.field_77994_a, false);
            if (remainder == null) break;
            storage.insertItem(extracted == remainder ? remainder.func_77946_l() : remainder, remainder.field_77994_a, false);
        }
        if (storage.getStacks().size() == 0) {
            this.moveDriveToOutput(slot);
        }
    }

    private void extractFromNetwork(ItemStorage storage, int slot) {
        if (storage.getStored() == storage.getCapacity()) {
            this.moveDriveToOutput(slot);
            return;
        }
        ItemStack extracted = null;
        int i = 0;
        if (IFilterable.isEmpty((IItemHandler)this.itemFilters)) {
            ItemStack toExtract = null;
            ArrayList<ItemStack> networkItems = new ArrayList<ItemStack>(this.network.getItemStorageCache().getList().getStacks());
            int j = 0;
            while ((toExtract == null || toExtract.field_77994_a == 0) && j < networkItems.size()) {
                toExtract = networkItems.get(j++);
            }
            if (toExtract != null) {
                extracted = this.network.extractItem(toExtract, this.upgrades.getInteractStackSize(), this.compare, false);
            }
        } else {
            while (this.itemFilters.getSlots() > i && extracted == null) {
                ItemStack stack = null;
                while (this.itemFilters.getSlots() > i && stack == null) {
                    stack = this.itemFilters.getStackInSlot(i++);
                }
                if (stack == null) continue;
                extracted = this.network.extractItem(stack, this.upgrades.getInteractStackSize(), this.compare, false);
            }
        }
        if (extracted == null) {
            this.moveDriveToOutput(slot);
            return;
        }
        ItemStack remainder = storage.insertItem(extracted, extracted.field_77994_a, false);
        if (remainder != null) {
            this.network.insertItem(remainder, remainder.field_77994_a, false);
        }
    }

    private void insertIntoNetwork(FluidStorage storage, int slot) {
        if (storage.getStored() == 0) {
            this.moveDriveToOutput(slot);
            return;
        }
        FluidStack extracted = null;
        int i = 0;
        while (extracted == null && storage.getStacks().size() > i) {
            FluidStack stack = storage.getStacks().get(i++);
            extracted = storage.extractFluid(stack, this.upgrades.getInteractStackSize(), this.compare, false);
        }
        if (extracted == null) {
            this.moveDriveToOutput(slot);
            return;
        }
        FluidStack remainder = this.network.insertFluid(extracted, extracted.amount, false);
        if (remainder != null) {
            storage.insertFluid(remainder, remainder.amount, false);
        }
    }

    private void extractFromNetwork(FluidStorage storage, int slot) {
        if (storage.getStored() == storage.getCapacity()) {
            this.moveDriveToOutput(slot);
            return;
        }
        FluidStack extracted = null;
        int i = 0;
        if (IFilterable.isEmpty((IItemHandler)this.itemFilters)) {
            FluidStack toExtract = null;
            ArrayList<FluidStack> networkFluids = new ArrayList<FluidStack>(this.network.getFluidStorageCache().getList().getStacks());
            int j = 0;
            while ((toExtract == null || toExtract.amount == 0) && j < networkFluids.size()) {
                toExtract = networkFluids.get(j++);
            }
            if (toExtract != null) {
                extracted = this.network.extractFluid(toExtract, this.upgrades.getInteractStackSize(), this.compare, false);
            }
        } else {
            while (this.fluidFilters.getSlots() > i && extracted == null) {
                FluidStack stack = null;
                while (this.fluidFilters.getSlots() > i && stack == null) {
                    stack = this.fluidFilters.getFluidStackInSlot(i++);
                }
                if (stack == null) continue;
                extracted = this.network.extractFluid(stack, this.upgrades.getInteractStackSize(), this.compare, false);
            }
        }
        if (extracted == null) {
            this.moveDriveToOutput(slot);
            return;
        }
        FluidStack remainder = storage.insertFluid(extracted, extracted.amount, false);
        if (remainder != null) {
            this.network.insertFluid(remainder, remainder.amount, false);
        }
    }

    private void moveDriveToOutput(int slot) {
        ItemStack disk = this.inputDisks.getStackInSlot(slot);
        if (disk != null) {
            int i;
            for (i = 0; i < 3 && this.outputDisks.getStackInSlot(i) != null; ++i) {
            }
            if (i == 3) {
                return;
            }
            if (slot < 3) {
                if (this.itemStorages[slot] != null) {
                    this.itemStorages[slot].writeToNBT();
                    this.itemStorages[slot] = null;
                }
                if (this.fluidStorages[slot] != null) {
                    this.fluidStorages[slot].writeToNBT();
                    this.fluidStorages[slot] = null;
                }
            }
            this.inputDisks.extractItem(slot, 1, false);
            this.outputDisks.insertItem(i, disk, false);
        }
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilters : this.fluidFilters;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    public IItemHandler getInputDisks() {
        return this.inputDisks;
    }

    public IItemHandler getOutputDisks() {
        return this.outputDisks;
    }

    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        RSUtils.readItems((IItemHandlerModifiable)this.upgrades, 3, tag);
        RSUtils.readItems((IItemHandlerModifiable)this.inputDisks, 4, tag);
        RSUtils.readItems((IItemHandlerModifiable)this.outputDisks, 5, tag);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        this.onBreak();
        RSUtils.writeItems((IItemHandler)this.upgrades, 3, tag);
        RSUtils.writeItems((IItemHandler)this.inputDisks, 4, tag);
        RSUtils.writeItems((IItemHandler)this.outputDisks, 5, tag);
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        RSUtils.writeItems((IItemHandler)this.itemFilters, 1, tag);
        RSUtils.writeItems((IItemHandler)this.fluidFilters, 2, tag);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        tag.func_74768_a(NBT_IO_MODE, this.ioMode);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        RSUtils.readItems((IItemHandlerModifiable)this.itemFilters, 1, tag);
        RSUtils.readItems((IItemHandlerModifiable)this.fluidFilters, 2, tag);
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        if (tag.func_74764_b(NBT_IO_MODE)) {
            this.ioMode = tag.func_74762_e(NBT_IO_MODE);
        }
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        TileDiskDrive.writeDiskState(tag, 6, this.connected, this.itemStorages, this.fluidStorages);
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        super.readUpdate(tag);
        TileDiskDrive.readDiskState(tag, this.diskState);
    }

    public Integer[] getDiskState() {
        return this.diskState;
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inputDisks, this.outputDisks, this.upgrades});
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)(facing == EnumFacing.DOWN ? this.outputDisks : this.inputDisks));
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public void onBreak() {
        for (ItemStorage itemStorage : this.itemStorages) {
            if (itemStorage == null) continue;
            itemStorage.writeToNBT();
        }
        for (IStorage<ItemStack> iStorage : this.fluidStorages) {
            if (iStorage == null) continue;
            ((FluidStorageNBT)iStorage).writeToNBT();
        }
    }

    public class FluidStorage
    extends FluidStorageNBT {
        private int lastState;

        public FluidStorage(ItemStack disk) {
            super(disk.func_77978_p(), EnumFluidStorageType.getById(disk.func_77952_i()).getCapacity(), TileDiskManipulator.this);
            this.lastState = TileDiskDrive.getDiskState(this.getStored(), this.getCapacity());
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public FluidStack insertFluid(FluidStack stack, int size, boolean simulate) {
            if (!IFilterable.canTakeFluids(TileDiskManipulator.this.fluidFilters, TileDiskManipulator.this.mode, TileDiskManipulator.this.getCompare(), stack)) {
                return RSUtils.copyStackWithSize(stack, size);
            }
            return super.insertFluid(stack, size, simulate);
        }

        @Override
        public FluidStack extractFluid(FluidStack stack, int size, int flags, boolean simulate) {
            if (!IFilterable.canTakeFluids(TileDiskManipulator.this.fluidFilters, TileDiskManipulator.this.mode, TileDiskManipulator.this.getCompare(), stack)) {
                return null;
            }
            return super.extractFluid(stack, size, flags, simulate);
        }

        @Override
        public void onStorageChanged() {
            super.onStorageChanged();
            int currentState = TileDiskDrive.getDiskState(this.getStored(), this.getCapacity());
            if (this.lastState != currentState) {
                this.lastState = currentState;
                TileDiskManipulator.this.updateBlock();
            }
        }
    }

    public class ItemStorage
    extends ItemStorageNBT {
        private int lastState;

        public ItemStorage(ItemStack disk) {
            super(disk.func_77978_p(), EnumItemStorageType.getById(disk.func_77952_i()).getCapacity(), TileDiskManipulator.this);
            this.lastState = TileDiskDrive.getDiskState(this.getStored(), this.getCapacity());
        }

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public ItemStack insertItem(ItemStack stack, int size, boolean simulate) {
            if (!IFilterable.canTake((IItemHandler)TileDiskManipulator.this.itemFilters, TileDiskManipulator.this.mode, TileDiskManipulator.this.getCompare(), stack)) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
            }
            return super.insertItem(stack, size, simulate);
        }

        @Override
        public ItemStack extractItem(ItemStack stack, int size, int flags, boolean simulate) {
            if (!IFilterable.canTake((IItemHandler)TileDiskManipulator.this.itemFilters, TileDiskManipulator.this.mode, TileDiskManipulator.this.getCompare(), stack)) {
                return null;
            }
            return super.extractItem(stack, size, flags, simulate);
        }

        @Override
        public void onStorageChanged() {
            super.onStorageChanged();
            int currentState = TileDiskDrive.getDiskState(this.getStored(), this.getCapacity());
            if (this.lastState != currentState) {
                this.lastState = currentState;
                TileDiskManipulator.this.updateBlock();
            }
        }
    }
}

