/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.tile;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.RSUtils;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.fluid.IFluidStorage;
import com.raoulvdberge.refinedstorage.api.storage.fluid.IFluidStorageProvider;
import com.raoulvdberge.refinedstorage.api.storage.item.IItemStorage;
import com.raoulvdberge.refinedstorage.api.storage.item.IItemStorageProvider;
import com.raoulvdberge.refinedstorage.apiimpl.storage.fluid.FluidStorageNBT;
import com.raoulvdberge.refinedstorage.apiimpl.storage.item.ItemStorageNBT;
import com.raoulvdberge.refinedstorage.block.EnumFluidStorageType;
import com.raoulvdberge.refinedstorage.block.EnumItemStorageType;
import com.raoulvdberge.refinedstorage.inventory.IItemValidator;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerBasic;
import com.raoulvdberge.refinedstorage.inventory.ItemHandlerFluid;
import com.raoulvdberge.refinedstorage.tile.IStorageGui;
import com.raoulvdberge.refinedstorage.tile.TileNode;
import com.raoulvdberge.refinedstorage.tile.config.IAccessType;
import com.raoulvdberge.refinedstorage.tile.config.IComparable;
import com.raoulvdberge.refinedstorage.tile.config.IExcessVoidable;
import com.raoulvdberge.refinedstorage.tile.config.IFilterable;
import com.raoulvdberge.refinedstorage.tile.config.IPrioritizable;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileDiskDrive
extends TileNode
implements IItemStorageProvider,
IFluidStorageProvider,
IStorageGui,
IComparable,
IFilterable,
IPrioritizable,
IType,
IExcessVoidable,
IAccessType {
    public static final TileDataParameter<Integer> PRIORITY = IPrioritizable.createParameter();
    public static final TileDataParameter<Integer> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer> MODE = IFilterable.createParameter();
    public static final TileDataParameter<Integer> TYPE = IType.createParameter();
    public static final TileDataParameter<Boolean> VOID_EXCESS = IExcessVoidable.createParameter();
    public static final TileDataParameter<AccessType> ACCESS_TYPE = IAccessType.createParameter();
    private static final String NBT_PRIORITY = "Priority";
    private static final String NBT_COMPARE = "Compare";
    private static final String NBT_MODE = "Mode";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_VOID_EXCESS = "VoidExcess";
    private static final String NBT_DISK_STATE = "DiskState_%d";
    public static final int DISK_STATE_NORMAL = 0;
    public static final int DISK_STATE_NEAR_CAPACITY = 1;
    public static final int DISK_STATE_FULL = 2;
    public static final int DISK_STATE_DISCONNECTED = 3;
    public static final int DISK_STATE_NONE = 4;
    private ItemHandlerBasic disks = new ItemHandlerBasic(8, this, new IItemValidator[]{IItemValidator.STORAGE_DISK}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                RSUtils.createStorages(this.getStackInSlot(slot), slot, TileDiskDrive.this.itemStorages, TileDiskDrive.this.fluidStorages, s -> new ItemStorage((ItemStack)s), s -> new FluidStorage((ItemStack)s));
                if (TileDiskDrive.this.network != null) {
                    TileDiskDrive.this.network.getItemStorageCache().invalidate();
                    TileDiskDrive.this.network.getFluidStorageCache().invalidate();
                }
                TileDiskDrive.this.updateBlock();
            }
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (TileDiskDrive.this.itemStorages[slot] != null) {
                TileDiskDrive.this.itemStorages[slot].writeToNBT();
            }
            if (TileDiskDrive.this.fluidStorages[slot] != null) {
                TileDiskDrive.this.fluidStorages[slot].writeToNBT();
            }
            return super.extractItem(slot, amount, simulate);
        }
    };
    private ItemHandlerBasic itemFilters = new ItemHandlerBasic(9, this, new IItemValidator[0]);
    private ItemHandlerFluid fluidFilters = new ItemHandlerFluid(9, this);
    private ItemStorage[] itemStorages = new ItemStorage[8];
    private FluidStorage[] fluidStorages = new FluidStorage[8];
    private AccessType accessType = AccessType.INSERT_EXTRACT;
    private int priority = 0;
    private int compare = 3;
    private int mode = 0;
    private int type = 0;
    private boolean voidExcess = false;
    private Integer[] diskState = new Integer[8];

    public TileDiskDrive() {
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(MODE);
        this.dataManager.addWatchedParameter(TYPE);
        this.dataManager.addWatchedParameter(VOID_EXCESS);
        this.dataManager.addWatchedParameter(ACCESS_TYPE);
        TileDiskDrive.initDiskState(this.diskState);
    }

    @Override
    public int getEnergyUsage() {
        int usage = RS.INSTANCE.config.diskDriveUsage;
        for (int i = 0; i < this.disks.getSlots(); ++i) {
            if (this.disks.getStackInSlot(i) == null) continue;
            usage += RS.INSTANCE.config.diskDrivePerDiskUsage;
        }
        return usage;
    }

    @Override
    public void updateNode() {
    }

    public void onBreak() {
        for (ItemStorage itemStorage : this.itemStorages) {
            if (itemStorage == null) continue;
            itemStorage.writeToNBT();
        }
        for (IStorage<ItemStack> iStorage : this.fluidStorages) {
            if (iStorage == null) continue;
            ((FluidStorageNBT)iStorage).writeToNBT();
        }
    }

    @Override
    public void onConnectionChange(INetworkMaster network, boolean state) {
        super.onConnectionChange(network, state);
        network.getItemStorageCache().invalidate();
        network.getFluidStorageCache().invalidate();
        this.updateBlock();
    }

    @Override
    public void addItemStorages(List<IItemStorage> storages) {
        for (ItemStorage storage : this.itemStorages) {
            if (storage == null) continue;
            storages.add(storage);
        }
    }

    @Override
    public void addFluidStorages(List<IFluidStorage> storages) {
        for (FluidStorage storage : this.fluidStorages) {
            if (storage == null) continue;
            storages.add(storage);
        }
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        RSUtils.readItems((IItemHandlerModifiable)this.disks, 0, tag);
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        for (int i = 0; i < this.disks.getSlots(); ++i) {
            if (this.itemStorages[i] != null) {
                this.itemStorages[i].writeToNBT();
            }
            if (this.fluidStorages[i] == null) continue;
            this.fluidStorages[i].writeToNBT();
        }
        RSUtils.writeItems((IItemHandler)this.disks, 0, tag);
        return tag;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        RSUtils.writeItems((IItemHandler)this.itemFilters, 1, tag);
        RSUtils.writeItems((IItemHandler)this.fluidFilters, 2, tag);
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        tag.func_74768_a(NBT_COMPARE, this.compare);
        tag.func_74768_a(NBT_MODE, this.mode);
        tag.func_74768_a(NBT_TYPE, this.type);
        tag.func_74757_a(NBT_VOID_EXCESS, this.voidExcess);
        RSUtils.writeAccessType(tag, this.accessType);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        RSUtils.readItems((IItemHandlerModifiable)this.itemFilters, 1, tag);
        RSUtils.readItems((IItemHandlerModifiable)this.fluidFilters, 2, tag);
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        if (tag.func_74764_b(NBT_COMPARE)) {
            this.compare = tag.func_74762_e(NBT_COMPARE);
        }
        if (tag.func_74764_b(NBT_MODE)) {
            this.mode = tag.func_74762_e(NBT_MODE);
        }
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        if (tag.func_74764_b(NBT_VOID_EXCESS)) {
            this.voidExcess = tag.func_74767_n(NBT_VOID_EXCESS);
        }
        this.accessType = RSUtils.readAccessType(tag);
    }

    @Override
    public NBTTagCompound writeUpdate(NBTTagCompound tag) {
        super.writeUpdate(tag);
        TileDiskDrive.writeDiskState(tag, 8, this.connected, this.itemStorages, this.fluidStorages);
        return tag;
    }

    @Override
    public void readUpdate(NBTTagCompound tag) {
        super.readUpdate(tag);
        TileDiskDrive.readDiskState(tag, this.diskState);
    }

    public Integer[] getDiskState() {
        return this.diskState;
    }

    public static void writeDiskState(NBTTagCompound tag, int disks, boolean connected, ItemStorageNBT[] itemStorages, FluidStorageNBT[] fluidStorages) {
        for (int i = 0; i < disks; ++i) {
            int state = 4;
            if (itemStorages[i] != null || fluidStorages[i] != null) {
                state = !connected ? 3 : TileDiskDrive.getDiskState(itemStorages[i] != null ? itemStorages[i].getStored() : fluidStorages[i].getStored(), itemStorages[i] != null ? itemStorages[i].getCapacity() : fluidStorages[i].getCapacity());
            }
            tag.func_74768_a(String.format(NBT_DISK_STATE, i), state);
        }
    }

    public static void readDiskState(NBTTagCompound tag, Integer[] diskState) {
        for (int i = 0; i < diskState.length; ++i) {
            diskState[i] = tag.func_74762_e(String.format(NBT_DISK_STATE, i));
        }
    }

    public static void initDiskState(Integer[] diskState) {
        for (int i = 0; i < diskState.length; ++i) {
            diskState[i] = 4;
        }
    }

    public static int getDiskState(int stored, int capacity) {
        if (stored == capacity) {
            return 2;
        }
        if ((int)((float)stored / (float)capacity * 100.0f) > 85) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getCompare() {
        return this.compare;
    }

    @Override
    public void setCompare(int compare) {
        this.compare = compare;
        this.func_70296_d();
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
        this.func_70296_d();
    }

    @Override
    public String getGuiTitle() {
        return "block.refinedstorage:disk_drive.name";
    }

    @Override
    public TileDataParameter<Integer> getTypeParameter() {
        return TYPE;
    }

    @Override
    public TileDataParameter<Integer> getRedstoneModeParameter() {
        return REDSTONE_MODE;
    }

    @Override
    public TileDataParameter<Integer> getCompareParameter() {
        return COMPARE;
    }

    @Override
    public TileDataParameter<Integer> getFilterParameter() {
        return MODE;
    }

    @Override
    public TileDataParameter<Integer> getPriorityParameter() {
        return PRIORITY;
    }

    @Override
    public TileDataParameter<Boolean> getVoidExcessParameter() {
        return VOID_EXCESS;
    }

    @Override
    public TileDataParameter<AccessType> getAccessTypeParameter() {
        return ACCESS_TYPE;
    }

    @Override
    public String getVoidExcessType() {
        return "items_fluids";
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public void setAccessType(AccessType value) {
        this.accessType = value;
        if (this.network != null) {
            this.network.getFluidStorageCache().invalidate();
            this.network.getItemStorageCache().invalidate();
        }
        this.func_70296_d();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.func_70296_d();
    }

    @Override
    public int getStored() {
        int stored = 0;
        for (int i = 0; i < this.disks.getSlots(); ++i) {
            ItemStack disk = this.disks.getStackInSlot(i);
            if (disk == null) continue;
            stored += disk.func_77973_b() == RSItems.STORAGE_DISK ? ItemStorageNBT.getStoredFromNBT(disk.func_77978_p()) : FluidStorageNBT.getStoredFromNBT(disk.func_77978_p());
        }
        return stored;
    }

    @Override
    public int getCapacity() {
        int capacity = 0;
        for (int i = 0; i < this.disks.getSlots(); ++i) {
            int diskCapacity;
            ItemStack disk = this.disks.getStackInSlot(i);
            if (disk == null) continue;
            int n = diskCapacity = disk.func_77973_b() == RSItems.STORAGE_DISK ? EnumItemStorageType.getById(disk.func_77952_i()).getCapacity() : EnumFluidStorageType.getById(disk.func_77952_i()).getCapacity();
            if (diskCapacity == -1) {
                return -1;
            }
            capacity += diskCapacity;
        }
        return capacity;
    }

    public IItemHandler getDisks() {
        return this.disks;
    }

    @Override
    public boolean getVoidExcess() {
        return this.voidExcess;
    }

    @Override
    public void setVoidExcess(boolean voidExcess) {
        this.voidExcess = voidExcess;
        this.func_70296_d();
    }

    @Override
    public int getType() {
        return this.func_145831_w().field_72995_K ? TYPE.getValue() : this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
        this.func_70296_d();
    }

    @Override
    public IItemHandler getFilterInventory() {
        return this.getType() == 0 ? this.itemFilters : this.fluidFilters;
    }

    @Override
    public IItemHandler getDrops() {
        return this.disks;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.disks);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public class FluidStorage
    extends FluidStorageNBT {
        private int lastState;

        public FluidStorage(ItemStack disk) {
            super(disk.func_77978_p(), EnumFluidStorageType.getById(disk.func_77952_i()).getCapacity(), TileDiskDrive.this);
            this.lastState = TileDiskDrive.getDiskState(this.getStored(), this.getCapacity());
        }

        @Override
        public int getPriority() {
            return TileDiskDrive.this.priority;
        }

        @Override
        public FluidStack insertFluid(FluidStack stack, int size, boolean simulate) {
            if (!IFilterable.canTakeFluids(TileDiskDrive.this.fluidFilters, TileDiskDrive.this.mode, TileDiskDrive.this.getCompare(), stack)) {
                return RSUtils.copyStackWithSize(stack, size);
            }
            FluidStack result = super.insertFluid(stack, size, simulate);
            if (TileDiskDrive.this.voidExcess && result != null) {
                result.amount = -result.amount;
            }
            return result;
        }

        @Override
        public AccessType getAccessType() {
            return TileDiskDrive.this.accessType;
        }

        @Override
        public void onStorageChanged() {
            super.onStorageChanged();
            int currentState = TileDiskDrive.getDiskState(this.getStored(), this.getCapacity());
            if (this.lastState != currentState) {
                this.lastState = currentState;
                TileDiskDrive.this.updateBlock();
            }
        }
    }

    public class ItemStorage
    extends ItemStorageNBT {
        private int lastState;

        public ItemStorage(ItemStack disk) {
            super(disk.func_77978_p(), EnumItemStorageType.getById(disk.func_77952_i()).getCapacity(), TileDiskDrive.this);
            this.lastState = TileDiskDrive.getDiskState(this.getStored(), this.getCapacity());
        }

        @Override
        public int getPriority() {
            return TileDiskDrive.this.priority;
        }

        @Override
        public ItemStack insertItem(ItemStack stack, int size, boolean simulate) {
            if (!IFilterable.canTake((IItemHandler)TileDiskDrive.this.itemFilters, TileDiskDrive.this.mode, TileDiskDrive.this.getCompare(), stack)) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
            }
            ItemStack result = super.insertItem(stack, size, simulate);
            if (TileDiskDrive.this.voidExcess && result != null) {
                result.field_77994_a = -result.field_77994_a;
            }
            return result;
        }

        @Override
        public AccessType getAccessType() {
            return TileDiskDrive.this.accessType;
        }

        @Override
        public void onStorageChanged() {
            super.onStorageChanged();
            int currentState = TileDiskDrive.getDiskState(this.getStored(), this.getCapacity());
            if (this.lastState != currentState) {
                this.lastState = currentState;
                TileDiskDrive.this.updateBlock();
            }
        }
    }
}

