/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.inventory;

import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class ItemHandlerInterface
implements IItemHandler {
    private IItemHandler importItems;
    private IItemHandler exportItems;

    public ItemHandlerInterface(IItemHandler importItems, IItemHandler exportItems) {
        this.importItems = importItems;
        this.exportItems = exportItems;
    }

    public int getSlots() {
        return this.importItems.getSlots() + this.exportItems.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return slot < 9 ? this.importItems.getStackInSlot(slot) : this.exportItems.getStackInSlot(slot - 9);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return slot < 9 ? this.importItems.insertItem(slot, stack, simulate) : stack;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return slot >= 9 ? this.exportItems.extractItem(slot - 9, amount, simulate) : null;
    }
}

