/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.integration.cyclopscore;

import com.raoulvdberge.refinedstorage.apiimpl.util.Comparer;
import com.raoulvdberge.refinedstorage.integration.cyclopscore.CyclopsComparer;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;
import org.cyclops.commoncapabilities.api.capability.itemhandler.ISlotlessItemHandler;
import org.cyclops.commoncapabilities.capability.itemhandler.SlotlessItemHandlerConfig;

public class SlotlessItemHandlerHelper {
    public static boolean isSlotless(TileEntity entity, EnumFacing facing) {
        return entity != null && entity.hasCapability(SlotlessItemHandlerConfig.CAPABILITY, facing);
    }

    public static ISlotlessItemHandler getSlotlessHandler(TileEntity tile, EnumFacing facing) {
        return (ISlotlessItemHandler)tile.getCapability(SlotlessItemHandlerConfig.CAPABILITY, facing);
    }

    public static ItemStack insertItem(TileEntity tile, EnumFacing facing, @Nonnull ItemStack stack, boolean simulate) {
        return SlotlessItemHandlerHelper.insertItem(SlotlessItemHandlerHelper.getSlotlessHandler(tile, facing), stack, stack.field_77994_a, simulate);
    }

    public static ItemStack insertItem(TileEntity tile, EnumFacing facing, @Nonnull ItemStack stack, int size, boolean simulate) {
        return SlotlessItemHandlerHelper.insertItem(SlotlessItemHandlerHelper.getSlotlessHandler(tile, facing), stack, size, simulate);
    }

    public static ItemStack insertItem(ISlotlessItemHandler handler, @Nonnull ItemStack stack, int size, boolean simulate) {
        ItemStack remainder = handler.insertItem(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size), simulate);
        int remainderCount = -1;
        while (remainder != null && remainder.field_77994_a != remainderCount) {
            remainderCount = remainder.field_77994_a;
            remainder = handler.insertItem(remainder.func_77946_l(), simulate);
        }
        return remainder;
    }

    public static ItemStack extractItem(TileEntity tile, EnumFacing facing, @Nonnull ItemStack stack, int size, int flags, boolean simulate) {
        return SlotlessItemHandlerHelper.extractItem(SlotlessItemHandlerHelper.getSlotlessHandler(tile, facing), stack, size, flags, simulate);
    }

    public static ItemStack extractItem(TileEntity tile, EnumFacing facing, @Nonnull ItemStack stack, int size, boolean simulate) {
        return SlotlessItemHandlerHelper.extractItem(SlotlessItemHandlerHelper.getSlotlessHandler(tile, facing), stack, size, simulate);
    }

    public static ItemStack extractItem(ISlotlessItemHandler handler, @Nonnull ItemStack stack, int size, boolean simulate) {
        return SlotlessItemHandlerHelper.extractItem(handler, stack, size, 3, simulate);
    }

    public static ItemStack extractItem(ISlotlessItemHandler handler, @Nonnull ItemStack stack, int size, int flags, boolean simulate) {
        ItemStack extracted;
        int compare = CyclopsComparer.comparerFlagsToItemMatch(flags, stack.func_77960_j() == Short.MAX_VALUE);
        stack = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)size);
        if ((flags & 0x10) == 16) {
            stack = Comparer.stripTags(stack);
        }
        if ((extracted = handler.extractItem(stack, compare, simulate)) == null && (flags & 8) == 8) {
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                Iterator itr = OreDictionary.getOres((String)OreDictionary.getOreName((int)id)).iterator();
                while (itr.hasNext() && extracted == null) {
                    ItemStack oreStack = (ItemStack)itr.next();
                    int oreCompare = 2 | (oreStack.func_77960_j() == Short.MAX_VALUE ? 0 : 1);
                    extracted = handler.extractItem(oreStack, oreCompare, simulate);
                }
                if (extracted != null) break;
            }
        }
        if (extracted != null) {
            ItemStack extraExtract;
            while (extracted.field_77994_a < size && (extraExtract = handler.extractItem(ItemHandlerHelper.copyStackWithSize((ItemStack)extracted, (int)(size - extracted.field_77994_a)), compare, simulate)) != null) {
                extracted.field_77994_a += extraExtract.field_77994_a;
            }
        }
        return extracted;
    }

    public static ItemStack extractItem(TileEntity tile, EnumFacing facing, int size, boolean simulate) {
        return SlotlessItemHandlerHelper.extractItem(SlotlessItemHandlerHelper.getSlotlessHandler(tile, facing), size, simulate);
    }

    public static ItemStack extractItem(ISlotlessItemHandler slotlessItemHandler, int size, boolean simulate) {
        return slotlessItemHandler.extractItem(size, simulate);
    }
}

