/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.gui.sidebutton;

import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.sidebutton.SideButton;
import com.raoulvdberge.refinedstorage.tile.data.TileDataManager;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import net.minecraft.util.text.TextFormatting;

public class SideButtonCompare
extends SideButton {
    private TileDataParameter<Integer> parameter;
    private int mask;

    public SideButtonCompare(GuiBase gui, TileDataParameter<Integer> parameter, int mask) {
        super(gui);
        this.parameter = parameter;
        this.mask = mask;
    }

    @Override
    public String getTooltip() {
        String tooltip = TextFormatting.YELLOW + GuiBase.t("sidebutton.refinedstorage:compare." + this.mask, new Object[0]) + TextFormatting.RESET + "\n";
        tooltip = (this.parameter.getValue() & this.mask) == this.mask ? tooltip + GuiBase.t("gui.yes", new Object[0]) : tooltip + GuiBase.t("gui.no", new Object[0]);
        return tooltip;
    }

    @Override
    protected void drawButtonIcon(int x, int y) {
        int tx;
        int ty = 0;
        if (this.mask == 1) {
            ty = 80;
        } else if (this.mask == 2) {
            ty = 48;
        } else if (this.mask == 8) {
            ty = 224;
        }
        int n = tx = (this.parameter.getValue() & this.mask) == this.mask ? 0 : 16;
        if (this.mask == 8) {
            tx = tx == 16 ? 0 : 16;
        }
        this.gui.drawTexture(x, y, tx, ty, 16, 16);
    }

    @Override
    public void actionPerformed() {
        TileDataManager.setParameter(this.parameter, this.parameter.getValue() ^ this.mask);
    }
}

