/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.item;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItem;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemHandler;
import com.raoulvdberge.refinedstorage.item.ItemWirelessGrid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class NetworkItemWirelessGrid
implements INetworkItem {
    private INetworkItemHandler handler;
    private EntityPlayer player;
    private ItemStack stack;

    public NetworkItemWirelessGrid(INetworkItemHandler handler, EntityPlayer player, ItemStack stack) {
        this.handler = handler;
        this.player = player;
        this.stack = stack;
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public boolean onOpen(INetworkMaster network, EntityPlayer player, World controllerWorld, EnumHand hand) {
        if (RS.INSTANCE.config.wirelessGridUsesEnergy && this.stack.func_77952_i() != 1 && RSItems.WIRELESS_GRID.getEnergyStored(this.stack) <= RS.INSTANCE.config.wirelessGridOpenUsage) {
            return false;
        }
        player.openGui((Object)RS.INSTANCE, 12, player.func_130014_f_(), hand.ordinal(), controllerWorld.field_73011_w.getDimension(), 0);
        network.sendItemStorageToClient((EntityPlayerMP)player);
        this.drainEnergy(RS.INSTANCE.config.wirelessGridOpenUsage);
        return true;
    }

    public void drainEnergy(int energy) {
        if (RS.INSTANCE.config.wirelessGridUsesEnergy && this.stack.func_77952_i() != 1) {
            ItemWirelessGrid item = RSItems.WIRELESS_GRID;
            item.extractEnergy(this.stack, energy, false);
            if (item.getEnergyStored(this.stack) <= 0) {
                this.handler.onClose(this.player);
                this.player.func_71053_j();
            }
        }
    }
}

