/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingStep;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.util.IFluidStackList;
import com.raoulvdberge.refinedstorage.api.util.IItemStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingStep;
import com.raoulvdberge.refinedstorage.apiimpl.util.ItemStackList;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;

public class CraftingStepCraft
extends CraftingStep {
    public static final String ID = "craft";
    private static final String NBT_TO_INSERT = "ToInsert";
    private List<ItemStack> toInsert;

    public CraftingStepCraft(INetworkMaster network, ICraftingPattern pattern, List<ItemStack> toInsert, List<ICraftingStep> preliminarySteps) {
        super(network, pattern, preliminarySteps);
        this.toInsert = new LinkedList<ItemStack>();
        toInsert.forEach(stack -> this.toInsert.add(stack == null ? null : stack.func_77946_l()));
    }

    public CraftingStepCraft(INetworkMaster network) {
        super(network);
    }

    @Override
    public List<ItemStack> getToInsert() {
        return this.toInsert == null ? super.getToInsert() : this.toInsert.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public boolean canStartProcessing(IItemStackList items, IFluidStackList fluids) {
        if (!super.canStartProcessing()) {
            return false;
        }
        int compare = 19;
        for (ItemStack stack : this.getToInsert()) {
            compare = stack.func_77984_f() ? (compare &= 0xFFFFFFFE) : (compare |= 1);
            ItemStack actualStack = items.get(stack, compare);
            if (this.isItemAvailable(items, fluids, stack, actualStack, compare) != null) continue;
            items.undo();
            fluids.undo();
            return false;
        }
        items.undo();
        fluids.undo();
        return true;
    }

    @Override
    public void execute(Deque<ItemStack> toInsertItems, Deque<FluidStack> toInsertFluids) {
        LinkedList<ItemStack> actualInputs = new LinkedList<ItemStack>();
        if (this.extractItems(actualInputs, 19, toInsertItems)) {
            List<ItemStack> outputs;
            IItemStackList stackList = API.instance().createItemStackList();
            actualInputs.forEach(stackList::add);
            ItemStack[] took = ItemStackList.toCraftingGrid(stackList, this.toInsert, 0x13 | (this.pattern.isOredict() ? 8 : 0));
            List<ItemStack> list = outputs = this.pattern.isOredict() ? this.pattern.getOutputs(took) : this.pattern.getOutputs();
            if (outputs == null) {
                toInsertItems.addAll(actualInputs);
                this.startedProcessing = false;
                return;
            }
            for (ItemStack output : outputs) {
                if (output == null) continue;
                toInsertItems.add(output.func_77946_l());
            }
            for (ItemStack byproduct : this.pattern.isOredict() ? this.pattern.getByproducts(took) : this.pattern.getByproducts()) {
                if (byproduct == null) continue;
                toInsertItems.add(byproduct.func_77946_l());
            }
        } else {
            this.startedProcessing = false;
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("CraftingStepType", ID);
        super.writeToNBT(tag);
        NBTTagList toInsertList = new NBTTagList();
        for (ItemStack insert : this.toInsert) {
            toInsertList.func_74742_a((NBTBase)(insert == null ? new NBTTagCompound() : insert.serializeNBT()));
        }
        tag.func_74782_a(NBT_TO_INSERT, (NBTBase)toInsertList);
        return tag;
    }

    @Override
    public boolean readFromNBT(NBTTagCompound tag) {
        if (super.readFromNBT(tag)) {
            if (tag.func_74764_b(NBT_TO_INSERT)) {
                NBTTagList toInsertList = tag.func_150295_c(NBT_TO_INSERT, 10);
                this.toInsert = new ArrayList<ItemStack>(toInsertList.func_74745_c());
                for (int i = 0; i < toInsertList.func_74745_c(); ++i) {
                    this.toInsert.add(ItemStack.func_77949_a((NBTTagCompound)toInsertList.func_150305_b(i)));
                }
            }
            return true;
        }
        return false;
    }
}

