/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage;

import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.api.network.INetworkMaster;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.util.IFluidStackList;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.storage.fluid.FluidStorageNBT;
import com.raoulvdberge.refinedstorage.apiimpl.storage.item.ItemStorageNBT;
import io.netty.buffer.ByteBuf;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.FluidHandlerWrapper;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public final class RSUtils {
    public static final ItemStack EMPTY_BUCKET = new ItemStack(Items.field_151133_ar);
    public static final DecimalFormat QUANTITY_FORMATTER = new DecimalFormat("####0.#", DecimalFormatSymbols.getInstance(Locale.US));
    private static final String NBT_INVENTORY = "Inventory_%d";
    private static final String NBT_SLOT = "Slot";
    private static final String NBT_ACCESS_TYPE = "AccessType";

    public static void writeItemStack(ByteBuf buf, ItemStack stack) {
        RSUtils.writeItemStack(buf, stack, null);
    }

    public static void writeItemStack(ByteBuf buf, ItemStack stack, @Nullable INetworkMaster network) {
        buf.writeInt(Item.func_150891_b((Item)stack.func_77973_b()));
        buf.writeInt(stack.field_77994_a);
        buf.writeInt(stack.func_77952_i());
        if (network != null) {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.func_77973_b().getNBTShareTag(stack));
            buf.writeInt(API.instance().getItemStackHashCode(stack));
            buf.writeBoolean(network.hasPattern(stack));
        } else {
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.func_77978_p());
        }
    }

    public static ItemStack readItemStack(ByteBuf buf) {
        ItemStack stack = new ItemStack(Item.func_150899_d((int)buf.readInt()), buf.readInt(), buf.readInt());
        stack.func_77982_d(ByteBufUtils.readTag((ByteBuf)buf));
        return stack;
    }

    public static void writeFluidStack(ByteBuf buf, FluidStack stack) {
        buf.writeInt(API.instance().getFluidStackHashCode(stack));
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)FluidRegistry.getFluidName((Fluid)stack.getFluid()));
        buf.writeInt(stack.amount);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)stack.tag);
    }

    public static Pair<Integer, FluidStack> readFluidStack(ByteBuf buf) {
        return Pair.of((Object)buf.readInt(), (Object)new FluidStack(FluidRegistry.getFluid((String)ByteBufUtils.readUTF8String((ByteBuf)buf)), buf.readInt(), ByteBufUtils.readTag((ByteBuf)buf)));
    }

    public static void createStorages(ItemStack disk, int slot, ItemStorageNBT[] itemStorages, FluidStorageNBT[] fluidStorages, Function<ItemStack, ItemStorageNBT> itemStorageSupplier, Function<ItemStack, FluidStorageNBT> fluidStorageNBTSupplier) {
        if (disk == null) {
            itemStorages[slot] = null;
            fluidStorages[slot] = null;
        } else if (disk.func_77973_b() == RSItems.STORAGE_DISK) {
            itemStorages[slot] = itemStorageSupplier.apply(disk);
        } else if (disk.func_77973_b() == RSItems.FLUID_STORAGE_DISK) {
            fluidStorages[slot] = fluidStorageNBTSupplier.apply(disk);
        }
    }

    public static void writeItems(IItemHandler handler, int id, NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i) == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74768_a(NBT_SLOT, i);
            handler.getStackInSlot(i).func_77955_b(stackTag);
            tagList.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a(String.format(NBT_INVENTORY, id), (NBTBase)tagList);
    }

    public static void readItems(IItemHandlerModifiable handler, int id, NBTTagCompound tag) {
        String name = String.format(NBT_INVENTORY, id);
        if (tag.func_74764_b(name)) {
            NBTTagList tagList = tag.func_150295_c(name, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                int slot = tagList.func_150305_b(i).func_74762_e(NBT_SLOT);
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(i));
                if (slot < 0 || slot >= handler.getSlots()) continue;
                handler.setStackInSlot(slot, stack);
            }
        }
    }

    public static void writeItemsLegacy(IInventory inventory, int id, NBTTagCompound tag) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (inventory.func_70301_a(i) == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74768_a(NBT_SLOT, i);
            inventory.func_70301_a(i).func_77955_b(stackTag);
            tagList.func_74742_a((NBTBase)stackTag);
        }
        tag.func_74782_a(String.format(NBT_INVENTORY, id), (NBTBase)tagList);
    }

    public static void readItemsLegacy(IInventory inventory, int id, NBTTagCompound tag) {
        String name = String.format(NBT_INVENTORY, id);
        if (tag.func_74764_b(name)) {
            NBTTagList tagList = tag.func_150295_c(name, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                int slot = tagList.func_150305_b(i).func_74762_e(NBT_SLOT);
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(i));
                inventory.func_70299_a(slot, stack);
            }
        }
    }

    public static NBTTagList serializeFluidStackList(IFluidStackList list) {
        NBTTagList tagList = new NBTTagList();
        for (FluidStack stack : list.getStacks()) {
            tagList.func_74742_a((NBTBase)stack.writeToNBT(new NBTTagCompound()));
        }
        return tagList;
    }

    public static IFluidStackList readFluidStackList(NBTTagList tagList) {
        IFluidStackList list = API.instance().createFluidStackList();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagList.func_150305_b(i));
            if (stack == null) continue;
            list.add(stack);
        }
        return list;
    }

    public static void writeAccessType(NBTTagCompound tag, AccessType type) {
        tag.func_74768_a(NBT_ACCESS_TYPE, type.getId());
    }

    public static AccessType readAccessType(NBTTagCompound tag) {
        return tag.func_74764_b(NBT_ACCESS_TYPE) ? RSUtils.getAccessType(tag.func_74762_e(NBT_ACCESS_TYPE)) : AccessType.INSERT_EXTRACT;
    }

    public static AccessType getAccessType(int id) {
        for (AccessType type : AccessType.values()) {
            if (type.getId() != id) continue;
            return type;
        }
        return AccessType.INSERT_EXTRACT;
    }

    public static IItemHandler getItemHandler(TileEntity tile, EnumFacing side) {
        IItemHandler handler;
        if (tile == null) {
            return null;
        }
        IItemHandler iItemHandler = handler = tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) ? (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side) : null;
        if (handler == null) {
            if (side != null && tile instanceof ISidedInventory) {
                handler = new SidedInvWrapper((ISidedInventory)tile, side);
            } else if (tile instanceof IInventory) {
                handler = new InvWrapper((IInventory)tile);
            }
        }
        return handler;
    }

    public static IFluidHandler getFluidHandler(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return null;
        }
        IFluidHandler handler = null;
        if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
        } else if (tile instanceof net.minecraftforge.fluids.IFluidHandler) {
            handler = new FluidHandlerWrapper((net.minecraftforge.fluids.IFluidHandler)tile, side);
        }
        return handler;
    }

    public static FluidStack getFluidFromStack(ItemStack stack, boolean simulate) {
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return ((IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).drain(1000, !simulate);
        }
        if (stack.func_77973_b() instanceof IFluidContainerItem) {
            return ((IFluidContainerItem)stack.func_77973_b()).drain(stack, 1000, !simulate);
        }
        return null;
    }

    public static boolean hasFluidBucket(FluidStack stack) {
        return stack.getFluid() == FluidRegistry.WATER || stack.getFluid() == FluidRegistry.LAVA || stack.getFluid().getName().equals("milk") || FluidRegistry.getBucketFluids().contains(stack.getFluid());
    }

    public static FluidStack copyStackWithSize(FluidStack stack, int size) {
        FluidStack copy = stack.copy();
        copy.amount = size;
        return copy;
    }

    public static FluidStack copyStack(FluidStack stack) {
        return stack == null ? null : stack.copy();
    }

    public static String formatQuantity(int qty) {
        if (qty >= 1000000) {
            return QUANTITY_FORMATTER.format((float)qty / 1000000.0f) + "M";
        }
        if (qty >= 1000) {
            return QUANTITY_FORMATTER.format((float)qty / 1000.0f) + "K";
        }
        return String.valueOf(qty);
    }

    static {
        QUANTITY_FORMATTER.setRoundingMode(RoundingMode.DOWN);
    }
}

