/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.network;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.network.NetworkTools;
import mcjty.rftools.RFTools;
import mcjty.rftools.network.PacketGetRfInRange;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketReturnRfInRange
implements IMessage {
    private Map<BlockPos, PacketGetRfInRange.MachineInfo> levels;
    public static Map<BlockPos, PacketGetRfInRange.MachineInfo> clientLevels;

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.levels = new HashMap<BlockPos, PacketGetRfInRange.MachineInfo>(size);
        for (int i = 0; i < size; ++i) {
            BlockPos pos = NetworkTools.readPos((ByteBuf)buf);
            int e = buf.readInt();
            int m = buf.readInt();
            Integer usage = null;
            if (buf.readBoolean()) {
                usage = buf.readInt();
            }
            this.levels.put(pos, new PacketGetRfInRange.MachineInfo(e, m, usage));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.levels.size());
        for (Map.Entry<BlockPos, PacketGetRfInRange.MachineInfo> entry : this.levels.entrySet()) {
            NetworkTools.writePos((ByteBuf)buf, (BlockPos)entry.getKey());
            PacketGetRfInRange.MachineInfo info = entry.getValue();
            buf.writeInt(info.getEnergy());
            buf.writeInt(info.getMaxEnergy());
            if (info.getEnergyPerTick() != null) {
                buf.writeBoolean(true);
                buf.writeInt(info.getEnergyPerTick().intValue());
                continue;
            }
            buf.writeBoolean(false);
        }
    }

    public Map<BlockPos, PacketGetRfInRange.MachineInfo> getLevels() {
        return this.levels;
    }

    public PacketReturnRfInRange() {
    }

    public PacketReturnRfInRange(Map<BlockPos, PacketGetRfInRange.MachineInfo> levels) {
        this.levels = levels;
    }

    public static class Handler
    implements IMessageHandler<PacketReturnRfInRange, IMessage> {
        public IMessage onMessage(PacketReturnRfInRange message, MessageContext ctx) {
            RFTools.proxy.addScheduledTaskClient(() -> this.handle(message));
            return null;
        }

        private void handle(PacketReturnRfInRange message) {
            clientLevels = message.levels;
        }
    }
}

