/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.craftinggrid;

import io.netty.buffer.ByteBuf;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.tools.ItemStackTools;
import mcjty.rftools.blocks.storage.ModularStorageItemContainer;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.blocks.storage.RemoteStorageItemContainer;
import mcjty.rftools.blocks.storagemonitor.StorageScannerContainer;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.PacketCraftTestResultToClient;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketCraftFromGrid
implements IMessage {
    private BlockPos pos;
    private int count;
    private boolean test;

    public void fromBytes(ByteBuf buf) {
        this.pos = buf.readBoolean() ? NetworkTools.readPos((ByteBuf)buf) : null;
        this.count = buf.readInt();
        this.test = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        if (this.pos != null) {
            buf.writeBoolean(true);
            NetworkTools.writePos((ByteBuf)buf, (BlockPos)this.pos);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(this.count);
        buf.writeBoolean(this.test);
    }

    public PacketCraftFromGrid() {
    }

    public PacketCraftFromGrid(BlockPos pos, int count, boolean test) {
        this.pos = pos;
        this.count = count;
        this.test = test;
    }

    public static class Handler
    implements IMessageHandler<PacketCraftFromGrid, IMessage> {
        public IMessage onMessage(PacketCraftFromGrid message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketCraftFromGrid message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71029_a(StatList.field_188062_ab);
            int[] testResult = new int[]{};
            if (message.pos == null) {
                ItemStack mainhand = player.func_184614_ca();
                if (ItemStackTools.isValid((ItemStack)mainhand) && mainhand.func_77973_b() == ModularStorageSetup.storageModuleTabletItem) {
                    if (player.field_71070_bA instanceof ModularStorageItemContainer) {
                        ModularStorageItemContainer storageItemContainer = (ModularStorageItemContainer)player.field_71070_bA;
                        testResult = storageItemContainer.getCraftingGridProvider().craft(player, message.count, message.test);
                    } else if (player.field_71070_bA instanceof RemoteStorageItemContainer) {
                        RemoteStorageItemContainer storageItemContainer = (RemoteStorageItemContainer)player.field_71070_bA;
                        testResult = storageItemContainer.getCraftingGridProvider().craft(player, message.count, message.test);
                    } else if (player.field_71070_bA instanceof StorageScannerContainer) {
                        StorageScannerContainer storageItemContainer = (StorageScannerContainer)player.field_71070_bA;
                        testResult = storageItemContainer.getStorageScannerTileEntity().craft(player, message.count, message.test);
                    }
                }
            } else {
                TileEntity te = player.func_130014_f_().func_175625_s(message.pos);
                if (te instanceof CraftingGridProvider) {
                    testResult = ((CraftingGridProvider)te).craft(player, message.count, message.test);
                }
            }
            if (testResult.length > 0) {
                RFToolsMessages.INSTANCE.sendTo((IMessage)new PacketCraftTestResultToClient(testResult), player);
            }
        }
    }
}

