/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.sequencer;

import java.util.List;
import mcjty.lib.container.EmptyContainer;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.logic.generic.LogicSlabBlock;
import mcjty.rftools.blocks.logic.sequencer.GuiSequencer;
import mcjty.rftools.blocks.logic.sequencer.SequencerMode;
import mcjty.rftools.blocks.logic.sequencer.SequencerTileEntity;
import mcjty.rftools.theoneprobe.TheOneProbeSupport;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class SequencerBlock
extends LogicSlabBlock<SequencerTileEntity, EmptyContainer> {
    public SequencerBlock() {
        super(Material.field_151573_f, "sequencer_block", SequencerTileEntity.class, EmptyContainer.class);
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GenericGuiContainer> getGuiClass() {
        return GuiSequencer.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, EntityPlayer player, List<String> list, boolean whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            int delay = tagCompound.func_74762_e("delay");
            list.add(TextFormatting.GREEN + "Delay: " + delay);
            long cycleBits = tagCompound.func_74763_f("bits");
            int mode = tagCompound.func_74762_e("mode");
            String smode = SequencerMode.values()[mode].getDescription();
            list.add(TextFormatting.GREEN + "Mode: " + smode);
            list.add(TextFormatting.GREEN + "Bits: " + Long.toHexString(cycleBits));
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This logic block emits a series of redstone");
            list.add(TextFormatting.WHITE + "signals in a pattern that you can set in the GUI.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof SequencerTileEntity) {
            SequencerTileEntity tileEntity = (SequencerTileEntity)te;
            IProbeInfo horizontal = probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
            horizontal.text(TextFormatting.GREEN + "Mode: " + tileEntity.getMode().getDescription());
            TheOneProbeSupport.addSequenceElement(horizontal, tileEntity.getCycleBits(), tileEntity.getCurrentStep(), mode == ProbeMode.EXTENDED);
            int currentStep = tileEntity.getCurrentStep();
            boolean rc = tileEntity.checkOutput();
            probeInfo.text(TextFormatting.GREEN + "Step: " + TextFormatting.WHITE + currentStep + TextFormatting.GREEN + " -> " + TextFormatting.WHITE + (rc ? "on" : "off"));
        }
    }

    public int getGuiID() {
        return RFTools.GUI_SEQUENCER;
    }
}

