/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic.sensor;

import java.util.List;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.logic.generic.LogicSlabBlock;
import mcjty.rftools.blocks.logic.sensor.GuiSensor;
import mcjty.rftools.blocks.logic.sensor.SensorContainer;
import mcjty.rftools.blocks.logic.sensor.SensorTileEntity;
import mcjty.rftools.blocks.logic.sensor.SensorType;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class SensorBlock
extends LogicSlabBlock<SensorTileEntity, SensorContainer> {
    private static long lastTime = 0L;

    public SensorBlock() {
        super(Material.field_151573_f, "sensor_block", SensorTileEntity.class, SensorContainer.class);
    }

    @Override
    public boolean needsRedstoneCheck() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GenericGuiContainer> getGuiClass() {
        return GuiSensor.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, EntityPlayer player, List<String> list, boolean whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(TextFormatting.WHITE + "This logic block gives a redstone signal");
            list.add(TextFormatting.WHITE + "depending on various circumstances in");
            list.add(TextFormatting.WHITE + "front of it. Like block placement, crop");
            list.add(TextFormatting.WHITE + "growth level, number of entities, ...");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof SensorTileEntity) {
            SensorTileEntity sensor = (SensorTileEntity)te;
            SensorType sensorType = sensor.getSensorType();
            if (sensorType.isSupportsNumber()) {
                probeInfo.text("Type: " + sensorType.getName() + " (" + sensor.getNumber() + ")");
            } else {
                probeInfo.text("Type: " + sensorType.getName());
            }
            int blockCount = sensor.getAreaType().getBlockCount();
            if (blockCount == 1) {
                probeInfo.text("Area: 1 block");
            } else {
                probeInfo.text("Area: " + blockCount + " blocks");
            }
            boolean rc = sensor.checkSensor();
            probeInfo.text(TextFormatting.GREEN + "Output: " + TextFormatting.WHITE + (rc ? "on" : "off"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        return currenttip;
    }

    public int getGuiID() {
        return RFTools.GUI_SENSOR;
    }
}

