/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.crafter;

import java.util.List;
import mcjty.lib.api.IModuleSupport;
import mcjty.lib.api.Infusable;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.tools.ItemStackTools;
import mcjty.lib.varia.ModuleSupport;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.GenericRFToolsBlock;
import mcjty.rftools.blocks.crafter.CrafterBaseTE;
import mcjty.rftools.blocks.crafter.CrafterBlockTileEntity1;
import mcjty.rftools.blocks.crafter.CrafterBlockTileEntity2;
import mcjty.rftools.blocks.crafter.CrafterContainer;
import mcjty.rftools.blocks.crafter.GuiCrafter;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class CrafterBlock
extends GenericRFToolsBlock<CrafterBaseTE, CrafterContainer>
implements Infusable {
    public CrafterBlock(String blockName, Class<? extends CrafterBaseTE> tileEntityClass) {
        super(Material.field_151573_f, tileEntityClass, CrafterContainer.class, blockName, true);
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GenericGuiContainer> getGuiClass() {
        return GuiCrafter.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemStack, EntityPlayer player, List<String> list, boolean whatIsThis) {
        super.func_190948_a(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            int i;
            NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
            NBTTagList recipeTagList = tagCompound.func_150295_c("Recipes", 10);
            int rc = 0;
            for (i = 0; i < bufferTagList.func_74745_c(); ++i) {
                ItemStack stack;
                NBTTagCompound itemTag = bufferTagList.func_150305_b(i);
                if (itemTag == null || !ItemStackTools.isValid((ItemStack)(stack = ItemStackTools.loadFromNBT((NBTTagCompound)itemTag)))) continue;
                ++rc;
            }
            list.add(TextFormatting.GREEN + "Contents: " + rc + " stacks");
            rc = 0;
            for (i = 0; i < recipeTagList.func_74745_c(); ++i) {
                ItemStack stack;
                NBTTagCompound tagRecipe = recipeTagList.func_150305_b(i);
                NBTTagCompound resultCompound = tagRecipe.func_74775_l("Result");
                if (resultCompound == null || !ItemStackTools.isValid((ItemStack)(stack = ItemStackTools.loadFromNBT((NBTTagCompound)resultCompound)))) continue;
                ++rc;
            }
            list.add(TextFormatting.GREEN + "Recipes: " + rc + " recipes");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            int amount = this.tileEntityClass.equals(CrafterBlockTileEntity1.class) ? 2 : (this.tileEntityClass.equals(CrafterBlockTileEntity2.class) ? 4 : 8);
            list.add(TextFormatting.WHITE + "This machine can handle up to " + amount + " recipes");
            list.add(TextFormatting.WHITE + "at once and allows recipes to use the crafting results");
            list.add(TextFormatting.WHITE + "of previous steps.");
            list.add(TextFormatting.YELLOW + "Infusing bonus: reduced power consumption.");
        } else {
            list.add(TextFormatting.WHITE + "<Press Shift>");
        }
    }

    protected IModuleSupport getModuleSupport() {
        return new ModuleSupport(40){

            public boolean isModule(ItemStack itemStack) {
                return itemStack.func_77973_b() == ModularStorageSetup.storageFilterItem;
            }
        };
    }

    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        CrafterBaseTE crafterBaseTE = (CrafterBaseTE)tileEntity;
        crafterBaseTE.getInventoryHelper().setStackInSlot(9, ItemStackTools.getEmptyStack());
        for (int i = 0; i < 9; ++i) {
            crafterBaseTE.getInventoryHelper().setStackInSlot(i, ItemStackTools.getEmptyStack());
        }
        return super.createServerContainer(entityPlayer, tileEntity);
    }

    public boolean needsRedstoneCheck() {
        return true;
    }

    public int getGuiID() {
        return RFTools.GUI_CRAFTER;
    }
}

