/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.multiblock;

import elec332.core.api.info.IInfoDataAccessorBlock;
import elec332.core.api.info.IInfoProvider;
import elec332.core.api.info.IInformation;
import elec332.core.inventory.window.IWindowFactory;
import elec332.core.inventory.window.IWindowHandler;
import elec332.core.inventory.window.Window;
import elec332.core.inventory.window.WindowManager;
import elec332.core.multiblock.AbstractMultiBlockTile;
import elec332.core.multiblock.IMultiBlock;
import elec332.core.multiblock.IMultiBlockCapabilityProvider;
import elec332.core.multiblock.ISpecialMultiBlockCapabilityProvider;
import elec332.core.multiblock.MultiBlockStructureRegistry;
import elec332.core.tile.TileBase;
import elec332.core.world.WorldHelper;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;

public abstract class AbstractMultiBlock
extends IMultiBlock
implements IWindowFactory,
IInfoProvider,
IMultiBlockCapabilityProvider,
ISpecialMultiBlockCapabilityProvider {
    public boolean onAnyBlockActivated(EntityPlayer player, EnumHand hand, BlockPos pos, IBlockState state) {
        return false;
    }

    public boolean isSaveDelegate(AbstractMultiBlockTile tile) {
        return tile.func_174877_v().equals((Object)this.getLocation());
    }

    public TileBase getSaveDelegate() {
        return (TileBase)this.getTileAt(this.getLocation());
    }

    public TileEntity getTileAt(BlockPos loc) {
        return WorldHelper.getTileAt((IBlockAccess)this.getWorldObj(), loc);
    }

    public boolean isServer() {
        return !this.getWorldObj().field_72995_K;
    }

    public BlockPos getBlockLocAtTranslatedPos(int length, int width, int height) {
        return MultiBlockStructureRegistry.getTranslated(this.getLocation(), this.getMultiBlockFacing(), length, width, height);
    }

    public TileEntity getTileAtTranslatedPos(int length, int width, int height) {
        return this.getTileAt(this.getBlockLocAtTranslatedPos(length, width, height));
    }

    public void markDirty() {
        this.getSaveDelegate().func_70296_d();
    }

    public void writeToNBT(NBTTagCompound tagCompound) {
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
    }

    @Override
    public void addInformation(@Nonnull IInformation information, @Nonnull IInfoDataAccessorBlock hitData) {
    }

    @Override
    @Nonnull
    public NBTTagCompound getInfoNBTData(@Nonnull NBTTagCompound tag, TileEntity tile, @Nonnull EntityPlayerMP player, @Nonnull IInfoDataAccessorBlock hitData) {
        return tag;
    }

    @Deprecated
    public final boolean openGui(EntityPlayer player, Object mod, int ID) {
        player.openGui(mod, ID, this.getWorldObj(), this.getLocation().func_177958_n(), this.getLocation().func_177956_o(), this.getLocation().func_177952_p());
        return true;
    }

    public final boolean openWindow(EntityPlayer player, IWindowHandler windowHandler, int ID) {
        WindowManager.openWindow(player, windowHandler, this.getWorldObj(), this.getLocation(), (byte)ID);
        return true;
    }

    @Deprecated
    public final boolean openGui(EntityPlayer player, Object mod) {
        return this.openGui(player, mod, 0);
    }

    public final boolean openWindow(EntityPlayer player, IWindowHandler windowHandler) {
        return this.openWindow(player, windowHandler, 0);
    }

    @Override
    public Window createWindow(Object ... args) {
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing, @Nonnull BlockPos pos) {
        return false;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing, @Nonnull BlockPos pos) {
        return null;
    }

    @Override
    public <T> T getSpecialCapability(Capability<T> capability, EnumFacing facing, @Nonnull BlockPos pos) {
        return null;
    }
}

