/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.grid;

import com.google.common.collect.Sets;
import elec332.core.grid.GridInformation;
import elec332.core.grid.IStructureWorldEventHandler;
import elec332.core.grid.ITileEntityLink;
import elec332.core.main.ElecCore;
import elec332.core.world.DimensionCoordinate;
import elec332.core.world.PositionedObjectHolder;
import elec332.core.world.WorldHelper;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;

public abstract class AbstractGridHandler<T extends ITileEntityLink>
implements IStructureWorldEventHandler {
    private final Int2ObjectMap<PositionedObjectHolder<T>> objectsInternal = new Int2ObjectArrayMap();
    private final Set<PositionedObjectHolder.ChangeCallback<T>> changeCallbacks;
    protected final Map<Integer, PositionedObjectHolder<T>> objects;
    protected final Set<DimensionCoordinate> extraUnload = Sets.newHashSet();
    protected final Set<DimensionCoordinate> changeCheck = Sets.newHashSet();
    protected final Set<DimensionCoordinate> add = Sets.newHashSet();

    public AbstractGridHandler() {
        this.objects = Collections.unmodifiableMap(this.objectsInternal);
        this.changeCallbacks = Sets.newHashSet();
        this.registerChangeCallback(new PositionedObjectHolder.ChangeCallback<T>(){

            @Override
            public void onChange(T object, BlockPos pos, boolean add) {
                if (object == null) {
                    return;
                }
                Class type = object.getInformationType();
                if (type == null) {
                    return;
                }
                TileEntity tile = object.getTileEntity();
                if (tile != null) {
                    for (Field field : tile.getClass().getDeclaredFields()) {
                        Object o;
                        Class clazz;
                        if (!field.isAnnotationPresent(GridInformation.class) || (clazz = field.getAnnotation(GridInformation.class).value()) != type) continue;
                        if (!field.getType().isAssignableFrom(type)) {
                            throw new IllegalArgumentException();
                        }
                        Object object2 = o = add ? object.getInformation() : null;
                        if (o != null && !type.isAssignableFrom(o.getClass())) {
                            throw new IllegalArgumentException();
                        }
                        try {
                            field.setAccessible(true);
                            field.set(tile, o);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        });
    }

    @Override
    public void checkNotifyStuff(Set<DimensionCoordinate> updates) {
        for (DimensionCoordinate dimCoord : updates) {
            T o = this.getObject(dimCoord);
            if (o == null) continue;
            TileEntity tile = dimCoord.getTileEntity();
            if (tile == null) {
                if (o != null) {
                    this.extraUnload.add(dimCoord);
                }
                return;
            }
            if (!o.getPosition().isLoaded()) {
                throw new IllegalStateException();
            }
            if (!o.hasChanged()) continue;
            this.changeCheck.add(dimCoord);
            return;
        }
    }

    @Override
    public void checkBlockUpdates(Set<DimensionCoordinate> updates) {
        for (DimensionCoordinate dimCoord : updates) {
            TileEntity tile = dimCoord.getTileEntity();
            T o = this.getObject(dimCoord);
            if (o == null && tile == null) {
                return;
            }
            if (o == null && this.isValidObject(tile)) {
                this.add.add(dimCoord);
            }
            if (o != null && tile == null) {
                this.extraUnload.add(dimCoord);
            }
            if (o == null || !this.isValidObject(tile) || !o.hasChanged()) continue;
            this.changeCheck.add(dimCoord);
        }
    }

    @Override
    public void worldUnload(World world) {
        PositionedObjectHolder worldObjects = (PositionedObjectHolder)this.objectsInternal.get(WorldHelper.getDimID(world));
        if (worldObjects != null) {
            HashSet unload = Sets.newHashSet();
            for (ChunkPos chunkPos : worldObjects.getChunks()) {
                for (ITileEntityLink o : worldObjects.getObjectsInChunk(chunkPos).values()) {
                    unload.add(o.getPosition());
                }
            }
            this.unloadObjects_Internal(unload);
        }
    }

    @Override
    public void checkChunkUnload(Set<DimensionCoordinate> updates) {
        updates.addAll(this.extraUnload);
        updates.addAll(this.changeCheck);
        this.unloadObjects_Internal(updates);
        this.extraUnload.clear();
    }

    protected void unloadObjects_Internal(Set<DimensionCoordinate> updates) {
        Set<DimensionCoordinate> updates_ = Collections.unmodifiableSet(updates);
        for (DimensionCoordinate dimCoord : updates) {
            T o = this.getObject(dimCoord);
            if (o == null) {
                System.out.println("????_-3");
                continue;
            }
            this.onObjectRemoved(o, updates_);
            this.removeObject(dimCoord);
        }
    }

    protected abstract void onObjectRemoved(T var1, Set<DimensionCoordinate> var2);

    @Override
    public void checkChunkLoad(Set<DimensionCoordinate> updates) {
        HashSet oldUpdates = Sets.newHashSet(updates);
        updates.addAll(this.add);
        updates.addAll(this.changeCheck);
        for (DimensionCoordinate dimCoord : updates) {
            TileEntity tile = dimCoord.getTileEntity();
            if (tile == null || !this.isValidObject(tile)) continue;
            T o = this.getObject(dimCoord);
            if (o != null) {
                if (oldUpdates.contains(dimCoord) && !ElecCore.suppressSpongeIssues) {
                    throw new IllegalStateException();
                }
            } else {
                o = this.createNewObject(tile);
                ((PositionedObjectHolder)this.objectsInternal.get(WorldHelper.getDimID(tile.func_145831_w()))).put(o, tile.func_174877_v());
                o.hasChanged();
            }
            this.internalAdd(o);
        }
        this.add.clear();
        this.changeCheck.clear();
    }

    protected abstract void internalAdd(T var1);

    @Override
    public abstract void tick();

    @Override
    public abstract boolean isValidObject(TileEntity var1);

    protected abstract T createNewObject(TileEntity var1);

    protected void removeObject(DimensionCoordinate dimensionCoordinate) {
        this.getDim(dimensionCoordinate).remove(dimensionCoordinate.getPos());
    }

    protected T getObject(DimensionCoordinate dimensionCoordinate) {
        return (T)((ITileEntityLink)this.getDim(dimensionCoordinate).get(dimensionCoordinate.getPos()));
    }

    protected PositionedObjectHolder<T> getDim(DimensionCoordinate dimensionCoordinate) {
        PositionedObjectHolder<T> ret = (PositionedObjectHolder<T>)this.objectsInternal.get(dimensionCoordinate.getDimension());
        if (ret == null) {
            ret = new PositionedObjectHolder<T>();
            for (PositionedObjectHolder.ChangeCallback<T> callback : this.changeCallbacks) {
                ret.registerCallback(callback);
            }
            this.objectsInternal.put(dimensionCoordinate.getDimension(), ret);
        }
        return ret;
    }

    public void registerChangeCallback(PositionedObjectHolder.ChangeCallback<T> callback) {
        if (this.changeCallbacks.add(callback)) {
            for (PositionedObjectHolder o : this.objectsInternal.values()) {
                o.registerCallback(callback);
            }
        }
    }
}

