/*
 * Decompiled with CFR 0.152.
 */
package elec332.abstraction.impl;

import elec332.abstraction.impl.MCAbstractionHandler;
import elec332.core.world.IElecWorldEventListener;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;

enum WorldEventListener implements IWorldEventListener
{
    INSTANCE;


    public void func_184376_a(World worldIn, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        for (IElecWorldEventListener l : MCAbstractionHandler.listeners) {
            l.notifyBlockUpdate(worldIn, pos, oldState, newState, flags);
        }
    }

    public void func_174959_b(BlockPos pos) {
        for (IElecWorldEventListener l : MCAbstractionHandler.listeners) {
            l.notifyLightSet(pos);
        }
    }

    public void func_147585_a(int x1, int y1, int z1, int x2, int y2, int z2) {
        for (IElecWorldEventListener l : MCAbstractionHandler.listeners) {
            l.markBlockRangeForRenderUpdate(x1, y1, z1, x2, y2, z2);
        }
    }

    public void func_184375_a(@Nullable EntityPlayer player, SoundEvent soundIn, SoundCategory category, double x, double y, double z, float volume, float pitch) {
        for (IElecWorldEventListener l : MCAbstractionHandler.listeners) {
            l.playSoundToAllNearExcept(player, soundIn, category, x, y, z, volume, pitch);
        }
    }

    public void func_184377_a(SoundEvent soundIn, BlockPos pos) {
        for (IElecWorldEventListener l : MCAbstractionHandler.listeners) {
            l.playRecord(soundIn, pos);
        }
    }

    public void func_180442_a(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        for (IElecWorldEventListener l : MCAbstractionHandler.listeners) {
            l.spawnParticle(particleID, ignoreRange, false, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters);
        }
    }

    public void func_72703_a(Entity entityIn) {
        for (IElecWorldEventListener l : MCAbstractionHandler.listeners) {
            l.onEntityAdded(entityIn);
        }
    }

    public void func_72709_b(Entity entityIn) {
        for (IElecWorldEventListener l : MCAbstractionHandler.listeners) {
            l.onEntityRemoved(entityIn);
        }
    }

    public void func_180440_a(int soundID, BlockPos pos, int data) {
        for (IElecWorldEventListener l : MCAbstractionHandler.listeners) {
            l.broadcastSound(soundID, pos, data);
        }
    }

    public void func_180439_a(EntityPlayer player, int type, BlockPos blockPosIn, int data) {
        for (IElecWorldEventListener l : MCAbstractionHandler.listeners) {
            l.playEvent(player, type, blockPosIn, data);
        }
    }

    public void func_180441_b(int breakerId, BlockPos pos, int progress) {
        for (IElecWorldEventListener l : MCAbstractionHandler.listeners) {
            l.sendBlockBreakProgress(breakerId, pos, progress);
        }
    }
}

