/*
 * Decompiled with CFR 0.152.
 */
package tterrag.customthings.common.item;

import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import tterrag.customthings.common.config.json.IHasMaterial;
import tterrag.customthings.common.config.json.items.ToolType;
import tterrag.customthings.common.item.ICustomRepair;
import tterrag.customthings.common.item.ItemProxy;

public class ItemCustomPickaxe
extends ItemPickaxe
implements ICustomRepair<ToolType> {
    private ToolType type;
    private final ItemProxy<ToolType, ItemCustomPickaxe> proxy = new ItemProxy(this);

    public ItemCustomPickaxe(ToolType type) {
        super(type.getToolMaterial());
        this.type = type;
        this.func_77655_b(type.getUnlocName(ToolType.ToolClass.PICKAXE));
        this.func_111206_d(type.getIconName(ToolType.ToolClass.PICKAXE));
    }

    @Override
    public ToolType getType(ItemStack stack) {
        return this.type;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return ItemCustomPickaxe.repairMatMatchesOredict(stack, material);
    }

    public static boolean repairMatMatchesOredict(ItemStack stack, ItemStack material) {
        Item item = stack.func_77973_b();
        if (item instanceof ICustomRepair) {
            int[] oreIdsToMatch;
            IHasMaterial tool = (IHasMaterial)((ICustomRepair)item).getType(stack);
            ItemStack repairMat = tool.getRepairMat();
            int[] oreIds = OreDictionary.getOreIDs((ItemStack)repairMat);
            for (int i : oreIdsToMatch = OreDictionary.getOreIDs((ItemStack)material)) {
                if (!ArrayUtils.contains((int[])oreIds, (int)i)) continue;
                return true;
            }
            return OreDictionary.itemMatches((ItemStack)repairMat, (ItemStack)material, (boolean)false);
        }
        return false;
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.proxy.getItemStackLimit(stack);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.proxy.hasContainerItem(stack);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return this.proxy.getContainerItem(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.proxy.getRarity(stack);
    }

    public boolean hasEffect(ItemStack stack, int pass) {
        return this.proxy.hasEffect(stack, pass);
    }
}

