/*
 * Decompiled with CFR 0.152.
 */
package tterrag.customthings.common.config.json.items;

import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.EnumHelper;
import org.apache.commons.lang3.ArrayUtils;
import tterrag.customthings.common.config.json.IHasMaterial;
import tterrag.customthings.common.config.json.items.ItemType;
import tterrag.customthings.common.item.ItemCustomArmor;

public class ArmorType
extends ItemType
implements IHasMaterial {
    public int[] armors = new int[]{0, 1, 2, 3};
    public int[] durabilities = new int[]{100, 400, 500, 150};
    public int[] protectionDisplays = new int[]{1, 2, 3, 1};
    public double[] protectionRatios = new double[]{0.1, 0.1, 0.1, 0.1};
    public int[] protectionMaxes = new int[]{5, 15, 20, 7};
    public int[] priorities = new int[]{0, 0, 0, 0};
    public int enchantability = 15;
    public String material = "null";
    private transient Item[] items;
    private transient ItemStack repairMat;
    private static final String[] names = new String[]{"Helm", "Chest", "Legs", "Boots"};
    public static final List<ArmorType> types = new ArrayList<ArmorType>();

    public String getTextureName(int armorType) {
        int num = armorType == 2 ? 2 : 1;
        return this.name + num;
    }

    public String getMaterialName() {
        return this.name + "Material";
    }

    public ItemArmor.ArmorMaterial getMaterial() {
        return ItemArmor.ArmorMaterial.valueOf((String)this.getMaterialName());
    }

    @Override
    public void register() {
        super.register();
        EnumHelper.addArmorMaterial((String)this.getMaterialName(), (int)0, (int[])this.protectionDisplays, (int)this.enchantability);
        this.items = new Item[4];
        for (int i = 0; i <= 3; ++i) {
            if (!ArrayUtils.contains((int[])this.armors, (int)i)) continue;
            this.items[i] = new ItemCustomArmor(this, i);
            GameRegistry.registerItem((Item)this.items[i], (String)(this.name + names[i]));
            this.addOreDictNames(new ItemStack(this.items[i]));
        }
        types.add(this);
    }

    @Override
    public void postInit() {
        this.repairMat = this.material.equals("null") ? null : ItemUtil.parseStringIntoItemStack((String)this.material);
    }

    public String getUnlocName(int slot) {
        return this.name + names[slot];
    }

    public String getIconName(int slot) {
        return "customthings".toLowerCase() + ":" + this.getUnlocName(slot);
    }

    public Item[] getItems() {
        return this.items;
    }

    @Override
    public ItemStack getRepairMat() {
        return this.repairMat;
    }
}

