/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.shader.IShaderEquipableItem;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.entities.EntityChemthrowerShot;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.ItemUpgradeableTool;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemChemthrower
extends ItemUpgradeableTool
implements IShaderEquipableItem,
IFluidContainerItem,
ITool {
    public ItemChemthrower() {
        super("chemthrower", 1, "CHEMTHROWER", new String[0]);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean adv) {
        FluidStack fs;
        ItemStack shader = this.getShaderItem(stack);
        if (shader != null) {
            list.add(EnumChatFormatting.DARK_GRAY + shader.func_82833_r());
        }
        if ((fs = this.getFluid(stack)) != null) {
            EnumChatFormatting rarity = fs.getFluid().getRarity() == EnumRarity.common ? EnumChatFormatting.GRAY : fs.getFluid().getRarity().field_77937_e;
            list.add(rarity + fs.getLocalizedName() + EnumChatFormatting.GRAY + ": " + fs.amount + "/" + this.getCapacity(stack) + "mB");
        } else {
            list.add(StatCollector.func_74838_a((String)"desc.ImmersiveEngineering.flavour.drill.empty"));
        }
    }

    public boolean func_77662_d() {
        return true;
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.bow;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (!world.field_72995_K) {
                ItemNBTHelper.setBoolean(stack, "ignite", !ItemNBTHelper.getBoolean(stack, "ignite"));
            }
        } else {
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null && fs.getFluid() != null) {
            int duration = this.func_77626_a(stack) - count;
            int consumed = Config.getInt("chemthrower_consumption");
            if (consumed * duration <= fs.amount) {
                float range;
                Vec3 v = player.func_70040_Z();
                int split = 8;
                boolean isGas = fs.getFluid().isGaseous() || ChemthrowerHandler.isGas(fs.getFluid());
                float scatter = isGas ? 0.15f : 0.05f;
                float f = range = isGas ? 0.5f : 1.0f;
                if (this.getUpgrades(stack).func_74767_n("focus")) {
                    range += 0.25f;
                    scatter -= 0.025f;
                }
                boolean ignite = ChemthrowerHandler.isFlammable(fs.getFluid()) && ItemNBTHelper.getBoolean(stack, "ignite");
                for (int i = 0; i < split; ++i) {
                    Vec3 vecDir = v.func_72441_c(player.func_70681_au().nextGaussian() * (double)scatter, player.func_70681_au().nextGaussian() * (double)scatter, player.func_70681_au().nextGaussian() * (double)scatter);
                    EntityChemthrowerShot chem = new EntityChemthrowerShot(player.field_70170_p, (EntityLivingBase)player, vecDir.field_72450_a * 0.25, vecDir.field_72448_b * 0.25, vecDir.field_72449_c * 0.25, fs.getFluid());
                    chem.field_70159_w = vecDir.field_72450_a * (double)range;
                    chem.field_70181_x = vecDir.field_72448_b * (double)range;
                    chem.field_70179_y = vecDir.field_72449_c * (double)range;
                    if (ignite) {
                        chem.func_70015_d(10);
                    }
                    if (player.field_70170_p.field_72995_K) continue;
                    player.field_70170_p.func_72838_d((Entity)chem);
                }
                if (count % 4 == 0) {
                    if (ignite) {
                        player.func_85030_a("immersiveengineering:spray_fire", 0.5f, 1.5f);
                    } else {
                        player.func_85030_a("immersiveengineering:spray", 0.5f, 0.75f);
                    }
                }
            } else {
                player.func_71034_by();
            }
        } else {
            player.func_71034_by();
        }
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int timeLeft) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null) {
            int duration = this.func_77626_a(stack) - timeLeft;
            int consumed = Config.getInt("chemthrower_consumption");
            fs.amount -= consumed * duration;
            if (fs.amount <= 0) {
                ItemNBTHelper.remove(stack, "fluid");
            } else {
                ItemNBTHelper.setFluidStack(stack, "fluid", fs);
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public FluidStack getFluid(ItemStack container) {
        return ItemNBTHelper.getFluidStack(container, "fluid");
    }

    public int getCapacity(ItemStack container) {
        return 2000 + this.getUpgrades(container).func_74762_e("capacity");
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        FluidStack fs;
        if (resource != null && ((fs = this.getFluid(container)) == null || fs.amount < 0 || fs.isFluidEqual(resource))) {
            int space = fs == null ? this.getCapacity(container) : this.getCapacity(container) - fs.amount;
            int accepted = Math.min(space, resource.amount);
            if (fs == null) {
                fs = new FluidStack(resource, accepted);
            } else {
                fs.amount += accepted;
            }
            if (doFill) {
                ItemNBTHelper.setFluidStack(container, "fluid", fs);
            }
            return accepted;
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        FluidStack fs = this.getFluid(container);
        if (fs == null) {
            return null;
        }
        int drained = Math.min(maxDrain, fs.amount);
        FluidStack stack = new FluidStack(fs, drained);
        if (doDrain) {
            fs.amount -= drained;
            if (fs.amount <= 0) {
                ItemNBTHelper.remove(container, "fluid");
            } else {
                ItemNBTHelper.setFluidStack(container, "fluid", fs);
            }
        }
        return stack;
    }

    @Override
    public void setShaderItem(ItemStack stack, ItemStack shader) {
        ItemStack[] contained = this.getContainedItems(stack);
        contained[3] = shader;
        this.setContainedItems(stack, contained);
    }

    @Override
    public ItemStack getShaderItem(ItemStack stack) {
        ItemStack[] contained = this.getContainedItems(stack);
        return contained[3];
    }

    @Override
    public String getShaderType() {
        return "chemthrower";
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack, IInventory invItem) {
        return new Slot[]{new IESlot.Upgrades(container, invItem, 0, 80, 32, "CHEMTHROWER", stack, true), new IESlot.Upgrades(container, invItem, 1, 100, 32, "CHEMTHROWER", stack, true), new IESlot.Upgrades(container, invItem, 2, 120, 32, "CHEMTHROWER", stack, true), new IESlot.Shader(container, invItem, 3, 150, 32, stack)};
    }

    @Override
    public int getInternalSlots(ItemStack stack) {
        return 4;
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    @Override
    public void finishUpgradeRecalculation(ItemStack stack) {
        FluidStack fs = this.getFluid(stack);
        if (fs != null && fs.amount > this.getCapacity(stack)) {
            fs.amount = this.getCapacity(stack);
            ItemNBTHelper.setFluidStack(stack, "fluid", fs);
        }
    }
}

