/*
 * Decompiled with CFR 0.152.
 */
package magicbees.block.types;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.IHiveDrop;
import java.util.ArrayList;
import magicbees.bees.BeeGenomeManager;
import magicbees.bees.BeeSpecies;
import magicbees.bees.HiveDrop;
import magicbees.item.types.CombType;
import magicbees.main.Config;
import magicbees.main.utils.compat.ForestryHelper;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public enum HiveType {
    CURIOUS("curious", BeeSpecies.MYSTICAL, 12, true),
    UNUSUAL("unusual", BeeSpecies.UNUSUAL, 12, true),
    RESONANT("resonant", BeeSpecies.SORCEROUS, 12, true),
    DEEP("deep", BeeSpecies.ATTUNED, 4, false),
    INFERNAL("infernal", BeeSpecies.INFERNAL, 15, false),
    OBLIVION("oblivion", BeeSpecies.OBLIVION, 7, false);

    private static String[] nameList;
    private String name;
    private BeeSpecies occupant;
    public boolean show;
    private int lightLevel;
    private ArrayList<IHiveDrop> drops;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public static HiveType getHiveFromMeta(int meta) {
        HiveType type = CURIOUS;
        if (meta > 0 && meta < HiveType.values().length) {
            type = HiveType.values()[meta];
        }
        return type;
    }

    public static void initHiveData() {
        ItemStack[] combs = new ItemStack[]{Config.combs.getStackForType(CombType.MUNDANE)};
        HiveDrop valiantDrop = new HiveDrop(BeeGenomeManager.addRainResist(ForestryHelper.getTemplateForestryForSpecies("Valiant")), combs, 5);
        HiveType.CURIOUS.drops.add(new HiveDrop(BeeSpecies.MYSTICAL.getGenome(), combs, 80).setIgnoblePercentage(0.7f));
        HiveType.CURIOUS.drops.add(new HiveDrop(BeeGenomeManager.addRainResist(BeeSpecies.MYSTICAL.getGenome()), combs, 15));
        HiveType.CURIOUS.drops.add(valiantDrop);
        HiveType.UNUSUAL.drops.add(new HiveDrop(BeeSpecies.UNUSUAL.getGenome(), combs, 80).setIgnoblePercentage(0.7f));
        HiveType.UNUSUAL.drops.add(new HiveDrop(BeeGenomeManager.addRainResist(BeeSpecies.UNUSUAL.getGenome()), combs, 15));
        HiveType.UNUSUAL.drops.add(valiantDrop);
        HiveType.RESONANT.drops.add(new HiveDrop(BeeSpecies.SORCEROUS.getGenome(), combs, 80).setIgnoblePercentage(0.7f));
        HiveType.RESONANT.drops.add(new HiveDrop(BeeGenomeManager.addRainResist(BeeSpecies.SORCEROUS.getGenome()), combs, 20));
        HiveType.RESONANT.drops.add(valiantDrop);
        HiveType.DEEP.drops.add(new HiveDrop(BeeSpecies.ATTUNED.getGenome(), combs, 80).setIgnoblePercentage(0.65f));
        HiveType.DEEP.drops.add(new HiveDrop(BeeGenomeManager.addRainResist(BeeSpecies.ATTUNED.getGenome()), combs, 20));
        HiveType.DEEP.drops.add(valiantDrop);
        combs = new ItemStack[]{Config.combs.getStackForType(CombType.MOLTEN), new ItemStack(Items.field_151114_aO, 6)};
        HiveType.INFERNAL.drops.add(new HiveDrop(BeeSpecies.INFERNAL.getGenome(), combs, 80).setIgnoblePercentage(0.5f));
        HiveType.INFERNAL.drops.add(new HiveDrop(ForestryHelper.getTemplateForestryForSpecies("Steadfast"), combs, 3));
        combs = new ItemStack[]{Config.combs.getStackForType(CombType.FORGOTTEN), new ItemStack(Items.field_151079_bi, 1)};
        HiveType.OBLIVION.drops.add(new HiveDrop(BeeSpecies.OBLIVION.getGenome(), combs, 80));
        HiveType.OBLIVION.drops.add(new HiveDrop(ForestryHelper.getTemplateForestryForSpecies("Steadfast"), combs, 9));
    }

    private HiveType(String hiveName, BeeSpecies occupant, int light, boolean visible) {
        this.name = hiveName;
        this.occupant = occupant;
        this.lightLevel = light;
        this.show = visible;
        this.drops = new ArrayList();
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIcons(IIconRegister register) {
        for (HiveType type : HiveType.values()) {
            type.icons = new IIcon[2];
            type.icons[0] = register.func_94245_a("magicbees:beehive." + type.ordinal() + ".top");
            type.icons[1] = register.func_94245_a("magicbees:beehive." + type.ordinal() + ".side");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconForSide(int side) {
        IIcon i = this.icons[0];
        if (side != 0 && side != 1) {
            i = this.icons[1];
        }
        return i;
    }

    public int getLightValue() {
        return this.lightLevel;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int fortune) {
        int dart;
        ArrayList<ItemStack> hiveDrops = new ArrayList<ItemStack>();
        int throttle = 0;
        block0: while (hiveDrops.size() <= 0 && throttle < 10) {
            ++throttle;
            dart = world.field_73012_v.nextInt(100);
            for (IHiveDrop drop : this.drops) {
                if (dart > drop.getChance(world, x, y, z)) continue;
                hiveDrops.add(drop.getPrincess(world, x, y, z, fortune));
                continue block0;
            }
        }
        dart = world.field_73012_v.nextInt(100);
        for (IHiveDrop drop : this.drops) {
            if (dart > drop.getChance(world, x, y, z)) continue;
            hiveDrops.addAll(drop.getDrones(world, x, y, z, fortune));
            break;
        }
        dart = world.field_73012_v.nextInt(100);
        for (IHiveDrop drop : this.drops) {
            if (dart > drop.getChance(world, x, y, z)) continue;
            hiveDrops.addAll(drop.getAdditional(world, x, y, z, fortune));
        }
        return hiveDrops;
    }

    public static String[] getAllNames() {
        String[] stringArray;
        if (nameList == null) {
            nameList = HiveType.generateNames();
            stringArray = nameList;
        } else {
            stringArray = nameList;
        }
        return stringArray;
    }

    public BeeSpecies getOccupant() {
        return this.occupant;
    }

    private static String[] generateNames() {
        String[] names = new String[HiveType.values().length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = HiveType.values()[i].name;
        }
        return names;
    }
}

