/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.meta;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import openperipheral.api.adapter.method.ScriptObject;
import openperipheral.api.meta.IItemStackCustomMetaProvider;
import openperipheral.api.meta.IItemStackMetaProvider;
import openperipheral.api.meta.IItemStackPartialMetaBuilder;
import openperipheral.api.meta.IMetaProviderProxy;
import openperipheral.meta.MetaProvidersRegistry;

public class ItemStackMetadataBuilder
implements IItemStackPartialMetaBuilder {
    private static final Map<String, Object> NULL;

    private static Map<String, Object> createBasicProperties(Item item, ItemStack itemstack) {
        HashMap map = Maps.newHashMap();
        GameRegistry.UniqueIdentifier id = GameRegistry.findUniqueIdentifierFor((Item)item);
        map.put("id", id != null ? id.toString() : "?");
        map.put("name", id != null ? id.name : "?");
        map.put("mod_id", id != null ? id.modId : "?");
        map.put("display_name", ItemStackMetadataBuilder.getNameForItemStack(itemstack));
        map.put("raw_name", ItemStackMetadataBuilder.getRawNameForStack(itemstack));
        map.put("qty", itemstack.field_77994_a);
        map.put("dmg", itemstack.func_77960_j());
        if (item.showDurabilityBar(itemstack)) {
            map.put("health_bar", item.getDurabilityForDisplay(itemstack));
        }
        map.put("max_dmg", itemstack.func_77958_k());
        map.put("max_size", itemstack.func_77976_d());
        return map;
    }

    private static void fillCustomProperties(Map<String, Object> map, Iterable<IItemStackMetaProvider<?>> providers, Item item, ItemStack itemstack) {
        for (IItemStackMetaProvider<?> provider : providers) {
            Object converted = ItemStackMetadataBuilder.getProperty(itemstack, item, provider);
            if (converted == null) continue;
            String key = provider.getKey();
            map.put(key, converted);
        }
    }

    private static String getNameForItemStack(ItemStack is) {
        try {
            return is.func_82833_r();
        }
        catch (Exception exception) {
            try {
                return is.func_77977_a();
            }
            catch (Exception exception2) {
                return "unknown";
            }
        }
    }

    private static Object getProperty(ItemStack stack, Item item, IItemStackMetaProvider provider) {
        return provider.getMeta(item, stack);
    }

    private static Map<String, IItemStackMetaProvider<?>> getProviders(Item item, ItemStack stack) {
        Map<String, IItemStackMetaProvider<?>> immutableProviders = MetaProvidersRegistry.ITEMS.getProviders(item.getClass());
        HashMap providers = Maps.newHashMap(immutableProviders);
        ItemStackMetadataBuilder.filterCustomProviders(providers, item, stack);
        return providers;
    }

    private static void filterCustomProviders(Map<String, IItemStackMetaProvider<?>> providers, Item item, ItemStack stack) {
        Iterator<IItemStackMetaProvider<?>> it = providers.values().iterator();
        while (it.hasNext()) {
            IItemStackMetaProvider<?> provider = it.next();
            if (!(provider instanceof IItemStackCustomMetaProvider) || ((IItemStackCustomMetaProvider)provider).canApply(item, stack)) continue;
            it.remove();
        }
    }

    public static String getRawNameForStack(ItemStack is) {
        try {
            return is.func_77977_a().toLowerCase(Locale.ENGLISH);
        }
        catch (Exception exception) {
            return "unknown";
        }
    }

    @Override
    public IMetaProviderProxy createProxy(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item == null) {
            return null;
        }
        Map<String, IItemStackMetaProvider<?>> providers = ItemStackMetadataBuilder.getProviders(item, stack);
        return new Proxy(providers, stack, item);
    }

    @Override
    public Map<String, Object> getBasicItemStackMetadata(ItemStack itemstack) {
        if (itemstack == null) {
            return NULL;
        }
        Item item = itemstack.func_77973_b();
        return ItemStackMetadataBuilder.createBasicProperties(item, itemstack);
    }

    @Override
    public Map<String, Object> getItemStackMetadata(ItemStack itemstack) {
        if (itemstack == null) {
            return NULL;
        }
        Item item = itemstack.func_77973_b();
        Map<String, Object> map = ItemStackMetadataBuilder.createBasicProperties(item, itemstack);
        Collection<IItemStackMetaProvider<?>> providers = ItemStackMetadataBuilder.getProviders(item, itemstack).values();
        ItemStackMetadataBuilder.fillCustomProperties(map, providers, item, itemstack);
        return map;
    }

    @Override
    public Object getItemStackMetadata(String key, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item == null) {
            return null;
        }
        Map<String, IItemStackMetaProvider<?>> providers = ItemStackMetadataBuilder.getProviders(item, stack);
        IItemStackMetaProvider<?> provider = providers.get(key);
        return provider != null ? ItemStackMetadataBuilder.getProperty(stack, item, provider) : null;
    }

    @Override
    public Set<String> getKeys(ItemStack target) {
        return ImmutableSet.copyOf(ItemStackMetadataBuilder.getProviders(target.func_77973_b(), target).keySet());
    }

    @Override
    public void register(IItemStackMetaProvider<?> provider) {
        MetaProvidersRegistry.ITEMS.addProvider(provider);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"id", (Object)"invalid");
        NULL = builder.build();
    }

    @ScriptObject
    private static class Proxy
    implements IMetaProviderProxy {
        private final Map<String, IItemStackMetaProvider<?>> providers;
        private final ItemStack stack;
        private final Item item;

        private Proxy(Map<String, IItemStackMetaProvider<?>> providers, ItemStack stack, Item item) {
            this.providers = ImmutableMap.copyOf(providers);
            this.stack = stack;
            this.item = item;
        }

        @Override
        public Map<String, Object> basic() {
            return ItemStackMetadataBuilder.createBasicProperties(this.item, this.stack);
        }

        @Override
        public Map<String, Object> all() {
            Map<String, Object> map = this.basic();
            ItemStackMetadataBuilder.fillCustomProperties(map, this.providers.values(), this.item, this.stack);
            return map;
        }

        @Override
        public Set<String> keys() {
            return ImmutableSet.copyOf(this.providers.keySet());
        }

        @Override
        public Map<String, Object> select(String ... keys) {
            Item item = this.stack.func_77973_b();
            if (item == null) {
                return ImmutableMap.of();
            }
            Map<String, Object> result = this.basic();
            for (String key : keys) {
                Object value;
                IItemStackMetaProvider<?> provider = this.providers.get(key);
                if (provider == null || (value = ItemStackMetadataBuilder.getProperty(this.stack, item, provider)) == null) continue;
                result.put(key, value);
            }
            return result;
        }

        @Override
        public Object single(String key) {
            IItemStackMetaProvider<?> provider = this.providers.get(key);
            return provider != null ? ItemStackMetadataBuilder.getProperty(this.stack, this.item, provider) : null;
        }
    }
}

