/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.adapter.property;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import openperipheral.adapter.property.IFieldManipulator;
import openperipheral.adapter.property.IPropertyExecutor;
import openperipheral.adapter.property.ISinglePropertyAccessHandler;
import openperipheral.adapter.property.PropertyUtils;
import openperipheral.adapter.property.SingleTypeInfo;
import openperipheral.api.converter.IConverter;
import openperipheral.converter.TypeConverter;
import org.apache.commons.lang3.ArrayUtils;

public class SetterExecutor
implements IPropertyExecutor {
    private final Field field;
    private final IFieldManipulator manipulator;
    private final SingleTypeInfo typeInfo;
    private final ISinglePropertyAccessHandler accessHandler;
    private final boolean nullable;

    public SetterExecutor(Field field, IFieldManipulator manipulator, SingleTypeInfo typeInfo, ISinglePropertyAccessHandler accessHandler, boolean nullable) {
        this.field = field;
        this.manipulator = manipulator;
        this.typeInfo = typeInfo;
        this.accessHandler = accessHandler;
        this.nullable = nullable;
    }

    @Override
    public Object[] call(IConverter converter, Object owner, Object ... args) {
        Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)"Setter must have exactly one argument");
        Object arg = args[0];
        Object target = PropertyUtils.getContents(owner, this.field);
        Type valueType = this.typeInfo.getValueType(target);
        Object converted = TypeConverter.nullableToJava(converter, this.nullable, arg, valueType);
        this.accessHandler.onSet(owner, target, this.field, converted);
        this.manipulator.setField(owner, target, this.field, converted);
        return ArrayUtils.EMPTY_OBJECT_ARRAY;
    }
}

