/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import exnihilo.blocks.tileentities.TileEntitySieve;
import exnihilo.particles.ParticleSieve;
import exnihilo.registries.helpers.SiftingResult;
import java.util.Collection;
import net.blay09.mods.excompressum.handler.VanillaPacketHandler;
import net.blay09.mods.excompressum.registry.HeavySieveRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;

public class TileEntityHeavySieve
extends TileEntity {
    private static final float MIN_RENDER_CAPACITY = 0.7f;
    private static final float MAX_RENDER_CAPACITY = 0.9f;
    private static final float PROCESSING_INTERVAL = 0.075f;
    private static final int UPDATE_INTERVAL = 20;
    private ItemStack content;
    private TileEntitySieve.SieveMode mode = TileEntitySieve.SieveMode.EMPTY;
    private boolean isDirty;
    private boolean spawnParticles;
    private float volume;
    private int ticksSinceUpdate;
    private int clicksSinceUpdate;

    public TileEntitySieve.SieveMode getMode() {
        return this.mode;
    }

    public void addSievable(ItemStack content) {
        this.content = content;
        this.mode = TileEntitySieve.SieveMode.FILLED;
        this.volume = 1.0f;
        VanillaPacketHandler.sendTileEntityUpdate(this);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K && this.spawnParticles) {
            this.spawnFX();
        }
        ++this.ticksSinceUpdate;
        if (this.ticksSinceUpdate >= 20) {
            this.ticksSinceUpdate = 0;
            this.clicksSinceUpdate = 0;
            this.spawnParticles = false;
            if (this.isDirty) {
                VanillaPacketHandler.sendTileEntityUpdate(this);
                this.isDirty = false;
            }
        }
    }

    public void processContents(boolean creative) {
        if (creative) {
            this.volume = 0.0f;
        } else {
            ++this.clicksSinceUpdate;
            if (this.clicksSinceUpdate <= 6) {
                this.volume -= 0.075f;
            }
        }
        if (this.volume <= 0.0f) {
            Collection<SiftingResult> rewards;
            this.mode = TileEntitySieve.SieveMode.EMPTY;
            if (!this.field_145850_b.field_72995_K && (rewards = HeavySieveRegistry.getSiftingOutput(this.content)) != null) {
                for (SiftingResult reward : rewards) {
                    if (this.field_145850_b.field_73012_v.nextInt(reward.rarity) != 0) continue;
                    EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, new ItemStack(reward.item, 1, reward.meta));
                    double motionScale = 0.05;
                    entityItem.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * motionScale;
                    entityItem.field_70181_x = 0.2;
                    entityItem.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * motionScale;
                    this.field_145850_b.func_72838_d((Entity)entityItem);
                }
            }
        } else {
            this.spawnParticles = true;
        }
        this.isDirty = true;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnFX() {
        if (this.content != null) {
            IIcon icon = this.content.func_77954_c();
            for (int i = 0; i < 4; ++i) {
                ParticleSieve particle = new ParticleSieve(this.field_145850_b, (double)this.field_145851_c + 0.8 * (double)this.field_145850_b.field_73012_v.nextFloat() + 0.15, (double)this.field_145848_d + 0.69, (double)this.field_145849_e + 0.8 * (double)this.field_145850_b.field_73012_v.nextFloat() + 0.15, 0.0, 0.0, 0.0, icon);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
            }
        }
    }

    public float getAdjustedVolume() {
        float capacity = 0.19999999f;
        float adjusted = this.volume * capacity;
        return adjusted += 0.7f;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.mode = tagCompound.func_74762_e("Mode") == 1 ? TileEntitySieve.SieveMode.FILLED : TileEntitySieve.SieveMode.EMPTY;
        this.content = ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("Content"));
        this.volume = tagCompound.func_74760_g("Volume");
        this.spawnParticles = tagCompound.func_74767_n("Particles");
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        tagCompound.func_74768_a("Mode", this.mode.value);
        if (this.content != null) {
            tagCompound.func_74782_a("Content", (NBTBase)this.content.func_77955_b(new NBTTagCompound()));
        }
        tagCompound.func_74776_a("Volume", this.volume);
        tagCompound.func_74757_a("Particles", this.spawnParticles);
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tagCompound);
    }

    public void onDataPacket(NetworkManager networkManager, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public ItemStack getContent() {
        return this.content;
    }

    public float getVolumeLeft() {
        return this.volume;
    }
}

