/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.tile;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.registry.CompressedRecipeRegistry;
import net.blay09.mods.excompressum.registry.data.CompressedRecipe;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAutoCompressor
extends TileEntity
implements ISidedInventory,
IEnergyHandler {
    private final EnergyStorage storage = new EnergyStorage(32000);
    private final Multiset<CompressedRecipe> inputItems = HashMultiset.create();
    private final ItemStack[] inventory = new ItemStack[this.func_70302_i_()];
    private ItemStack currentStack;
    private float progress;

    public void func_145845_h() {
        int effectiveEnergy = this.getEffectiveEnergy();
        if (this.storage.getEnergyStored() > effectiveEnergy) {
            if (this.currentStack == null) {
                this.inputItems.clear();
                for (int i = 0; i < 12; ++i) {
                    CompressedRecipe compressedRecipe;
                    if (this.inventory[i] == null || (compressedRecipe = CompressedRecipeRegistry.getRecipe(this.inventory[i])) == null) continue;
                    this.inputItems.add((Object)compressedRecipe, this.inventory[i].field_77994_a);
                }
                for (CompressedRecipe compressedRecipe : this.inputItems.elementSet()) {
                    ItemStack sourceStack = compressedRecipe.getSourceStack();
                    if (this.inputItems.count((Object)compressedRecipe) < sourceStack.field_77994_a) continue;
                    int space = 0;
                    for (int i = 12; i < this.inventory.length; ++i) {
                        if (this.inventory[i] == null) {
                            space = 64;
                        } else if (this.isItemEqualWildcard(this.inventory[i], compressedRecipe.getResultStack())) {
                            space += this.inventory[i].func_77976_d() - this.inventory[i].field_77994_a;
                        }
                        if (space >= compressedRecipe.getResultStack().field_77994_a) break;
                    }
                    if (space < compressedRecipe.getResultStack().field_77994_a) continue;
                    int count = sourceStack.field_77994_a;
                    for (int i = 0; i < 12; ++i) {
                        if (this.inventory[i] == null || !this.isItemEqualWildcard(this.inventory[i], sourceStack)) continue;
                        if (this.inventory[i].field_77994_a >= count) {
                            this.inventory[i].field_77994_a -= count;
                            if (this.inventory[i].field_77994_a == 0) {
                                this.inventory[i] = null;
                            }
                            count = 0;
                            break;
                        }
                        count -= this.inventory[i].field_77994_a;
                        this.inventory[i] = null;
                    }
                    if (count <= 0) {
                        this.currentStack = sourceStack.func_77946_l();
                        this.progress = 0.0f;
                    }
                    break;
                }
            } else {
                this.storage.extractEnergy(effectiveEnergy, false);
                this.progress = Math.min(1.0f, this.progress + this.getEffectiveSpeed());
                if (this.progress >= 1.0f) {
                    ItemStack resultStack;
                    CompressedRecipe compressedRecipe;
                    if (!this.field_145850_b.field_72995_K && (compressedRecipe = CompressedRecipeRegistry.getRecipe(this.currentStack)) != null && !this.addItemToOutput(resultStack = compressedRecipe.getResultStack().func_77946_l())) {
                        EntityItem entityItem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, resultStack);
                        double motion = 0.05;
                        entityItem.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * motion;
                        entityItem.field_70181_x = 0.2;
                        entityItem.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * motion;
                        this.field_145850_b.func_72838_d((Entity)entityItem);
                    }
                    this.currentStack = null;
                    this.progress = 0.0f;
                }
            }
        }
    }

    private boolean isItemEqualWildcard(ItemStack itemStack, ItemStack otherStack) {
        if (!ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)otherStack)) {
            return false;
        }
        return itemStack.func_77969_a(otherStack) || itemStack.func_77973_b() == otherStack.func_77973_b() && (itemStack.func_77960_j() == Short.MAX_VALUE || otherStack.func_77960_j() == Short.MAX_VALUE);
    }

    private boolean addItemToOutput(ItemStack itemStack) {
        int firstEmptySlot = -1;
        for (int i = 12; i < this.func_70302_i_(); ++i) {
            if (this.inventory[i] == null) {
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
                continue;
            }
            if (this.inventory[i].field_77994_a + itemStack.field_77994_a > this.inventory[i].func_77976_d() || !this.isItemEqualWildcard(this.inventory[i], itemStack)) continue;
            this.inventory[i].field_77994_a += itemStack.field_77994_a;
            return true;
        }
        if (firstEmptySlot != -1) {
            this.inventory[firstEmptySlot] = itemStack;
            return true;
        }
        return false;
    }

    public int getEffectiveEnergy() {
        return ExCompressum.autoCompressorEnergy;
    }

    public float getEffectiveSpeed() {
        return ExCompressum.autoCompressorSpeed;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.currentStack = ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("CurrentStack"));
        this.progress = tagCompound.func_74760_g("Progress");
        this.storage.readFromNBT(tagCompound);
        NBTTagList items = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound itemCompound = items.func_150305_b(i);
            byte slot = itemCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)itemCompound);
        }
    }

    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        if (this.currentStack != null) {
            tagCompound.func_74782_a("CurrentStack", (NBTBase)this.currentStack.func_77955_b(new NBTTagCompound()));
        }
        tagCompound.func_74776_a("Progress", this.progress);
        this.storage.writeToNBT(tagCompound);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound itemCompound = new NBTTagCompound();
            itemCompound.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(itemCompound);
            items.func_74742_a((NBTBase)itemCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)items);
    }

    @Override
    public int receiveEnergy(ForgeDirection side, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection side, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection side) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection side) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection side) {
        return true;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    }

    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        return this.func_94041_b(slot, itemStack);
    }

    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return slot >= 12;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return slot < 12 && CompressedRecipeRegistry.getRecipe(itemStack) != null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int func_70302_i_() {
        return 24;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= amount) {
                ItemStack itemStack = this.inventory[slot];
                this.inventory[slot] = null;
                return itemStack;
            }
            ItemStack itemStack = this.inventory[slot].func_77979_a(amount);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return itemStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void setEnergyStored(int energyStored) {
        this.storage.setEnergyStored(energyStored);
    }

    public boolean isProcessing() {
        return this.progress > 0.0f;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public float getEnergyPercentage() {
        return (float)this.storage.getEnergyStored() / (float)this.storage.getMaxEnergyStored();
    }

    public ItemStack getCurrentStack() {
        return this.currentStack;
    }
}

