/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.blay09.mods.excompressum.registry.InventoryCompressedMatcher;
import net.blay09.mods.excompressum.registry.data.CompressedRecipe;
import net.blay09.mods.excompressum.registry.data.ItemAndMetadata;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class CompressedRecipeRegistry {
    private static final List<CompressedRecipe> recipesSmall = Lists.newArrayList();
    private static final List<CompressedRecipe> recipes = Lists.newArrayList();
    private static final InventoryCompressedMatcher matcherSmall = new InventoryCompressedMatcher(2, 2, false);
    private static final InventoryCompressedMatcher matcherSmallStupid = new InventoryCompressedMatcher(3, 3, true);
    private static final InventoryCompressedMatcher matcher = new InventoryCompressedMatcher(3, 3, false);
    private static final Map<ItemAndMetadata, CompressedRecipe> cachedResults = Maps.newHashMap();

    public static void reload() {
        cachedResults.clear();
        recipesSmall.clear();
        recipes.clear();
        for (Object obj : CraftingManager.func_77594_a().func_77592_b()) {
            IRecipe recipe = (IRecipe)obj;
            if (obj instanceof ShapedRecipes) {
                CompressedRecipeRegistry.addCompressedRecipe(recipe, CompressedRecipeRegistry.getRecipeSource((ShapedRecipes)obj));
                continue;
            }
            if (obj instanceof ShapelessRecipes) {
                CompressedRecipeRegistry.addCompressedRecipe(recipe, CompressedRecipeRegistry.getRecipeSource((ShapelessRecipes)obj));
                continue;
            }
            if (obj instanceof ShapedOreRecipe) {
                for (ItemStack itemStack : CompressedRecipeRegistry.getRecipeSources((ShapedOreRecipe)obj)) {
                    CompressedRecipeRegistry.addCompressedRecipe(recipe, itemStack);
                }
                continue;
            }
            if (!(obj instanceof ShapelessOreRecipe)) continue;
            for (ItemStack itemStack : CompressedRecipeRegistry.getRecipeSources((ShapelessOreRecipe)obj)) {
                CompressedRecipeRegistry.addCompressedRecipe(recipe, itemStack);
            }
        }
    }

    private static void addCompressedRecipe(IRecipe recipe, ItemStack sourceStack) {
        if (sourceStack != null && sourceStack.func_77973_b() != null) {
            sourceStack = sourceStack.func_77946_l();
            if (recipe.func_77570_a() == 4) {
                matcherSmall.fill(sourceStack);
                if (recipe.func_77569_a((InventoryCrafting)matcherSmall, null)) {
                    sourceStack.field_77994_a = 4;
                    recipesSmall.add(new CompressedRecipe(sourceStack, recipe.func_77572_b((InventoryCrafting)matcherSmall).func_77946_l()));
                }
            } else if (recipe.func_77570_a() == 9) {
                matcher.fill(sourceStack);
                if (recipe.func_77569_a((InventoryCrafting)matcher, null)) {
                    sourceStack.field_77994_a = 9;
                    recipes.add(new CompressedRecipe(sourceStack, recipe.func_77572_b((InventoryCrafting)matcher).func_77946_l()));
                } else {
                    matcherSmallStupid.fill(sourceStack);
                    if (recipe.func_77569_a((InventoryCrafting)matcherSmallStupid, null)) {
                        sourceStack.field_77994_a = 4;
                        recipesSmall.add(new CompressedRecipe(sourceStack, recipe.func_77572_b((InventoryCrafting)matcherSmallStupid).func_77946_l()));
                    }
                }
            }
        }
    }

    private static ItemStack getRecipeSource(ShapedRecipes recipe) {
        for (ItemStack itemStack : recipe.field_77574_d) {
            if (itemStack == null) continue;
            return itemStack;
        }
        return null;
    }

    private static ItemStack getRecipeSource(ShapelessRecipes recipe) {
        for (Object obj : recipe.field_77579_b) {
            if (obj == null) continue;
            return (ItemStack)obj;
        }
        return null;
    }

    private static List<ItemStack> getRecipeSources(ShapedOreRecipe recipe) {
        for (Object obj : recipe.getInput()) {
            if (obj == null) continue;
            if (obj instanceof List) {
                return (List)obj;
            }
            if (obj instanceof ItemStack) {
                return Collections.singletonList((ItemStack)obj);
            }
            if (obj instanceof Block) {
                return Collections.singletonList(new ItemStack((Block)obj));
            }
            if (!(obj instanceof Item)) continue;
            return Collections.singletonList(new ItemStack((Item)obj));
        }
        return Collections.emptyList();
    }

    private static List<ItemStack> getRecipeSources(ShapelessOreRecipe recipe) {
        for (Object obj : recipe.getInput()) {
            if (obj == null) continue;
            if (obj instanceof List) {
                return (List)obj;
            }
            if (obj instanceof ItemStack) {
                return Collections.singletonList((ItemStack)obj);
            }
            if (obj instanceof Block) {
                return Collections.singletonList(new ItemStack((Block)obj));
            }
            if (!(obj instanceof Item)) continue;
            return Collections.singletonList(new ItemStack((Item)obj));
        }
        return Collections.emptyList();
    }

    public static CompressedRecipe getRecipe(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77978_p() != null) {
            return null;
        }
        ItemAndMetadata itemAndMetadata = new ItemAndMetadata(itemStack);
        if (cachedResults.containsKey(itemAndMetadata)) {
            return cachedResults.get(new ItemAndMetadata(itemStack));
        }
        for (CompressedRecipe recipe : recipes) {
            if (itemStack.func_77973_b() != recipe.getSourceStack().func_77973_b() || recipe.getSourceStack().func_77960_j() != Short.MAX_VALUE && recipe.getSourceStack().func_77960_j() != itemStack.func_77960_j()) continue;
            cachedResults.put(itemAndMetadata, recipe);
            return recipe;
        }
        for (CompressedRecipe recipe : recipesSmall) {
            if (itemStack.func_77973_b() != recipe.getSourceStack().func_77973_b() || recipe.getSourceStack().func_77960_j() != Short.MAX_VALUE && recipe.getSourceStack().func_77960_j() != itemStack.func_77960_j()) continue;
            cachedResults.put(itemAndMetadata, recipe);
            return recipe;
        }
        cachedResults.put(itemAndMetadata, null);
        return null;
    }
}

