/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.item;

import com.google.common.collect.Sets;
import cpw.mods.fml.common.registry.GameRegistry;
import exnihilo.items.hammers.IHammer;
import exnihilo.items.hammers.ItemHammerBase;
import exnihilo.registries.HammerRegistry;
import exnihilo.registries.helpers.Smashable;
import java.util.Collection;
import java.util.Set;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.ModItems;
import net.blay09.mods.excompressum.registry.CompressedHammerRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;

public class ItemCompressedHammer
extends ItemTool
implements IHammer {
    private static final Set blocksEffectiveAgainst = Sets.newHashSet((Iterable)ItemHammerBase.blocksEffectiveAgainst);
    private final String name;

    public ItemCompressedHammer(Item.ToolMaterial material, String name) {
        super(5.0f, material, blocksEffectiveAgainst);
        this.name = name;
        this.func_77637_a(ExCompressum.creativeTab);
        this.func_77655_b("excompressum:compressed_hammer_" + name);
    }

    public boolean canHarvestBlock(Block block, ItemStack itemStack) {
        return HammerRegistry.registered((ItemStack)new ItemStack(block));
    }

    public float getDigSpeed(ItemStack item, Block block, int meta) {
        if ((CompressedHammerRegistry.isRegistered(block, meta) || HammerRegistry.registered((ItemStack)new ItemStack(block, 1, meta))) && block.getHarvestLevel(meta) <= this.field_77862_b.func_77996_d()) {
            return this.field_77864_a * 0.75f;
        }
        return 0.8f;
    }

    public boolean onBlockStartBreak(ItemStack itemStack, int x, int y, int z, EntityPlayer entityPlayer) {
        int metadata;
        World world = entityPlayer.field_70170_p;
        if (world.field_72995_K || EnchantmentHelper.func_77502_d((EntityLivingBase)entityPlayer)) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        Collection<Smashable> rewards = CompressedHammerRegistry.getSmashables(block, metadata = world.func_72805_g(x, y, z));
        if (rewards == null || rewards.isEmpty()) {
            return false;
        }
        int fortune = EnchantmentHelper.func_77517_e((EntityLivingBase)entityPlayer);
        for (Smashable reward : rewards) {
            if (!(world.field_73012_v.nextFloat() <= reward.chance + reward.luckMultiplier * (float)fortune)) continue;
            EntityItem entityItem = new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, new ItemStack(reward.item, 1, reward.meta));
            double motion = 0.05;
            entityItem.field_70159_w = world.field_73012_v.nextGaussian() * motion;
            entityItem.field_70181_x = 0.2;
            entityItem.field_70179_y = world.field_73012_v.nextGaussian() * motion;
            world.func_72838_d((Entity)entityItem);
        }
        world.func_147468_f(x, y, z);
        itemStack.func_77972_a(1, (EntityLivingBase)entityPlayer);
        if (itemStack.field_77994_a == 0) {
            entityPlayer.func_71028_bD();
        }
        return true;
    }

    public boolean isHammer(ItemStack itemStack) {
        return true;
    }

    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("excompressum:compressed_hammer_" + this.name);
    }

    public static void registerRecipes(Configuration config) {
        Item itemHammerDiamond;
        Item itemHammerGold;
        Item itemHammerIron;
        Item itemHammerStone;
        Item itemHammerWood;
        if (config.getBoolean("Compressed Wooden Hammer", "items", true, "If set to false, the recipe for the compressed wooden hammer will be disabled.") && (itemHammerWood = GameRegistry.findItem((String)"exnihilo", (String)"hammer_wood")) != null) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.compressedHammerWood), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), itemHammerWood});
        }
        if (config.getBoolean("Compressed Stone Hammer", "items", true, "If set to false, the recipe for the compressed stone hammer will be disabled.") && (itemHammerStone = GameRegistry.findItem((String)"exnihilo", (String)"hammer_stone")) != null) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.compressedHammerStone), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), itemHammerStone});
        }
        if (config.getBoolean("Compressed Iron Hammer", "items", true, "If set to false, the recipe for the compressed iron hammer will be disabled.") && (itemHammerIron = GameRegistry.findItem((String)"exnihilo", (String)"hammer_iron")) != null) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.compressedHammerIron), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), itemHammerIron});
        }
        if (config.getBoolean("Compressed Gold Hammer", "items", true, "If set to false, the recipe for the compressed gold hammer will be disabled.") && (itemHammerGold = GameRegistry.findItem((String)"exnihilo", (String)"hammer_gold")) != null) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.compressedHammerGold), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), itemHammerGold});
        }
        if (config.getBoolean("Compressed Diamond Hammer", "items", true, "If set to false, the recipe for the compressed diamond hammer will be disabled.") && (itemHammerDiamond = GameRegistry.findItem((String)"exnihilo", (String)"hammer_diamond")) != null) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)ModItems.compressedHammerDiamond), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), itemHammerDiamond});
        }
    }
}

