/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.fluids.Tank;
import buildcraft.core.lib.fluids.TankUtils;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.Utils;
import io.netty.buffer.ByteBuf;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileFloodGate
extends TileBuildCraft
implements IFluidHandler {
    public static final int[] REBUILD_DELAY = new int[8];
    public static final int MAX_LIQUID = 2000;
    private final TreeMap<Integer, Deque<BlockIndex>> pumpLayerQueues = new TreeMap();
    private final Set<BlockIndex> visitedBlocks = new HashSet<BlockIndex>();
    private Deque<BlockIndex> fluidsFound = new LinkedList<BlockIndex>();
    private final Tank tank = new Tank("tank", 2000, this);
    private int rebuildDelay;
    private int tick = Utils.RANDOM.nextInt();
    private boolean powered = false;
    private boolean[] blockedSides = new boolean[6];

    @Override
    public void func_145845_h() {
        FluidStack fluidtoFill;
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.powered) {
            return;
        }
        ++this.tick;
        if (this.tick % 16 == 0 && (fluidtoFill = this.tank.drain(1000, false)) != null && fluidtoFill.amount == 1000) {
            BlockIndex index;
            Fluid fluid = fluidtoFill.getFluid();
            if (fluid == null || !fluid.canBePlacedInWorld()) {
                return;
            }
            if (fluid == FluidRegistry.WATER && this.field_145850_b.field_73011_w.field_76574_g == -1) {
                this.tank.drain(1000, true);
                return;
            }
            if (this.tick % REBUILD_DELAY[this.rebuildDelay] == 0) {
                ++this.rebuildDelay;
                if (this.rebuildDelay >= REBUILD_DELAY.length) {
                    this.rebuildDelay = REBUILD_DELAY.length - 1;
                }
                this.rebuildQueue();
            }
            if ((index = this.getNextIndexToFill(true)) != null && this.placeFluid(index.x, index.y, index.z, fluid)) {
                this.tank.drain(1000, true);
                this.rebuildDelay = 0;
            }
        }
    }

    private boolean placeFluid(int x, int y, int z, Fluid fluid) {
        Block block = BlockUtils.getBlock(this.field_145850_b, x, y, z);
        if (this.canPlaceFluidAt(block, x, y, z)) {
            boolean placed;
            Block b = TankUtils.getFluidBlock(fluid, true);
            if (b instanceof BlockFluidBase) {
                BlockFluidBase blockFluid = (BlockFluidBase)b;
                placed = this.field_145850_b.func_147465_d(x, y, z, b, blockFluid.getMaxRenderHeightMeta(), 3);
            } else {
                placed = this.field_145850_b.func_147449_b(x, y, z, b);
            }
            if (placed) {
                this.queueAdjacent(x, y, z);
                this.expandQueue();
            }
            return placed;
        }
        return false;
    }

    private BlockIndex getNextIndexToFill(boolean remove) {
        if (this.pumpLayerQueues.isEmpty()) {
            return null;
        }
        Deque<BlockIndex> bottomLayer = this.pumpLayerQueues.firstEntry().getValue();
        if (bottomLayer != null) {
            if (bottomLayer.isEmpty()) {
                this.pumpLayerQueues.pollFirstEntry();
            }
            if (remove) {
                BlockIndex index = bottomLayer.pollFirst();
                return index;
            }
            return bottomLayer.peekFirst();
        }
        return null;
    }

    private Deque<BlockIndex> getLayerQueue(int layer) {
        Deque<BlockIndex> pumpQueue = this.pumpLayerQueues.get(layer);
        if (pumpQueue == null) {
            pumpQueue = new LinkedList<BlockIndex>();
            this.pumpLayerQueues.put(layer, pumpQueue);
        }
        return pumpQueue;
    }

    void rebuildQueue() {
        this.pumpLayerQueues.clear();
        this.visitedBlocks.clear();
        this.fluidsFound.clear();
        this.queueAdjacent(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.expandQueue();
    }

    private void expandQueue() {
        if (this.tank.getFluidType() == null) {
            return;
        }
        while (!this.fluidsFound.isEmpty()) {
            Deque<BlockIndex> fluidsToExpand = this.fluidsFound;
            this.fluidsFound = new LinkedList<BlockIndex>();
            for (BlockIndex index : fluidsToExpand) {
                this.queueAdjacent(index.x, index.y, index.z);
            }
        }
    }

    public void queueAdjacent(int x, int y, int z) {
        if (this.tank.getFluidType() == null) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            if (i == 1 || this.blockedSides[i]) continue;
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            this.queueForFilling(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        }
    }

    public void queueForFilling(int x, int y, int z) {
        if (y < 0 || y > 255) {
            return;
        }
        BlockIndex index = new BlockIndex(x, y, z);
        if (this.visitedBlocks.add(index)) {
            if ((x - this.field_145851_c) * (x - this.field_145851_c) + (z - this.field_145849_e) * (z - this.field_145849_e) > 4096) {
                return;
            }
            Block block = BlockUtils.getBlock(this.field_145850_b, x, y, z);
            if (BlockUtils.getFluid(block) == this.tank.getFluidType()) {
                this.fluidsFound.add(index);
            }
            if (this.canPlaceFluidAt(block, x, y, z)) {
                this.getLayerQueue(y).addLast(index);
            }
        }
    }

    private boolean canPlaceFluidAt(Block block, int x, int y, int z) {
        return BuildCraftAPI.isSoftBlock(this.field_145850_b, x, y, z) && !BlockUtils.isFullFluidBlock(block, this.field_145850_b, x, y, z);
    }

    public void onNeighborBlockChange(Block block) {
        boolean p = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.powered != p) {
            this.powered = p;
            if (!p) {
                this.rebuildQueue();
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tank.readFromNBT(data);
        this.rebuildDelay = data.func_74771_c("rebuildDelay");
        this.powered = data.func_74767_n("powered");
        for (int i = 0; i < 6; ++i) {
            this.blockedSides[i] = data.func_74767_n("blocked[" + i + "]");
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.tank.writeToNBT(data);
        data.func_74774_a("rebuildDelay", (byte)this.rebuildDelay);
        data.func_74757_a("powered", this.powered);
        for (int i = 0; i < 6; ++i) {
            if (!this.blockedSides[i]) continue;
            data.func_74757_a("blocked[" + i + "]", true);
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        byte flags = stream.readByte();
        for (int i = 0; i < 6; ++i) {
            this.blockedSides[i] = (flags & 1 << i) != 0;
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        int flags = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.blockedSides[i]) continue;
            flags = (byte)(flags | 1 << i);
        }
        stream.writeByte(flags);
    }

    public void switchSide(ForgeDirection side) {
        if (side.ordinal() != 1) {
            this.blockedSides[side.ordinal()] = !this.blockedSides[side.ordinal()];
            this.rebuildQueue();
            this.sendNetworkUpdate();
            this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.destroy();
    }

    @Override
    public void destroy() {
        this.pumpLayerQueues.clear();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public boolean isSideBlocked(int side) {
        return this.blockedSides[side];
    }

    static {
        TileFloodGate.REBUILD_DELAY[0] = 128;
        TileFloodGate.REBUILD_DELAY[1] = 256;
        TileFloodGate.REBUILD_DELAY[2] = 512;
        TileFloodGate.REBUILD_DELAY[3] = 1024;
        TileFloodGate.REBUILD_DELAY[4] = 2048;
        TileFloodGate.REBUILD_DELAY[5] = 4096;
        TileFloodGate.REBUILD_DELAY[6] = 8192;
        TileFloodGate.REBUILD_DELAY[7] = 16384;
    }
}

