/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.mercurius;

import cpw.mods.fml.client.IModGuiFactory;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.mercurius.IMinecraftBinding;
import net.minecraftforge.mercurius.Mercurius;
import net.minecraftforge.mercurius.binding.ClientBinding;
import net.minecraftforge.mercurius.binding.ModConfigGui;
import net.minecraftforge.mercurius.binding.ServerBinding;
import net.minecraftforge.mercurius.utils.Commands;
import net.minecraftforge.mercurius.utils.GameEnvironment;

@Mod(modid="mercurius", name="Mercurius", version="1.0.6", guiFactory="net.minecraftforge.mercurius.StatsMod$GuiFactory")
public class StatsMod {
    public static final String MODID = "mercurius";
    public static final String MODNAME = "Mercurius";
    public static final String VERSION = "1.0.6";
    public static final String GUIFACTORY = "net.minecraftforge.mercurius.StatsMod$GuiFactory";
    @Mod.Instance(value="mercurius")
    public static StatsMod instance;
    public static IMinecraftBinding binding;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        binding = e.getSide() == Side.CLIENT ? new ClientBinding(e.getModConfigurationDirectory()) : new ServerBinding(e.getModConfigurationDirectory());
        Mercurius.bootstrap(binding);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        FMLCommonHandler.instance().bus().register((Object)new ConnectionEvents());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        try {
            Mercurius.getSender().collectData(Commands.START, true);
            Mercurius.getSender().startTimer();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent e) {
        try {
            Mercurius.getSender().collectData(Commands.START, true);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent e) {
        try {
            Mercurius.getSender().collectData(Commands.STOP, true);
            Mercurius.getSender().cancelTimer();
            Mercurius.getBinding().resetSessionID();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public class ConnectionEvents {
        @SubscribeEvent
        public void onConnectionOpened(FMLNetworkEvent.ClientConnectedToServerEvent e) {
            try {
                if (!e.isLocal) {
                    Mercurius.getSender().collectData(Commands.START, true, GameEnvironment.SERVER_NON_LOCAL);
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }

        @SubscribeEvent
        public void disconnectedFromServer(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
            try {
                if (!e.manager.func_150731_c()) {
                    Mercurius.getSender().collectData(Commands.STOP, true, GameEnvironment.SERVER_NON_LOCAL);
                    Mercurius.getBinding().resetSessionID();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public static class GuiFactory
    implements IModGuiFactory {
        public Class<? extends GuiScreen> mainConfigGuiClass() {
            return ModConfigGui.class;
        }

        public void initialize(Minecraft minecraftInstance) {
        }

        public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
            return null;
        }

        public IModGuiFactory.RuntimeOptionGuiHandler getHandlerFor(IModGuiFactory.RuntimeOptionCategoryElement element) {
            return null;
        }
    }
}

