/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleetho;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.world.BlockEvent;

@Mod(modid="kleeslabs", name="KleeSlabs")
public class Kleetho {
    private static final Random rand = new Random();
    private boolean invertSneak;
    private Configuration config;
    private final BiMap<Block, Block> slabMap = HashBiMap.create();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.config.load();
        this.invertSneak = this.config.getBoolean("Invert Sneaking Check", "general", false, "Set this to true to invert the sneaking check for breaking only half a slab.");
        this.config.getCategory("mods").setComment("***IMPORTANT*** This is not guaranteed to work for all slabs. Custom slab implementations that do not follow Vanilla's standard will likely break, so make sure to test if you add any here! ***IMPORTANT***");
        String modId = "BiomesOPlenty";
        this.config.get("mods." + modId, "id", modId);
        this.config.get("mods." + modId, "woodenSingleSlab1", "woodenDoubleSlab1");
        this.config.get("mods." + modId, "woodenSingleSlab2", "woodenDoubleSlab2");
        this.config.get("mods." + modId, "stoneSingleSlab", "stoneDoubleSlab");
        modId = "Thaumcraft";
        this.config.get("mods." + modId, "id", modId);
        this.config.get("mods." + modId, "blockCosmeticSlabStone", "blockCosmeticDoubleSlabStone");
        this.config.get("mods." + modId, "blockCosmeticSlabWood", "blockCosmeticDoubleSlabWood");
        modId = "Botania";
        this.config.get("mods." + modId, "id", modId);
        this.config.get("mods." + modId, "quartzSlabDarkHalf", "quartzSlabDarkFull");
        this.config.get("mods." + modId, "quartzSlabManaHalf", "quartzSlabManaFull");
        this.config.get("mods." + modId, "quartzSlabBlazeHalf", "quartzSlabBlazeFull");
        this.config.get("mods." + modId, "quartzSlabLavenderHalf", "quartzSlabLavenderFull");
        this.config.get("mods." + modId, "quartzSlabRedHalf", "quartzSlabRedFull");
        this.config.get("mods." + modId, "quartzSlabElfHalf", "quartzSlabElfFull");
        this.config.get("mods." + modId, "quartzSlabSunnyHalf", "quartzSlabSunnyFull");
        this.config.get("mods." + modId, "livingwood0Slab", "livingwood0SlabFull");
        this.config.get("mods." + modId, "livingwood1Slab", "livingwood1SlabFull");
        this.config.get("mods." + modId, "livingrock0Slab", "livingrock0SlabFull");
        this.config.get("mods." + modId, "livingrock1Slab", "livingrock1SlabFull");
        this.config.get("mods." + modId, "dreamwood0Slab", "dreamwood0SlabFull");
        this.config.get("mods." + modId, "dreamwood1Slab", "dreamwood1SlabFull");
        this.config.get("mods." + modId, "reedBlock0Slab", "reedBlock0SlabFull");
        this.config.get("mods." + modId, "thatch0Slab", "thatch0SlabFull");
        this.config.get("mods." + modId, "prismarine0Slab", "prismarine0SlabFull");
        this.config.get("mods." + modId, "prismarine1Slab", "prismarine1SlabFull");
        this.config.get("mods." + modId, "prismarine2Slab", "prismarine2SlabFull");
        this.config.get("mods." + modId, "customBrick0Slab", "customBrick0SlabFull");
        this.config.get("mods." + modId, "customBrick1Slab", "customBrick1SlabFull");
        this.config.get("mods." + modId, "customBrick2Slab", "customBrick2SlabFull");
        this.config.get("mods." + modId, "customBrick3Slab", "customBrick3SlabFull");
        this.config.get("mods." + modId, "dirtPath0Slab", "dirtPath0SlabFull");
        this.config.get("mods." + modId, "endStoneBrick0Slab", "endStoneBrick0SlabFull");
        this.config.get("mods." + modId, "endStoneBrick2Slab", "endStoneBrick2SlabFull");
        this.config.get("mods." + modId, "shimmerrock0Slab", "shimmerrock0SlabFull");
        this.config.get("mods." + modId, "shimmerrock0Slab", "shimmerrock0SlabFull");
        this.config.get("mods." + modId, "shimmerwoodPlanks0Slab", "shimmerwoodPlanks0SlabFull");
        this.config.get("mods." + modId, "biomeStoneA0Slab", "biomeStoneA0SlabFull");
        this.config.get("mods." + modId, "biomeStoneA1Slab", "biomeStoneA1SlabFull");
        this.config.get("mods." + modId, "biomeStoneA2Slab", "biomeStoneA2SlabFull");
        this.config.get("mods." + modId, "biomeStoneA3Slab", "biomeStoneA3SlabFull");
        this.config.get("mods." + modId, "biomeStoneA4Slab", "biomeStoneA4SlabFull");
        this.config.get("mods." + modId, "biomeStoneA5Slab", "biomeStoneA5SlabFull");
        this.config.get("mods." + modId, "biomeStoneA6Slab", "biomeStoneA6SlabFull");
        this.config.get("mods." + modId, "biomeStoneA7Slab", "biomeStoneA7SlabFull");
        this.config.get("mods." + modId, "biomeStoneA8Slab", "biomeStoneA8SlabFull");
        this.config.get("mods." + modId, "biomeStoneA9Slab", "biomeStoneA9SlabFull");
        this.config.get("mods." + modId, "biomeStoneA10Slab", "biomeStoneA10SlabFull");
        this.config.get("mods." + modId, "biomeStoneA11Slab", "biomeStoneA11SlabFull");
        this.config.get("mods." + modId, "biomeStoneA12Slab", "biomeStoneA12SlabFull");
        this.config.get("mods." + modId, "biomeStoneA13Slab", "biomeStoneA13SlabFull");
        this.config.get("mods." + modId, "biomeStoneA14Slab", "biomeStoneA14SlabFull");
        this.config.get("mods." + modId, "biomeStoneA15Slab", "biomeStoneA15SlabFull");
        this.config.get("mods." + modId, "biomeStoneB0Slab", "biomeStoneB0SlabFull");
        this.config.get("mods." + modId, "biomeStoneB1Slab", "biomeStoneB1SlabFull");
        this.config.get("mods." + modId, "biomeStoneB2Slab", "biomeStoneB2SlabFull");
        this.config.get("mods." + modId, "biomeStoneB3Slab", "biomeStoneB3SlabFull");
        this.config.get("mods." + modId, "biomeStoneB4Slab", "biomeStoneB4SlabFull");
        this.config.get("mods." + modId, "biomeStoneB5Slab", "biomeStoneB5SlabFull");
        this.config.get("mods." + modId, "biomeStoneB6Slab", "biomeStoneB6SlabFull");
        this.config.get("mods." + modId, "biomeStoneB6Slab", "biomeStoneB6SlabFull");
        this.config.get("mods." + modId, "biomeStoneB7Slab", "biomeStoneB7SlabFull");
        this.config.get("mods." + modId, "stone0Slab", "stone0SlabFull");
        this.config.get("mods." + modId, "stone1Slab", "stone1SlabFull");
        this.config.get("mods." + modId, "stone2Slab", "stone2SlabFull");
        this.config.get("mods." + modId, "stone3Slab", "stone3SlabFull");
        this.config.get("mods." + modId, "stone8Slab", "stone8SlabFull");
        this.config.get("mods." + modId, "stone9Slab", "stone9SlabFull");
        this.config.get("mods." + modId, "stone10Slab", "stone10SlabFull");
        this.config.get("mods." + modId, "stone11Slab", "stone11SlabFull");
        this.config.get("mods." + modId, "pavement0Slab", "pavement0SlabFull");
        this.config.get("mods." + modId, "pavement1Slab", "pavement1SlabFull");
        this.config.get("mods." + modId, "pavement2Slab", "pavement2SlabFull");
        this.config.get("mods." + modId, "pavement3Slab", "pavement3SlabFull");
        this.config.get("mods." + modId, "pavement4Slab", "pavement4SlabFull");
        this.config.get("mods." + modId, "pavement5Slab", "pavement5SlabFull");
        modId = "Forestry";
        this.config.get("mods." + modId, "id", modId);
        this.config.get("mods." + modId, "slabs", "slabsDouble");
        this.config.get("mods." + modId, "slabsFireproof", "slabsDoubleFireproof");
        modId = "ThaumicTinkerer";
        this.config.get("mods." + modId, "id", modId);
        this.config.get("mods." + modId, "darkQuartzSlab", "darkQuartzSlabFull");
        modId = "witchery";
        this.config.get("mods." + modId, "id", modId);
        this.config.get("mods." + modId, "witchwoodslab", "witchwooddoubleslab");
        this.config.get("mods." + modId, "iceslab", "icedoubleslab");
        this.config.get("mods." + modId, "snowslab", "snowdoubleslab");
        modId = "appliedenergistics2";
        this.config.get("mods." + modId, "id", modId);
        this.config.get("mods." + modId, "tile.SkyStoneSlabBlock", "tile.SkyStoneSlabBlock.double");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.slabMap.put((Object)Blocks.field_150334_T, (Object)Blocks.field_150333_U);
        this.slabMap.put((Object)Blocks.field_150373_bw, (Object)Blocks.field_150376_bx);
        ConfigCategory category = this.config.getCategory("mods");
        for (ConfigCategory mod : category.getChildren()) {
            String modId = mod.get("id") != null ? mod.get("id").getString() : mod.getName();
            if (!Loader.isModLoaded((String)modId)) continue;
            for (Map.Entry entry : mod.entrySet()) {
                String singleSlabName = (String)entry.getKey();
                String doubleSlabName = ((Property)entry.getValue()).getString();
                this.registerSlabs(modId, singleSlabName, doubleSlabName);
            }
        }
        this.config.save();
    }

    private void registerSlabs(String modId, String singleName, String doubleName) {
        Block singleBlock = GameRegistry.findBlock((String)modId, (String)singleName);
        Block doubleBlock = GameRegistry.findBlock((String)modId, (String)doubleName);
        if (singleBlock != null && doubleBlock != null) {
            this.slabMap.put((Object)doubleBlock, (Object)singleBlock);
        } else if (singleBlock == null) {
            System.out.println("Could not register slabs for " + modId + ": " + singleName + " not found");
        } else {
            System.out.println("Could not register slabs for " + modId + ": " + doubleName + " not found");
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        Vec3 hitVec;
        MovingObjectPosition mop = Kleetho.rayTrace((EntityLivingBase)event.getPlayer(), 6.0);
        Vec3 vec3 = hitVec = mop != null ? mop.field_72307_f : null;
        if (hitVec != null) {
            hitVec = hitVec.func_72441_c((double)(-event.x), (double)(-event.y), (double)(-event.z));
        }
        if (event.getPlayer().func_70093_af() != this.invertSneak && this.isDoubleSlab(event.block)) {
            if (!event.world.field_72995_K && event.getPlayer().func_146099_a(event.block) && !event.getPlayer().field_71075_bZ.field_75098_d) {
                this.spawnItem(new ItemStack(Item.func_150898_a((Block)this.getSingleSlab(event.block)), 1, event.block.func_149692_a(event.blockMetadata)), event.world, event.x, event.y, event.z);
            }
            int metadata = event.blockMetadata;
            if (hitVec != null && hitVec.field_72448_b < 0.5) {
                metadata |= 8;
            }
            event.world.func_147465_d(event.x, event.y, event.z, this.getSingleSlab(event.block), metadata, 3);
            event.setCanceled(true);
        }
    }

    private void spawnItem(ItemStack itemStack, World world, float x, float y, float z) {
        float scale = 0.7f;
        double xOffset = (double)(rand.nextFloat() * scale + 1.0f) - (double)scale * 0.5;
        double yOffset = (double)(rand.nextFloat() * scale + 1.0f) - (double)scale * 0.5;
        double zOffset = (double)(rand.nextFloat() * scale + 1.0f) - (double)scale * 0.5;
        EntityItem entityItem = new EntityItem(world, (double)x + xOffset, (double)y + yOffset, (double)z + zOffset, itemStack);
        entityItem.field_145804_b = 10;
        world.func_72838_d((Entity)entityItem);
    }

    public boolean isDoubleSlab(Block block) {
        return this.slabMap.containsKey((Object)block);
    }

    public Block getSingleSlab(Block doubleSlab) {
        return (Block)this.slabMap.get((Object)doubleSlab);
    }

    public static MovingObjectPosition rayTrace(EntityLivingBase entity, double length) {
        Vec3 startPos = Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + (double)entity.func_70047_e()), (double)entity.field_70161_v);
        Vec3 endPos = startPos.func_72441_c(entity.func_70040_Z().field_72450_a * length, entity.func_70040_Z().field_72448_b * length, entity.func_70040_Z().field_72449_c * length);
        return entity.field_70170_p.func_72933_a(startPos, endPos);
    }
}

