/*
 * Decompiled with CFR 0.152.
 */
package extracells.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import cpw.mods.fml.common.Optional;
import extracells.api.IPortableGasStorageCell;
import extracells.api.IWirelessGasTermHandler;
import extracells.container.IStorageContainer;
import extracells.container.slot.SlotPlayerInventory;
import extracells.container.slot.SlotRespective;
import extracells.gui.GuiGasStorage;
import extracells.gui.widget.fluid.IFluidSelectorContainer;
import extracells.integration.Integration;
import extracells.inventory.HandlerItemStorageFluid;
import extracells.network.packet.part.PacketFluidStorage;
import extracells.util.FluidUtil;
import extracells.util.GasUtil;
import extracells.util.inventory.ECPrivateInventory;
import extracells.util.inventory.IInventoryUpdateReceiver;
import mekanism.api.gas.GasStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnace;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.MutablePair;

public class ContainerGasStorage
extends Container
implements IMEMonitorHandlerReceiver<IAEFluidStack>,
IFluidSelectorContainer,
IInventoryUpdateReceiver,
IStorageContainer {
    private boolean isMekanismEnabled = Integration.Mods.MEKANISMGAS.isEnabled();
    private GuiGasStorage guiGasStorage;
    private IItemList<IAEFluidStack> fluidStackList;
    private Fluid selectedFluid;
    private IAEFluidStack selectedFluidStack;
    private EntityPlayer player;
    private IMEMonitor<IAEFluidStack> monitor;
    private HandlerItemStorageFluid storageFluid;
    private IWirelessGasTermHandler handler = null;
    private IPortableGasStorageCell storageCell = null;
    public boolean hasWirelessTermHandler = false;
    private ECPrivateInventory inventory = new ECPrivateInventory("extracells.item.fluid.storage", 2, 64, this){

        @Override
        public boolean func_94041_b(int i, ItemStack itemStack) {
            return GasUtil.isGasContainer(itemStack);
        }
    };
    private boolean doNextFill = false;

    public ContainerGasStorage(EntityPlayer _player) {
        this(null, _player);
    }

    public ContainerGasStorage(IMEMonitor<IAEFluidStack> _monitor, EntityPlayer _player) {
        this.monitor = _monitor;
        this.player = _player;
        if (!this.player.field_70170_p.field_72995_K && this.monitor != null) {
            this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
            this.fluidStackList = this.monitor.getStorageList();
        } else {
            this.fluidStackList = AEApi.instance().storage().createFluidList();
        }
        this.func_75146_a(new SlotRespective(this.inventory, 0, 8, 92));
        this.func_75146_a((Slot)new SlotFurnace(this.player, (IInventory)this.inventory, 1, 26, 92));
        this.bindPlayerInventory(this.player.field_71071_by);
    }

    public ContainerGasStorage(IMEMonitor<IAEFluidStack> _monitor, EntityPlayer _player, IPortableGasStorageCell _storageCell) {
        this.hasWirelessTermHandler = _storageCell != null;
        this.storageCell = _storageCell;
        this.monitor = _monitor;
        this.player = _player;
        if (!this.player.field_70170_p.field_72995_K && this.monitor != null) {
            this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
            this.fluidStackList = this.monitor.getStorageList();
        } else {
            this.fluidStackList = AEApi.instance().storage().createFluidList();
        }
        this.func_75146_a(new SlotRespective(this.inventory, 0, 8, 92));
        this.func_75146_a((Slot)new SlotFurnace(this.player, (IInventory)this.inventory, 1, 26, 92));
        this.bindPlayerInventory(this.player.field_71071_by);
    }

    public ContainerGasStorage(IMEMonitor<IAEFluidStack> _monitor, EntityPlayer _player, IWirelessGasTermHandler _handler) {
        this.hasWirelessTermHandler = _handler != null;
        this.handler = _handler;
        this.monitor = _monitor;
        this.player = _player;
        if (!this.player.field_70170_p.field_72995_K && this.monitor != null) {
            this.monitor.addListener((IMEMonitorHandlerReceiver)this, null);
            this.fluidStackList = this.monitor.getStorageList();
        } else {
            this.fluidStackList = AEApi.instance().storage().createFluidList();
        }
        this.func_75146_a(new SlotRespective(this.inventory, 0, 8, 92));
        this.func_75146_a((Slot)new SlotFurnace(this.player, (IInventory)this.inventory, 1, 26, 92));
        this.bindPlayerInventory(this.player.field_71071_by);
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new SlotPlayerInventory((IInventory)inventoryPlayer, this, j + i * 9 + 9, 8 + j * 18, i * 18 + 122));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new SlotPlayerInventory((IInventory)inventoryPlayer, this, i, 8 + i * 18, 180));
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return true;
    }

    public void decreaseFirstSlot() {
        ItemStack slot = this.inventory.func_70301_a(0);
        if (slot == null) {
            return;
        }
        --slot.field_77994_a;
        if (slot.field_77994_a <= 0) {
            this.inventory.func_70299_a(0, null);
        }
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public void doWork() {
        ItemStack secondSlot = this.inventory.func_70301_a(1);
        if (secondSlot != null && secondSlot.field_77994_a > secondSlot.func_77976_d()) {
            return;
        }
        ItemStack container = this.inventory.func_70301_a(0);
        if (container == null) {
            this.doNextFill = false;
        }
        if (!GasUtil.isGasContainer(container)) {
            return;
        }
        if (this.monitor == null) {
            return;
        }
        GasStack gasStack = GasUtil.getGasFromContainer(container);
        container = container.func_77946_l();
        container.field_77994_a = 1;
        if (GasUtil.isEmpty(container) || gasStack.amount < GasUtil.getCapacity(container) && GasUtil.getFluidStack(gasStack).getFluid() == this.selectedFluid && this.doNextFill) {
            if (this.selectedFluid == null) {
                return;
            }
            int capacity = GasUtil.getCapacity(container);
            IAEFluidStack result = (IAEFluidStack)this.monitor.extractItems((IAEStack)FluidUtil.createAEFluidStack(this.selectedFluid, (long)capacity), Actionable.SIMULATE, (BaseActionSource)new PlayerSource(this.player, null));
            int proposedAmount = result == null ? 0 : (gasStack == null ? (int)Math.min((long)capacity, result.getStackSize()) : (int)Math.min((long)(capacity - gasStack.amount), result.getStackSize()));
            MutablePair<Integer, ItemStack> filledContainer = GasUtil.fillStack(container, GasUtil.getGasStack(new FluidStack(this.selectedFluid, proposedAmount)));
            GasStack gasStack2 = GasUtil.getGasFromContainer((ItemStack)filledContainer.getRight());
            if (container.field_77994_a == 1 && gasStack2.amount < GasUtil.getCapacity((ItemStack)filledContainer.getRight())) {
                this.inventory.func_70299_a(0, (ItemStack)filledContainer.getRight());
                this.monitor.extractItems((IAEStack)FluidUtil.createAEFluidStack(this.selectedFluid, (long)((Integer)filledContainer.getLeft()).intValue()), Actionable.MODULATE, (BaseActionSource)new PlayerSource(this.player, null));
                this.doNextFill = true;
            } else if (this.fillSecondSlot((ItemStack)filledContainer.getRight())) {
                this.monitor.extractItems((IAEStack)FluidUtil.createAEFluidStack(this.selectedFluid, (long)((Integer)filledContainer.getLeft()).intValue()), Actionable.MODULATE, (BaseActionSource)new PlayerSource(this.player, null));
                this.decreaseFirstSlot();
                this.doNextFill = false;
            }
        } else if (GasUtil.isFilled(container)) {
            GasStack containerGas = GasUtil.getGasFromContainer(container);
            MutablePair<Integer, ItemStack> drainedContainer = GasUtil.drainStack(container.func_77946_l(), containerGas);
            GasStack gasStack1 = containerGas.copy();
            gasStack1.amount = (Integer)drainedContainer.getLeft();
            IAEFluidStack notInjected = (IAEFluidStack)this.monitor.injectItems((IAEStack)GasUtil.createAEFluidStack(gasStack1), Actionable.SIMULATE, (BaseActionSource)new PlayerSource(this.player, null));
            if (notInjected != null) {
                return;
            }
            if (this.handler != null) {
                if (!this.handler.hasPower(this.player, 20.0, this.player.func_71045_bC())) {
                    return;
                }
                this.handler.usePower(this.player, 20.0, this.player.func_71045_bC());
            } else if (this.storageCell != null) {
                if (!this.storageCell.hasPower(this.player, 20.0, this.player.func_71045_bC())) {
                    return;
                }
                this.storageCell.usePower(this.player, 20.0, this.player.func_71045_bC());
            }
            ItemStack emptyContainer = (ItemStack)drainedContainer.getRight();
            if (emptyContainer != null && GasUtil.getGasFromContainer(emptyContainer) != null && emptyContainer.field_77994_a == 1) {
                this.monitor.injectItems((IAEStack)GasUtil.createAEFluidStack(gasStack1), Actionable.MODULATE, (BaseActionSource)new PlayerSource(this.player, null));
                this.inventory.func_70299_a(0, emptyContainer);
            } else if (emptyContainer == null || this.fillSecondSlot((ItemStack)drainedContainer.getRight())) {
                this.monitor.injectItems((IAEStack)GasUtil.createAEFluidStack(containerGas), Actionable.MODULATE, (BaseActionSource)new PlayerSource(this.player, null));
                this.decreaseFirstSlot();
            }
        }
    }

    public boolean fillSecondSlot(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        ItemStack secondSlot = this.inventory.func_70301_a(1);
        if (secondSlot == null) {
            if (this.handler != null) {
                if (!this.handler.hasPower(this.player, 20.0, this.player.func_71045_bC())) {
                    return false;
                }
                this.handler.usePower(this.player, 20.0, this.player.func_71045_bC());
            } else if (this.storageCell != null) {
                if (!this.storageCell.hasPower(this.player, 20.0, this.player.func_71045_bC())) {
                    return false;
                }
                this.storageCell.usePower(this.player, 20.0, this.player.func_71045_bC());
            }
            this.inventory.func_70299_a(1, itemStack);
            return true;
        }
        if (!secondSlot.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)secondSlot)) {
            return false;
        }
        if (this.handler != null) {
            if (!this.handler.hasPower(this.player, 20.0, this.player.func_71045_bC())) {
                return false;
            }
            this.handler.usePower(this.player, 20.0, this.player.func_71045_bC());
        } else if (this.storageCell != null) {
            if (!this.storageCell.hasPower(this.player, 20.0, this.player.func_71045_bC())) {
                return false;
            }
            this.storageCell.usePower(this.player, 20.0, this.player.func_71045_bC());
        }
        this.inventory.incrStackSize(1, itemStack.field_77994_a);
        return true;
    }

    public void forceFluidUpdate() {
        if (this.monitor != null) {
            new PacketFluidStorage(this.player, (IItemList<IAEFluidStack>)this.monitor.getStorageList()).sendPacketToPlayer(this.player);
        }
        new PacketFluidStorage(this.player, this.hasWirelessTermHandler).sendPacketToPlayer(this.player);
    }

    public IItemList<IAEFluidStack> getFluidStackList() {
        return this.fluidStackList;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public Fluid getSelectedFluid() {
        return this.selectedFluid;
    }

    public IAEFluidStack getSelectedFluidStack() {
        return this.selectedFluidStack;
    }

    @Override
    public boolean hasWirelessTermHandler() {
        return this.hasWirelessTermHandler;
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void func_75134_a(EntityPlayer entityPlayer) {
        super.func_75134_a(entityPlayer);
        if (!entityPlayer.field_70170_p.field_72995_K) {
            this.monitor.removeListener((IMEMonitorHandlerReceiver)this);
            for (int i = 0; i < 2; ++i) {
                this.player.func_71019_a(((Slot)this.field_75151_b.get(i)).func_75211_c(), false);
            }
        }
    }

    @Override
    public void onInventoryChanged() {
    }

    public void onListUpdate() {
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource actionSource) {
        this.fluidStackList = ((IMEMonitor)monitor).getStorageList();
        new PacketFluidStorage(this.player, this.fluidStackList).sendPacketToPlayer(this.player);
        new PacketFluidStorage(this.player, this.hasWirelessTermHandler).sendPacketToPlayer(this.player);
    }

    public void receiveSelectedFluid(Fluid _selectedFluid) {
        this.selectedFluid = _selectedFluid;
        if (this.selectedFluid != null) {
            for (IAEFluidStack stack : this.fluidStackList) {
                if (stack == null || stack.getFluid() != this.selectedFluid) continue;
                this.selectedFluidStack = stack;
                break;
            }
        } else {
            this.selectedFluidStack = null;
        }
        if (this.guiGasStorage != null) {
            this.guiGasStorage.updateSelectedFluid();
        }
    }

    public void removeEnergyTick() {
        if (this.handler != null) {
            if (this.handler.hasPower(this.player, 1.0, this.player.func_71045_bC())) {
                this.handler.usePower(this.player, 1.0, this.player.func_71045_bC());
            }
        } else if (this.storageCell != null && this.storageCell.hasPower(this.player, 0.5, this.player.func_71045_bC())) {
            this.storageCell.usePower(this.player, 0.5, this.player.func_71045_bC());
        }
    }

    public void setGui(GuiGasStorage _guiGasStorage) {
        this.guiGasStorage = _guiGasStorage;
    }

    @Override
    public void setSelectedFluid(Fluid _selectedFluid) {
        new PacketFluidStorage(this.player, _selectedFluid).sendPacketToServer();
        this.receiveSelectedFluid(_selectedFluid);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotnumber) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotnumber);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (this.inventory.func_94041_b(0, itemstack1)) {
                if (slotnumber == 0 || slotnumber == 1 ? !this.func_75135_a(itemstack1, 2, 36, false) : !this.func_75135_a(itemstack1, 0, 1, false)) {
                    return null;
                }
                if (itemstack1.field_77994_a == 0) {
                    slot.func_75215_d(null);
                } else {
                    slot.func_75218_e();
                }
            } else {
                return null;
            }
        }
        return itemstack;
    }

    public void updateFluidList(IItemList<IAEFluidStack> _fluidStackList) {
        this.fluidStackList = _fluidStackList;
        if (this.guiGasStorage != null) {
            this.guiGasStorage.updateFluids();
        }
    }
}

