/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.movers;

import com.rwtema.funkylocomotion.blocks.BlockMoving;
import com.rwtema.funkylocomotion.blocks.TileMovingServer;
import com.rwtema.funkylocomotion.description.DescriptorRegistry;
import com.rwtema.funkylocomotion.factory.FactoryRegistry;
import com.rwtema.funkylocomotion.helper.BlockHelper;
import com.rwtema.funkylocomotion.movers.MovingTileRegistry;
import com.rwtema.funkylocomotion.network.FLNetwork;
import com.rwtema.funkylocomotion.network.MessageClearTile;
import framesapi.BlockPos;
import framesapi.IDescriptionProxy;
import framesapi.IMoveFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.server.management.PlayerManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public class MoveManager {
    public static final NBTTagCompound airBlockTag = new NBTTagCompound();
    public static final NBTTagCompound airDescTag = new NBTTagCompound();

    public static void startMoving(World world, List<BlockPos> list, ForgeDirection dir, int maxTime) {
        PlayerManager.PlayerInstance watcher;
        TileMovingServer tile;
        if (dir == ForgeDirection.UNKNOWN) {
            throw new IllegalArgumentException("Direction cannot be unknown.");
        }
        HashSet<BlockPos> newBlocks = new HashSet<BlockPos>();
        HashSet<BlockPos> oldBlocks = new HashSet<BlockPos>();
        oldBlocks.addAll(list);
        for (BlockPos blockPos : list) {
            BlockPos advance = blockPos.advance(dir);
            if (!list.contains(advance)) {
                newBlocks.add(advance);
            }
            oldBlocks.remove(advance);
        }
        HashMap<BlockPos, Entry> movers = new HashMap<BlockPos, Entry>();
        for (BlockPos pos : newBlocks) {
            BlockHelper.breakBlockWithDrop(world, pos);
        }
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        HashSet watchingPlayers = new HashSet();
        HashSet<TileEntity> inventories = new HashSet<TileEntity>();
        for (BlockPos pos : list) {
            TileEntity tile2;
            BlockPos advance = pos.advance(dir);
            Entry e = new Entry(advance, dir, maxTime);
            e.block = world.func_147439_a(pos.x, pos.y, pos.z);
            e.meta = world.func_72805_g(pos.x, pos.y, pos.z);
            e.lightopacity = e.block.getLightOpacity((IBlockAccess)world, pos.x, pos.y, pos.z);
            e.lightlevel = e.block.getLightValue((IBlockAccess)world, pos.x, pos.y, pos.z);
            ArrayList axes = new ArrayList();
            e.block.func_149743_a(world, pos.x, pos.y, pos.z, TileEntity.INFINITE_EXTENT_AABB, axes, null);
            if (axes.size() > 0) {
                e.bb = new ArrayList<AxisAlignedBB>();
                for (AxisAlignedBB bb : axes) {
                    e.bb.add(AxisAlignedBB.func_72330_a((double)(bb.field_72340_a - (double)pos.x), (double)(bb.field_72338_b - (double)pos.y), (double)(bb.field_72339_c - (double)pos.z), (double)(bb.field_72336_d - (double)pos.x), (double)(bb.field_72337_e - (double)pos.y), (double)(bb.field_72334_f - (double)pos.z)));
                }
            }
            NBTTagCompound descriptor = new NBTTagCompound();
            descriptor.func_74768_a("Block", Block.func_149682_b((Block)e.block));
            if (e.meta != 0) {
                descriptor.func_74774_a("Meta", (byte)e.meta);
            }
            if ((tile2 = world.func_147438_o(pos.x, pos.y, pos.z)) != null) {
                boolean flag = false;
                for (IDescriptionProxy d : DescriptorRegistry.getProxyList()) {
                    if (!d.canHandleTile(tile2)) continue;
                    d.addDescriptionToTags(descriptor, tile2);
                    if (!"".equals("DescID")) {
                        descriptor.func_74778_a("DescID", d.getID());
                    }
                    flag = true;
                    break;
                }
                if (!flag) {
                    descriptor.func_74757_a("DNR", true);
                }
                if (tile2 instanceof IInventory) {
                    inventories.add(tile2);
                }
            }
            e.description = descriptor;
            chunks.add(BlockHelper.getChunk(world, pos));
            movers.put(advance, e);
        }
        for (Chunk c : chunks) {
            PlayerManager.PlayerInstance chunkWatcher;
            List ticks = world.func_72920_a(c, false);
            if (ticks != null) {
                long k = world.func_82737_E();
                for (NextTickListEntry tick : ticks) {
                    BlockPos p = new BlockPos(tick.field_77183_a, tick.field_77181_b, tick.field_77182_c);
                    if (BlockHelper.getBlock(c, p) != tick.func_151351_a() || !movers.containsKey(p = p.advance(dir))) continue;
                    Entry e = (Entry)movers.get(p);
                    e.scheduledTickTime = (int)(tick.field_77180_e - k);
                    e.scheduledTickPriority = tick.field_82754_f;
                }
            }
            if ((chunkWatcher = FLNetwork.getChunkWatcher(c, world)) == null) continue;
            watchingPlayers.addAll(chunkWatcher.field_73263_b);
        }
        for (BlockPos pos : list) {
            IMoveFactory factory = FactoryRegistry.getFactory(world, pos);
            NBTTagCompound block = factory.destroyBlock(world, pos);
            BlockPos advance = pos.advance(dir);
            ((Entry)movers.get((Object)advance)).blockTag = block;
        }
        block8: for (EntityPlayer watchingPlayer : watchingPlayers) {
            if (watchingPlayer.field_71070_bA == watchingPlayer.field_71069_bz || watchingPlayer.field_71070_bA == null) continue;
            for (Object o : watchingPlayer.field_71070_bA.field_75151_b) {
                Slot s = (Slot)o;
                if (!inventories.contains(s.field_75224_c)) continue;
                watchingPlayer.func_71053_j();
                continue block8;
            }
        }
        for (BlockPos pos : list) {
            BlockHelper.silentClear(BlockHelper.getChunk(world, pos), pos);
            FLNetwork.sendToAllWatchingChunk(world, pos.x, pos.y, pos.z, new MessageClearTile(pos));
            world.func_147475_p(pos.x, pos.y, pos.z);
        }
        for (BlockPos pos : oldBlocks) {
            BlockHelper.postUpdateBlock(world, pos);
        }
        ArrayList<TileMovingServer> tiles = new ArrayList<TileMovingServer>();
        for (Entry e : movers.values()) {
            world.func_147465_d(e.pos.x, e.pos.y, e.pos.z, (Block)BlockMoving.instance, 0, 1);
            tile = (TileMovingServer)world.func_147438_o(e.pos.x, e.pos.y, e.pos.z);
            tile.block = e.blockTag;
            tile.desc = e.description;
            tile.dir = e.dir;
            tile.maxTime = e.time;
            tile.lightLevel = e.lightlevel;
            tile.lightOpacity = e.lightopacity;
            tile.scheduledTickTime = e.scheduledTickTime;
            tile.scheduledTickPriority = e.scheduledTickPriority;
            if (e.bb != null) {
                tile.collisions = e.bb.toArray(new AxisAlignedBB[e.bb.size()]);
            }
            tile.isAir = false;
            tiles.add(tile);
        }
        for (BlockPos pos : list) {
            if (movers.containsKey(pos)) continue;
            world.func_147465_d(pos.x, pos.y, pos.z, (Block)BlockMoving.instance, 0, 1);
            tile = (TileMovingServer)world.func_147438_o(pos.x, pos.y, pos.z);
            tile.block = (NBTTagCompound)airBlockTag.func_74737_b();
            tile.desc = (NBTTagCompound)airDescTag.func_74737_b();
            tile.dir = dir;
            tile.maxTime = maxTime;
            tile.lightLevel = 0;
            tile.lightOpacity = 0;
            tile.isAir = true;
            tiles.add(tile);
        }
        for (TileMovingServer tile3 : tiles) {
            watcher = FLNetwork.getChunkWatcher(world, tile3.field_145851_c, tile3.field_145849_e);
            watcher.func_151251_a((Packet)new S23PacketBlockChange(tile3.field_145851_c, tile3.field_145848_d, tile3.field_145849_e, world));
        }
        for (TileMovingServer tile3 : tiles) {
            watcher = FLNetwork.getChunkWatcher(world, tile3.field_145851_c, tile3.field_145849_e);
            Packet packet = tile3.func_145844_m();
            if (packet == null) continue;
            watcher.func_151251_a(packet);
        }
    }

    public static void finishMoving() {
        BlockPos pos;
        List<TileMovingServer> tiles = MovingTileRegistry.getTilesFinishedMoving();
        HashSet<Chunk> chunks = new HashSet<Chunk>();
        for (TileMovingServer tile : tiles) {
            chunks.add(tile.func_145831_w().func_72938_d(tile.field_145851_c, tile.field_145849_e));
            tile.func_145831_w().func_147465_d(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, Blocks.field_150350_a, 0, 0);
            tile.func_145831_w().func_147465_d(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, Blocks.field_150348_b, 0, 0);
        }
        for (TileMovingServer tile : tiles) {
            pos = new BlockPos(tile);
            if (tile.block == null) continue;
            BlockHelper.silentClear(BlockHelper.getChunk(tile.func_145831_w(), pos), pos);
            Block block = Block.func_149684_b((String)tile.block.func_74779_i("Block"));
            if (block == null) {
                block = Blocks.field_150350_a;
            }
            IMoveFactory factory = FactoryRegistry.getFactory(block);
            factory.recreateBlock(tile.func_145831_w(), pos, tile.block);
        }
        for (TileMovingServer tile : tiles) {
            pos = new BlockPos(tile);
            BlockHelper.postUpdateBlock(tile.func_145831_w(), pos);
            if (tile.scheduledTickTime == -1) continue;
            tile.func_145831_w().func_147454_a(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, BlockHelper.getBlock(tile.func_145831_w(), pos), tile.scheduledTickTime - tile.maxTime, tile.scheduledTickPriority);
        }
        for (Chunk chunk : chunks) {
            FLNetwork.updateChunk(chunk);
        }
        for (TileMovingServer tile : tiles) {
            EntityPlayer player;
            if (tile.activatingPlayer == null || (player = (EntityPlayer)tile.activatingPlayer.get()) == null) continue;
            Block b = BlockHelper.getBlock(tile.func_145831_w(), new BlockPos(tile));
            b.func_149727_a(tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, player, tile.activatingSide, tile.activatingHitX, tile.activatingHitY, tile.activatingHitZ);
        }
    }

    static {
        if (Block.func_149682_b((Block)Blocks.field_150350_a) != 0) {
            airDescTag.func_74768_a("Block", Block.func_149682_b((Block)Blocks.field_150350_a));
        }
    }

    private static class Entry {
        public int scheduledTickTime = -1;
        public int scheduledTickPriority;
        NBTTagCompound blockTag;
        NBTTagCompound description;
        final BlockPos pos;
        final ForgeDirection dir;
        final int time;
        Block block;
        int meta;
        List<AxisAlignedBB> bb = null;
        int lightlevel;
        int lightopacity;

        public Entry(BlockPos pos, ForgeDirection dir, int time) {
            this.pos = pos;
            this.dir = dir;
            this.time = time;
        }
    }
}

