/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion.movepermissions;

import com.rwtema.funkylocomotion.movepermissions.IMoveChecker;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class MoveCheckReflector
implements IMoveChecker {
    private static final HashMap<Class<?>, Boolean> cache = new HashMap();

    public static boolean canMoveClass(Class<?> clazz) {
        Boolean b = cache.get(clazz);
        if (b == null) {
            b = MoveCheckReflector._canMoveClass(clazz);
            cache.put(clazz, b);
        }
        return b;
    }

    private static boolean _canMoveClass(Class<?> clazz) {
        try {
            Method method = clazz.getMethod("_Immovable", new Class[0]);
            if (Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers()) && method.getReturnType() == Boolean.TYPE) {
                Boolean b = (Boolean)method.invoke(null, new Object[0]);
                return b == null || b == false;
            }
            return true;
        }
        catch (NoSuchMethodException e) {
            return true;
        }
        catch (InvocationTargetException e) {
            return true;
        }
        catch (IllegalAccessException e) {
            return true;
        }
        catch (RuntimeException e) {
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return true;
        }
    }

    @Override
    public boolean preventMovement(World world, int x, int y, int z, Block block, int meta, TileEntity tile) {
        return !MoveCheckReflector.canMoveClass(block.getClass()) || tile != null && !MoveCheckReflector.canMoveClass(tile.getClass());
    }
}

