/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.reputation;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.FileVersion;
import hardcorequesting.SaveHelper;
import hardcorequesting.Translator;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiEditMenu;
import hardcorequesting.client.interfaces.GuiQuestBook;
import hardcorequesting.client.interfaces.ResourceHelper;
import hardcorequesting.network.DataBitHelper;
import hardcorequesting.quests.Quest;
import hardcorequesting.quests.QuestSet;
import hardcorequesting.reputation.Reputation;
import net.minecraft.entity.player.EntityPlayer;

public class ReputationBar {
    private int repId;
    private int x;
    private int y;
    private int questSet;
    private static final int posBits = 9;
    private static final int posBitMask = 511;

    public ReputationBar(Reputation reputation, int x, int y, QuestSet questSet) {
        this(reputation.getId(), x, y, questSet.getId());
    }

    public ReputationBar(int repId, int x, int y, int questSet) {
        this.repId = repId;
        this.x = x;
        this.y = y;
        this.questSet = questSet;
    }

    public ReputationBar(FileVersion version, int data) {
        int questSetSize = DataBitHelper.QUEST_SETS.getBitCount(version);
        this.repId = data >> questSetSize + 18;
        this.x = data >> questSetSize + 9 & 0x1FF;
        this.y = data >> questSetSize & 0x1FF;
        this.questSet = data & (1 << questSetSize + 1) - 1;
    }

    public void moveTo(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getRepId() {
        return this.repId;
    }

    public int save() {
        int questSetSize = DataBitHelper.QUEST_SETS.getBitCount();
        return this.repId << questSetSize + 18 | this.x << questSetSize + 9 | this.y << questSetSize | this.questSet;
    }

    public QuestSet getQuestSet() {
        return Quest.getQuestSets().get(this.questSet);
    }

    public void setQuestSet(int id) {
        this.questSet = id;
    }

    public boolean isValid() {
        return Quest.getQuestSets().size() > this.questSet && this.getQuestSet() != null && Reputation.getReputation(this.repId) != null;
    }

    public boolean sameLocation(ReputationBar reputationBar) {
        return reputationBar != null && reputationBar.x == this.x && reputationBar.y == this.y;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(GuiQuestBook gui, int mX, int mY, EntityPlayer player) {
        Reputation reputation = Reputation.getReputation(this.repId);
        if (reputation == null) {
            return;
        }
        gui.applyColor(-1);
        ResourceHelper.bindResource(GuiQuestBook.MAP_TEXTURE);
        String info = reputation.draw(gui, this.x, this.y, mX, mY, null, player, false, null, null, false, null, null, false);
        if (info != null) {
            gui.drawMouseOver(info, mX + gui.getLeft(), mY + gui.getTop());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean inBounds(int mX, int mY) {
        return this.x <= mX && this.x + 125 >= mX && this.y - 9 <= mY && this.y + 18 >= mY;
    }

    @SideOnly(value=Side.CLIENT)
    public void mouseClicked(GuiQuestBook gui, int x, int y) {
        if (this.inBounds(x, y)) {
            switch (gui.getCurrentMode()) {
                case MOVE: {
                    gui.modifyingBar = this;
                    SaveHelper.add(SaveHelper.EditType.REPUTATION_BAR_MOVE);
                    break;
                }
                case REP_BAR_CHANGE: {
                    gui.setEditMenu(new EditGui((GuiBase)gui, gui.getPlayer(), this));
                    break;
                }
                case DELETE: {
                    this.getQuestSet().removeRepBar(this);
                    SaveHelper.add(SaveHelper.EditType.REPUTATION_BAR_REMOVE);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class EditGui
    extends GuiEditMenu {
        private ReputationBar bar;
        private boolean isNew;

        public EditGui(GuiBase guiBase, EntityPlayer player, ReputationBar bar) {
            super(guiBase, player);
            this.bar = bar;
            this.isNew = false;
        }

        public EditGui(GuiBase guiBase, EntityPlayer player, int x, int y, int selectedSet) {
            super(guiBase, player);
            this.bar = new ReputationBar(-1, x, y, selectedSet);
            this.isNew = true;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void draw(GuiBase guiB, int mX, int mY) {
            GuiQuestBook gui = (GuiQuestBook)guiB;
            int start = gui.reputationScroll.isVisible(gui) ? Math.round((float)(Reputation.getReputationList().size() - 10) * gui.reputationScroll.getScroll()) : 0;
            int end = Math.min(start + 10, Reputation.getReputationList().size());
            for (int i = start; i < end; ++i) {
                int x = 20;
                int y = 20 + (i - start) * 20;
                String str = Reputation.getReputationList().get(i).getName();
                boolean hover = gui.inBounds(x, y, gui.getStringWidth(str), 9, mX, mY);
                boolean selected = Reputation.getReputationList().get(i).equals(Reputation.getReputation(this.bar.repId));
                gui.drawString(str, x, y, selected ? (hover ? 0x40CC40 : 0x409040) : (hover ? 0xAAAAAA : 0x404040));
            }
            gui.drawString(gui.getLinesFromText(Translator.translate("hqm.rep.select"), 1.0f, 120), 180, 20, 1.0f, 0x404040);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onClick(GuiBase guiB, int mX, int mY, int b) {
            super.onClick(guiB, mX, mY, b);
            GuiQuestBook gui = (GuiQuestBook)guiB;
            int start = gui.reputationScroll.isVisible(gui) ? Math.round((float)(Reputation.getReputationList().size() - 10) * gui.reputationScroll.getScroll()) : 0;
            int end = Math.min(start + 10, Reputation.getReputationList().size());
            for (int i = start; i < end; ++i) {
                int x = 20;
                int y = 20 + (i - start) * 20;
                String str = Reputation.getReputationList().get(i).getName();
                if (!gui.inBounds(x, y, gui.getStringWidth(str), 9, mX, mY)) continue;
                this.bar.repId = Reputation.getReputationList().get(i).getId();
                this.save(guiB);
                this.close(guiB);
            }
        }

        @Override
        protected void save(GuiBase gui) {
            if (this.isNew) {
                Quest.getQuestSets().get(this.bar.questSet).addRepBar(this.bar);
                SaveHelper.add(SaveHelper.EditType.REPUTATION_BAR_ADD);
            } else {
                SaveHelper.add(SaveHelper.EditType.REPUTATION_BAR_CHANGE);
            }
        }
    }
}

