/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.quests;

import hardcorequesting.Translator;
import hardcorequesting.client.interfaces.GuiColor;
import hardcorequesting.quests.Quest;
import net.minecraft.entity.player.EntityPlayer;

public enum RepeatType {
    NONE("none", false){

        @Override
        public String getMessage(Quest quest, EntityPlayer player, int days, int hours) {
            return null;
        }
    }
    ,
    INSTANT("instant", false){

        @Override
        public String getMessage(Quest quest, EntityPlayer player, int days, int hours) {
            return super.getMessage(quest, player, days, hours) + (Object)((Object)GuiColor.GRAY) + Translator.translate("hqm.repeat.instant.message");
        }

        @Override
        public String getShortMessage(int days, int hours) {
            return (Object)((Object)GuiColor.YELLOW) + Translator.translate("hqm.repeat.instant.message");
        }
    }
    ,
    INTERVAL("interval", true){

        @Override
        public String getMessage(Quest quest, EntityPlayer player, int days, int hours) {
            return super.getMessage(quest, player, days, hours) + (Object)((Object)GuiColor.GRAY) + Translator.translate("hqm.repeat.interval.message") + "\n" + RepeatType.formatTime(days, hours) + "\n" + RepeatType.formatResetTime(quest, player, days, hours);
        }

        @Override
        public String getShortMessage(int days, int hours) {
            return (Object)((Object)GuiColor.YELLOW) + Translator.translate("hqm.repeat.interval.message") + " (" + days + ":" + hours + ")";
        }
    }
    ,
    TIME("time", true){

        @Override
        public String getMessage(Quest quest, EntityPlayer player, int days, int hours) {
            return super.getMessage(quest, player, days, hours) + (Object)((Object)GuiColor.GRAY) + Translator.translate("hqm.repeat.time.message") + "\n" + RepeatType.formatTime(days, hours) + RepeatType.formatRemainingTime(quest, player, days, hours);
        }

        @Override
        public String getShortMessage(int days, int hours) {
            return (Object)((Object)GuiColor.YELLOW) + Translator.translate("hqm.repeat.time.message") + " (" + days + ":" + hours + ")";
        }
    };

    private String id;
    private boolean useTime;

    private static String formatRemainingTime(Quest quest, EntityPlayer player, int days, int hours) {
        if (!quest.getQuestData((EntityPlayer)player).available) {
            int total = days * 24 + hours;
            int time = quest.getQuestData((EntityPlayer)player).time;
            int current = Quest.clientTicker.getHours();
            total = time + total - current;
            return "\n" + RepeatType.formatResetTime(quest, player, total / 24, total % 24);
        }
        return "";
    }

    private static String formatResetTime(Quest quest, EntityPlayer player, int days, int hours) {
        if (days == 0 && hours == 0) {
            return (Object)((Object)GuiColor.RED) + Translator.translate("hqm.repeat.invalid");
        }
        int total = days * 24 + hours;
        int resetHoursTotal = total - Quest.clientTicker.getHours() % total;
        int resetDays = resetHoursTotal / 24;
        int resetHours = resetHoursTotal % 24;
        if (!quest.isAvailable(player)) {
            return (Object)((Object)GuiColor.YELLOW) + Translator.translate("hqm.repeat.resetIn", RepeatType.formatTime(resetDays, resetHours));
        }
        return (Object)((Object)GuiColor.GRAY) + Translator.translate("hqm.repeat.nextReset", RepeatType.formatTime(resetDays, resetHours));
    }

    private static String formatTime(int days, int hours) {
        String str = GuiColor.GRAY.toString();
        if (days > 0) {
            str = str + (Object)((Object)GuiColor.LIGHT_GRAY);
        }
        str = str + days;
        str = str + " ";
        str = str + Translator.translate("hqm.repeat." + (days == 1 ? "day" : "days"));
        str = str + (Object)((Object)GuiColor.GRAY);
        str = str + " " + Translator.translate("hqm.repeat.and") + " ";
        if (hours > 0) {
            str = str + (Object)((Object)GuiColor.LIGHT_GRAY);
        }
        str = str + hours;
        str = str + " ";
        str = str + Translator.translate("hqm.repeat." + (hours == 1 ? "hour" : "hours"));
        return str;
    }

    private RepeatType(String id, boolean useTime) {
        this.id = id;
        this.useTime = useTime;
    }

    public String getName() {
        return Translator.translate("hqm.repeat." + this.id + ".title");
    }

    public String getDescription() {
        return Translator.translate("hqm.repeat." + this.id + ".desc");
    }

    public boolean isUseTime() {
        return this.useTime;
    }

    public String getMessage(Quest quest, EntityPlayer player, int days, int hours) {
        return (Object)((Object)GuiColor.YELLOW) + Translator.translate("hqm.repeat.repeatable") + "\n";
    }

    public String getShortMessage(int days, int hours) {
        return null;
    }
}

