/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import hardcorequesting.DeathType;
import hardcorequesting.HardcoreQuesting;
import hardcorequesting.QuestingData;
import hardcorequesting.Translator;
import hardcorequesting.client.sounds.SoundHandler;
import hardcorequesting.client.sounds.Sounds;
import hardcorequesting.config.ModConfig;
import hardcorequesting.items.ItemInfo;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class ItemHeart
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;
    public static final String[] names = ItemInfo.HEART_ICONS;

    public ItemHeart() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(64);
        this.func_77637_a(HardcoreQuesting.HQMTab);
        this.func_77655_b("hqm:hearts");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister icon) {
        this.pickIcon(icon);
    }

    private void pickIcon(IIconRegister icon) {
        this.icons = new IIcon[ItemInfo.HEART_ICONS.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = icon.func_94245_a("hqm:" + ItemInfo.HEART_ICONS[i]);
        }
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        int i = MathHelper.func_76125_a((int)par1ItemStack.func_77960_j(), (int)0, (int)15);
        return super.func_77658_a() + "_" + names[i];
    }

    public IIcon func_77617_a(int par1) {
        return this.icons[par1];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTabs, List stackList) {
        for (int x = 0; x < ItemInfo.HEART_ICONS.length; ++x) {
            stackList.add(new ItemStack((Item)this, 1, x));
        }
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (item.func_77960_j() == 3) {
                if (!QuestingData.isHardcoreActive()) {
                    player.func_146105_b(Translator.translateToIChatComponent("hqm.message.noHardcoreYet", new Object[0]));
                } else if (QuestingData.getQuestingData(player).getRawLives() < ModConfig.MAXLIVES) {
                    QuestingData.getQuestingData(player).addLives(player, 1);
                    player.func_146105_b(Translator.translateToIChatComponent("hqm.message.addOne", new Object[0]));
                    int lives = QuestingData.getQuestingData(player).getLives();
                    player.func_146105_b(Translator.translateToIChatComponent("hqm.message.haveRemaining", lives));
                    SoundHandler.play(Sounds.LIFE, player);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --item.field_77994_a;
                    }
                } else {
                    player.func_146105_b(Translator.translateToIChatComponent("hqm.message.haveMaxLives", new Object[0]));
                }
            }
            if (item.func_77960_j() == 4) {
                if (!QuestingData.isHardcoreActive()) {
                    player.func_146105_b(Translator.translateToIChatComponent("hqm.message.noHardcoreYet", new Object[0]));
                } else {
                    SoundHandler.play(Sounds.ROTTEN, player);
                    player.func_146105_b(Translator.translateToIChatComponent("hqm.message.eatRottenHearth", new Object[0]));
                    QuestingData.getQuestingData(player).removeLifeAndSendMessage(player);
                    DeathType.HQM.onDeath(player);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --item.field_77994_a;
                    }
                }
            }
            return item;
        }
        return item;
    }

    public void func_77624_a(ItemStack item, EntityPlayer player, List tooltip, boolean extraInfo) {
        super.func_77624_a(item, player, tooltip, extraInfo);
        if (item.func_77960_j() == 3) {
            tooltip.add(Translator.translate("item.hqm:hearts_heart.tooltip"));
            if (ModConfig.ROTTIMER) {
                NBTTagCompound tagCompound = item.func_77978_p();
                if (tagCompound == null) {
                    tagCompound = new NBTTagCompound();
                    item.func_77982_d(tagCompound);
                }
                if (tagCompound.func_74764_b("RotTime")) {
                    int rot = tagCompound.func_74762_e("RotTime");
                    int maxRot = tagCompound.func_74762_e("MaxRot");
                    float percentage = rot * 100 / maxRot;
                    tooltip.add(Translator.translate("item.hqm:hearts_heart.freshness", Float.valueOf(percentage)));
                }
            }
        }
        if (item.func_77960_j() == 4) {
            tooltip.add(Translator.translate("item.hqm:hearts_rottenheart.tooltip"));
        }
    }

    public boolean hasEffect(ItemStack item, int pass) {
        return item.func_77960_j() == 3 || item.func_77960_j() == 4;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            if (itemStack.func_77960_j() == 3 && ModConfig.ROTTIMER) {
                NBTTagCompound tagCompound = itemStack.func_77978_p();
                if (tagCompound == null) {
                    tagCompound = new NBTTagCompound();
                    itemStack.func_77982_d(tagCompound);
                }
                if (!tagCompound.func_74764_b("RotTime")) {
                    int rot = ModConfig.MAXROT * 20;
                    tagCompound.func_74768_a("MaxRot", rot);
                    tagCompound.func_74768_a("RotTime", rot);
                } else {
                    int newRot = tagCompound.func_74762_e("RotTime");
                    if (newRot <= 0) {
                        itemStack.func_77964_b(4);
                        entityPlayer.func_146105_b(Translator.translateToIChatComponent("hqm.message.hearthDecay", new Object[0]));
                    } else {
                        tagCompound.func_74768_a("RotTime", newRot - 1);
                    }
                }
            }
        }
    }
}

