/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.commands;

import hardcorequesting.Translator;
import hardcorequesting.commands.CommandBase;
import hardcorequesting.commands.CommandHandler;
import hardcorequesting.commands.ISubCommand;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandNotFoundException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class CommandHelp
extends CommandBase {
    public static final String PREFIX = "\u00a7";
    public static final String YELLOW = "\u00a7e";
    public static final String WHITE = "\u00a7f";

    public CommandHelp() {
        super("help", new String[0]);
        this.permissionLevel = -1;
    }

    @Override
    public int getPermissionLevel() {
        return -1;
    }

    @Override
    public void handleCommand(ICommandSender sender, String[] arguments) {
        switch (arguments.length) {
            case 0: {
                StringBuilder output = new StringBuilder(Translator.translate("hqm.command.info.help.start") + " ");
                ArrayList<String> commands = new ArrayList<String>();
                for (ISubCommand command : CommandHandler.commands.values()) {
                    if (!command.isVisible(sender)) continue;
                    commands.add(command.getCommandName());
                }
                for (int i = 0; i < commands.size() - 1; ++i) {
                    output.append("/").append(CommandHandler.instance.func_71517_b()).append(" ").append(YELLOW).append((String)commands.get(i)).append(WHITE).append(", ");
                }
                output.delete(output.length() - 2, output.length());
                output.append(" and /").append(CommandHandler.instance.func_71517_b()).append(" ").append(YELLOW).append((String)commands.get(commands.size() - 1)).append(WHITE).append(".");
                sender.func_145747_a((IChatComponent)new ChatComponentText(output.toString()));
                break;
            }
            case 1: {
                String commandName = arguments[0];
                if (!CommandHandler.commandExists(commandName)) {
                    throw new CommandNotFoundException("hqm.command.notFound", new Object[0]);
                }
                ISubCommand command = CommandHandler.getCommand(commandName);
                if (command.isVisible(sender)) {
                    for (int i : command.getSyntaxOptions(sender)) {
                        sender.func_145747_a((IChatComponent)new ChatComponentText(YELLOW + Translator.translate("hqm.command." + commandName + ".syntax" + i) + WHITE + " - " + Translator.translate("hqm.command." + commandName + ".info" + i)));
                    }
                    break;
                }
                throw new CommandException("hqm.command.noPermission", new Object[0]);
            }
            default: {
                throw new WrongUsageException("hqm.command." + this.getCommandName() + ".syntax", new Object[0]);
            }
        }
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            return CommandHandler.instance.func_71516_a(sender, new String[]{args[1]});
        }
        return null;
    }

    @Override
    public boolean isVisible(ICommandSender sender) {
        return true;
    }
}

