/*
 * Decompiled with CFR 0.152.
 */
package hardcorequesting.client.interfaces;

import hardcorequesting.Translator;
import hardcorequesting.client.interfaces.GuiBase;
import hardcorequesting.client.interfaces.GuiEditMenu;
import hardcorequesting.client.interfaces.GuiEditMenuExtended;
import hardcorequesting.client.interfaces.GuiEditMenuItemPortal;
import hardcorequesting.client.interfaces.LargeButton;
import hardcorequesting.tileentity.PortalType;
import hardcorequesting.tileentity.TileEntityPortal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class GuiEditMenuPortal
extends GuiEditMenuExtended {
    private TileEntityPortal portal;
    private GuiEditMenuPortal self = this;
    private static final int CHECK_BOX_X = 20;
    private static final int CHECK_BOX_Y = 110;
    private static final int CHECK_BOX_OFFSET = 12;

    public GuiEditMenuPortal(GuiBase gui, EntityPlayer player, TileEntityPortal portal) {
        super(gui, player, true, 20, 30, 20, 130);
        this.portal = portal.copy();
        this.buttons.add(new LargeButton("hqm.portalMenu.edit", 40, 80){

            @Override
            public boolean isEnabled(GuiBase gui, EntityPlayer player) {
                return true;
            }

            @Override
            public boolean isVisible(GuiBase gui, EntityPlayer player) {
                return !GuiEditMenuPortal.this.self.portal.getType().isPreset();
            }

            @Override
            public void onClick(GuiBase gui, EntityPlayer player) {
                gui.setEditMenu(new GuiEditMenuItemPortal(gui, GuiEditMenuPortal.this.self, player, GuiEditMenuPortal.this.self.portal.getItem()));
            }
        });
        this.checkboxes.add(new GuiEditMenu.CheckBox("hqm.portalMenu.collisionOnComplete", 20, 110){

            @Override
            public boolean getValue() {
                return GuiEditMenuPortal.this.self.portal.isCompletedCollision();
            }

            @Override
            public void setValue(boolean val) {
                GuiEditMenuPortal.this.self.portal.setCompletedCollision(val);
            }
        });
        this.checkboxes.add(new GuiEditMenu.CheckBox("hqm.portalMenu.texOnComplete", 20, 122){

            @Override
            public boolean getValue() {
                return GuiEditMenuPortal.this.self.portal.isCompletedTexture();
            }

            @Override
            public void setValue(boolean val) {
                GuiEditMenuPortal.this.self.portal.setCompletedTexture(val);
            }
        });
        this.checkboxes.add(new GuiEditMenu.CheckBox("hqm.portalMenu.collisionNonComplete", 20, 134){

            @Override
            public boolean getValue() {
                return GuiEditMenuPortal.this.self.portal.isUncompletedCollision();
            }

            @Override
            public void setValue(boolean val) {
                GuiEditMenuPortal.this.self.portal.setUncompletedCollision(val);
            }
        });
        this.checkboxes.add(new GuiEditMenu.CheckBox("Use textures when not completed", 20, 146){

            @Override
            public boolean getValue() {
                return GuiEditMenuPortal.this.self.portal.isUncompletedTexture();
            }

            @Override
            public void setValue(boolean val) {
                GuiEditMenuPortal.this.self.portal.setUncompletedTexture(val);
            }
        });
    }

    @Override
    public void draw(GuiBase gui, int mX, int mY) {
        super.draw(gui, mX, mY);
        gui.drawCenteredString(this.portal.getCurrentQuest() != null ? this.portal.getCurrentQuest().getName() : Translator.translate("hqm.portalMenu.noQuest"), 0, 5, 1.0f, 170, 20, 0x404040);
        if (!this.portal.getType().isPreset()) {
            gui.drawItem(this.portal.getItem(), 20, 80, mX, mY, false);
        }
    }

    @Override
    protected void onArrowClick(boolean left) {
        if (left) {
            this.portal.setType(PortalType.values()[(this.portal.getType().ordinal() + PortalType.values().length - 1) % PortalType.values().length]);
        } else {
            this.portal.setType(PortalType.values()[(this.portal.getType().ordinal() + 1) % PortalType.values().length]);
        }
    }

    @Override
    protected String getArrowText() {
        return this.portal.getType().getName();
    }

    @Override
    protected String getArrowDescription() {
        return this.portal.getType().getDescription();
    }

    @Override
    protected void save(GuiBase gui) {
        this.portal.sendToServer();
    }

    @Override
    public boolean doesRequiredDoublePage() {
        return false;
    }

    public void setItem(ItemStack item) {
        this.portal.setItem(item);
    }
}

