/*
 * Decompiled with CFR 0.152.
 */
package com.InfinityRaider.AgriCraft.utility.multiblock;

import com.InfinityRaider.AgriCraft.utility.CoordinateIterator;
import com.InfinityRaider.AgriCraft.utility.LogHelper;
import com.InfinityRaider.AgriCraft.utility.multiblock.IMultiBlockComponent;
import com.InfinityRaider.AgriCraft.utility.multiblock.IMultiBlockManager;
import com.InfinityRaider.AgriCraft.utility.multiblock.MultiBlockPartData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MultiBlockManager
implements IMultiBlockManager<MultiBlockPartData> {
    private static MultiBlockManager INSTANCE;

    private MultiBlockManager() {
    }

    public static MultiBlockManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MultiBlockManager();
        }
        return INSTANCE;
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, IMultiBlockComponent component) {
        boolean flag = false;
        for (ForgeDirection dir : ForgeDirection.values()) {
            IMultiBlockComponent componentAt;
            TileEntity te;
            if (dir == ForgeDirection.UNKNOWN || (te = world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) == null || !(te instanceof IMultiBlockComponent) || !component.isValidComponent((IMultiBlockComponent)te) || !this.canCheckForMultiBlock(componentAt = (IMultiBlockComponent)te)) continue;
            if (this.checkForMultiBlock(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, componentAt)) {
                return;
            }
            flag = true;
        }
        if (!flag) {
            this.checkForMultiBlock(world, x, y, z, component);
        }
    }

    @Override
    public void onBlockBroken(World world, int x, int y, int z, IMultiBlockComponent<? extends IMultiBlockManager<MultiBlockPartData>, MultiBlockPartData> component) {
        component.getMainComponent().preMultiBlockBreak();
        MultiBlockPartData data = component.getMultiBlockData();
        this.breakAllMultiBlocksInRange(world, x - data.posX(), y - data.posY(), z - data.posZ(), x + data.sizeX(), y + data.sizeY(), z + data.sizeZ());
    }

    @Override
    public void createMultiBlock(World world, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        int sizeX = xMax - xMin;
        int sizeY = yMax - yMin;
        int sizeZ = zMax - zMin;
        for (int x = xMin; x < xMax; ++x) {
            for (int y = yMin; y < yMax; ++y) {
                for (int z = zMin; z < zMax; ++z) {
                    IMultiBlockComponent component = (IMultiBlockComponent)world.func_147438_o(x, y, z);
                    if (x == xMin && y == yMin && z == zMin) {
                        component.preMultiBlockCreation(xMax - xMin, yMax - yMin, zMax - zMin);
                    }
                    component.setMultiBlockPartData(new MultiBlockPartData(x - xMin, y - yMin, z - zMin, sizeX, sizeY, sizeZ));
                }
            }
        }
        if (world.field_72995_K) {
            world.func_147458_c(xMin, yMin, zMin, xMax, yMax, zMax);
        }
        ((IMultiBlockComponent)world.func_147438_o(xMin, yMin, zMin)).postMultiBlockCreation();
    }

    private boolean canCheckForMultiBlock(IMultiBlockComponent component) {
        return component.getMultiBlockData().size() > 1;
    }

    private boolean checkForMultiBlock(World world, int x, int y, int z, IMultiBlockComponent component) {
        int zOffsetPlus;
        int yOffsetPlus;
        int xOffsetPlus;
        int zOffsetMin;
        int yOffsetMin;
        IMultiBlockComponent rootComponent = component.getMainComponent();
        if (rootComponent != component) {
            Object data = component.getMultiBlockData();
            return this.checkForMultiBlock(world, x - data.posX(), y - data.posY(), z - data.posZ(), rootComponent);
        }
        CoordinateIterator iterator = new CoordinateIterator();
        int xOffsetMin = this.calculateDimensionOffsetBackwards(world, x, y, z, component, iterator.setX());
        if (!this.areAllBlocksInRangeValidComponents(world, x - xOffsetMin, y - (yOffsetMin = this.calculateDimensionOffsetBackwards(world, x, y, z, component, iterator.setY())), z - (zOffsetMin = this.calculateDimensionOffsetBackwards(world, x, y, z, component, iterator.setZ())), x + (xOffsetPlus = this.calculateDimensionOffsetForwards(world, x, y, z, component, iterator.setX())), y + (yOffsetPlus = this.calculateDimensionOffsetForwards(world, x, y, z, component, iterator.setY())), z + (zOffsetPlus = this.calculateDimensionOffsetForwards(world, x, y, z, component, iterator.setZ())), component)) {
            return false;
        }
        IMultiBlockComponent newRoot = (IMultiBlockComponent)world.func_147438_o(x - xOffsetMin, y - yOffsetMin, z - zOffsetMin);
        int xSizeNew = xOffsetPlus + xOffsetMin;
        int ySizeNew = yOffsetPlus + yOffsetMin;
        int zSizeNew = zOffsetPlus + zOffsetMin;
        Object data = component.getMultiBlockData();
        if (component == newRoot && xSizeNew == data.sizeX() && ySizeNew == data.sizeY() && zSizeNew == data.sizeZ()) {
            return false;
        }
        this.createMultiBlock(world, x - xOffsetMin, y - yOffsetMin, z - zOffsetMin, x + xOffsetPlus, y + yOffsetPlus, z + zOffsetPlus);
        return true;
    }

    private int calculateDimensionOffsetBackwards(World world, int x, int y, int z, IMultiBlockComponent component, CoordinateIterator it) {
        if (!it.isActive()) {
            LogHelper.debug("ERROR WHEN ITERATING COORDINATES: ITERATOR NOT ACTIVE");
            return 0;
        }
        Object data = component.getMultiBlockData();
        x -= data.posX();
        y -= data.posY();
        z -= data.posZ();
        do {
            it.increment();
        } while (this.isValidComponent(world, x - it.x(), y - it.y(), z - it.z(), component));
        return it.getOffset() - 1;
    }

    private int calculateDimensionOffsetForwards(World world, int x, int y, int z, IMultiBlockComponent component, CoordinateIterator it) {
        if (!it.isActive()) {
            LogHelper.debug("ERROR WHEN ITERATING COORDINATES: ITERATOR NOT ACTIVE");
            return 0;
        }
        Object data = component.getMultiBlockData();
        x -= data.posX();
        y -= data.posY();
        z -= data.posZ();
        do {
            it.increment();
        } while (this.isValidComponent(world, x + it.x(), y + it.y(), z + it.z(), component));
        return it.getOffset();
    }

    private boolean areAllBlocksInRangeValidComponents(World world, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax, IMultiBlockComponent component) {
        for (int x = xMin; x < xMax; ++x) {
            for (int y = yMin; y < yMax; ++y) {
                for (int z = zMin; z < zMax; ++z) {
                    if (this.isValidComponent(world, x, y, z, component)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isValidComponent(World world, int x, int y, int z, IMultiBlockComponent component) {
        TileEntity te = world.func_147438_o(x, y, z);
        return te != null && te instanceof IMultiBlockComponent && component.isValidComponent((IMultiBlockComponent)te);
    }

    private void breakAllMultiBlocksInRange(World world, int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        for (int x = xMin; x < xMax; ++x) {
            for (int y = yMin; y < yMax; ++y) {
                for (int z = zMin; z < zMax; ++z) {
                    TileEntity te = world.func_147438_o(x, y, z);
                    if (te == null || !(te instanceof IMultiBlockComponent)) continue;
                    IMultiBlockComponent component = (IMultiBlockComponent)te;
                    component.setMultiBlockPartData(new MultiBlockPartData(0, 0, 0, 1, 1, 1));
                    component.postMultiBlockBreak();
                }
            }
        }
    }
}

