/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.crafter;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Rectangle;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.gui.RenderHelper;
import mcjty.lib.gui.Scrollable;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.ButtonEvent;
import mcjty.lib.gui.events.ChoiceEvent;
import mcjty.lib.gui.events.DefaultSelectionEvent;
import mcjty.lib.gui.events.SelectionEvent;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.network.Argument;
import mcjty.rftools.BlockInfo;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.RedstoneMode;
import mcjty.rftools.blocks.crafter.CrafterBaseTE;
import mcjty.rftools.blocks.crafter.CrafterContainer;
import mcjty.rftools.blocks.crafter.CraftingRecipe;
import mcjty.rftools.blocks.crafter.PacketCrafter;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GuiCrafter
extends GenericGuiContainer<CrafterBaseTE> {
    public static final int CRAFTER_WIDTH = 256;
    public static final int CRAFTER_HEIGHT = 224;
    private EnergyBar energyBar;
    private WidgetList recipeList;
    private ChoiceLabel keepItem;
    private ChoiceLabel internalRecipe;
    private Button applyButton;
    private ImageChoiceLabel redstoneMode;
    private ImageChoiceLabel speedMode;
    private Button rememberButton;
    private Button forgetButton;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/crafter.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");

    public GuiCrafter(CrafterBaseTE crafterBlockTileEntity, CrafterContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)crafterBlockTileEntity, (Container)container, RFTools.GUI_MANUAL_MAIN, "crafter");
        CrafterBaseTE.setCurrentRF((int)crafterBlockTileEntity.getEnergyStored(ForgeDirection.DOWN));
        this.field_146999_f = 256;
        this.field_147000_g = 224;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int maxEnergyStored = ((CrafterBaseTE)this.tileEntity).getMaxEnergyStored(ForgeDirection.DOWN);
        this.energyBar = ((EnergyBar)new EnergyBar(this.field_146297_k, (Gui)this).setVertical().setMaxValue(maxEnergyStored).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(12, 141, 10, 76))).setShowText(false);
        CrafterBaseTE cfr_ignored_0 = (CrafterBaseTE)this.tileEntity;
        this.energyBar.setValue(CrafterBaseTE.getCurrentRF());
        this.initKeepMode();
        this.initInternalRecipe();
        Slider listSlider = this.initRecipeList();
        this.applyButton = (Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Apply")).setTooltips(new String[]{"Press to apply the", "recipe to the crafter"})).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget parent) {
                GuiCrafter.this.applyRecipe();
            }
        }).setEnabled(false)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(212, 65, 34, 16));
        this.rememberButton = (Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("R")).setTooltips(new String[]{"Remember the current items", "in the internal and", "external buffers"})).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget widget) {
                GuiCrafter.this.rememberItems();
            }
        }).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(148, 70, 18, 16));
        this.forgetButton = (Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("F")).setTooltips(new String[]{"Forget the remembered layout"})).addButtonEvent(new ButtonEvent(){

            public void buttonClicked(Widget widget) {
                GuiCrafter.this.forgetItems();
            }
        }).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(168, 70, 18, 16));
        this.initRedstoneMode();
        this.initSpeedMode();
        AbstractContainerWidget toplevel = ((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.energyBar)).addChild((Widget)this.keepItem)).addChild((Widget)this.internalRecipe)).addChild((Widget)this.recipeList)).addChild((Widget)listSlider)).addChild((Widget)this.applyButton)).addChild((Widget)this.redstoneMode)).addChild((Widget)this.speedMode)).addChild((Widget)this.rememberButton)).addChild((Widget)this.forgetButton);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.selectRecipe();
        this.sendChangeToServer(-1, null, null, false, false);
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
        ((CrafterBaseTE)this.tileEntity).requestRfFromServer(RFToolsMessages.INSTANCE);
    }

    private Slider initRecipeList() {
        this.recipeList = (WidgetList)new WidgetList(this.field_146297_k, (Gui)this).addSelectionEvent((SelectionEvent)new DefaultSelectionEvent(){

            public void select(Widget parent, int index) {
                GuiCrafter.this.selectRecipe();
            }
        }).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(10, 7, 126, 80));
        this.populateList();
        return (Slider)new Slider(this.field_146297_k, (Gui)this).setVertical().setScrollable((Scrollable)this.recipeList).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(137, 7, 10, 80));
    }

    private void initInternalRecipe() {
        this.internalRecipe = (ChoiceLabel)((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{"Ext", "Int"}).setTooltips(new String[]{"'Int' will put result of", "crafting operation in", "inventory instead of", "output buffer"})).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiCrafter.this.updateRecipe();
            }
        }).setEnabled(false)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(148, 24, 41, 14));
    }

    private void initKeepMode() {
        this.keepItem = (ChoiceLabel)((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).addChoices(new String[]{"All", "Keep"}).setTooltips(new String[]{"'Keep' will keep one", "item in every inventory", "slot"})).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiCrafter.this.updateRecipe();
            }
        }).setEnabled(false)).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(148, 7, 41, 14));
    }

    private void initSpeedMode() {
        this.speedMode = new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiCrafter.this.changeSpeedMode();
            }
        }).addChoice("Slow", "Speed mode:\nSlow", iconGuiElements, 48, 0).addChoice("Fast", "Speed mode:\nFast", iconGuiElements, 64, 0);
        this.speedMode.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(49, 186, 16, 16));
        this.speedMode.setCurrentChoice(((CrafterBaseTE)this.tileEntity).getSpeedMode());
    }

    private void initRedstoneMode() {
        this.redstoneMode = new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent(new ChoiceEvent(){

            public void choiceChanged(Widget parent, String newChoice) {
                GuiCrafter.this.changeRedstoneMode();
            }
        }).addChoice(RedstoneMode.REDSTONE_IGNORED.getDescription(), "Redstone mode:\nIgnored", iconGuiElements, 0, 0).addChoice(RedstoneMode.REDSTONE_OFFREQUIRED.getDescription(), "Redstone mode:\nOff to activate", iconGuiElements, 16, 0).addChoice(RedstoneMode.REDSTONE_ONREQUIRED.getDescription(), "Redstone mode:\nOn to activate", iconGuiElements, 32, 0);
        this.redstoneMode.setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(31, 186, 16, 16));
        this.redstoneMode.setCurrentChoice(((CrafterBaseTE)this.tileEntity).getRedstoneMode().ordinal());
    }

    private void changeRedstoneMode() {
        ((CrafterBaseTE)this.tileEntity).setRedstoneMode(RedstoneMode.values()[this.redstoneMode.getCurrentChoiceIndex()]);
        this.sendChangeToServer();
    }

    private void changeSpeedMode() {
        ((CrafterBaseTE)this.tileEntity).setSpeedMode(this.speedMode.getCurrentChoiceIndex());
        this.sendChangeToServer();
    }

    private void rememberItems() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "remember", new Argument[0]);
    }

    private void forgetItems() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "forget", new Argument[0]);
    }

    private void sendChangeToServer() {
        this.sendServerCommand(RFToolsMessages.INSTANCE, "mode", new Argument[]{new Argument("rs", RedstoneMode.values()[this.redstoneMode.getCurrentChoiceIndex()].getDescription()), new Argument("speed", this.speedMode.getCurrentChoiceIndex())});
    }

    private void populateList() {
        this.recipeList.removeChildren();
        for (int i = 0; i < ((CrafterBaseTE)this.tileEntity).getSupportedRecipes(); ++i) {
            CraftingRecipe recipe = ((CrafterBaseTE)this.tileEntity).getRecipe(i);
            ItemStack stack = recipe.getResult();
            this.addRecipeLine(stack);
        }
    }

    private void addRecipeLine(Object craftingResult) {
        String readableName = BlockInfo.getReadableName(craftingResult, 0);
        int color = StyleConfig.colorTextInListNormal;
        if (craftingResult == null) {
            readableName = "<no recipe>";
            color = -11513776;
        }
        Panel panel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).addChild((Widget)new BlockRender(this.field_146297_k, (Gui)this).setRenderItem(craftingResult))).addChild((Widget)new Label(this.field_146297_k, (Gui)this).setColor(color).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT).setDynamic(true).setText(readableName));
        this.recipeList.addChild((Widget)panel);
    }

    private void selectRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            for (int i = 0; i < 10; ++i) {
                this.field_147002_h.func_75139_a(i).func_75215_d(null);
            }
            this.keepItem.setChoice("All");
            this.internalRecipe.setChoice("Ext");
            this.keepItem.setEnabled(false);
            this.internalRecipe.setEnabled(false);
            this.applyButton.setEnabled(false);
            return;
        }
        CraftingRecipe craftingRecipe = ((CrafterBaseTE)this.tileEntity).getRecipe(selected);
        InventoryCrafting inv = craftingRecipe.getInventory();
        for (int i = 0; i < 9; ++i) {
            this.field_147002_h.func_75139_a(i).func_75215_d(inv.func_70301_a(i));
        }
        this.field_147002_h.func_75139_a(9).func_75215_d(craftingRecipe.getResult());
        this.keepItem.setChoice(craftingRecipe.isKeepOne() ? "Keep" : "All");
        this.internalRecipe.setChoice(craftingRecipe.isCraftInternal() ? "Int" : "Ext");
        this.keepItem.setEnabled(true);
        this.internalRecipe.setEnabled(true);
        this.applyButton.setEnabled(true);
    }

    private void testRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        InventoryCrafting inv = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inv.func_70299_a(i, this.field_147002_h.func_75139_a(i).func_75211_c());
        }
        IRecipe recipe = CraftingRecipe.findRecipe((World)this.field_146297_k.field_71441_e, inv);
        ItemStack newResult = recipe == null ? null : recipe.func_77572_b(inv);
        this.field_147002_h.func_75139_a(9).func_75215_d(newResult);
    }

    private void applyRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        CraftingRecipe craftingRecipe = ((CrafterBaseTE)this.tileEntity).getRecipe(selected);
        InventoryCrafting inv = craftingRecipe.getInventory();
        for (int i = 0; i < 9; ++i) {
            ItemStack newStack;
            ItemStack oldStack = inv.func_70301_a(i);
            if (this.itemStacksEqual(oldStack, newStack = this.field_147002_h.func_75139_a(i).func_75211_c())) continue;
            inv.func_70299_a(i, newStack);
        }
        IRecipe recipe = CraftingRecipe.findRecipe((World)this.field_146297_k.field_71441_e, inv);
        ItemStack newResult = recipe == null ? null : recipe.func_77572_b(inv);
        ItemStack oldResult = this.field_147002_h.func_75139_a(9).func_75211_c();
        if (!this.itemStacksEqual(oldResult, newResult)) {
            this.field_147002_h.func_75139_a(9).func_75215_d(newResult);
        }
        craftingRecipe.setResult(newResult);
        this.updateRecipe();
        this.populateList();
    }

    private void updateRecipe() {
        int selected = this.recipeList.getSelected();
        if (selected == -1) {
            return;
        }
        CraftingRecipe craftingRecipe = ((CrafterBaseTE)this.tileEntity).getRecipe(selected);
        boolean keepOne = "Keep".equals(this.keepItem.getCurrentChoice());
        boolean craftInternal = "Int".equals(this.internalRecipe.getCurrentChoice());
        craftingRecipe.setKeepOne(keepOne);
        craftingRecipe.setCraftInternal(craftInternal);
        this.sendChangeToServer(selected, craftingRecipe.getInventory(), craftingRecipe.getResult(), keepOne, craftInternal);
    }

    private boolean itemStacksEqual(ItemStack matches, ItemStack oldStack) {
        if (matches == null) {
            return oldStack == null;
        }
        return oldStack != null && matches.func_77969_a(oldStack);
    }

    private void sendChangeToServer(int index, InventoryCrafting inv, ItemStack result, boolean keepOne, boolean craftInternal) {
        RFToolsMessages.INSTANCE.sendToServer((IMessage)new PacketCrafter(((CrafterBaseTE)this.tileEntity).field_145851_c, ((CrafterBaseTE)this.tileEntity).field_145848_d, ((CrafterBaseTE)this.tileEntity).field_145849_e, index, inv, result, keepOne, craftInternal));
    }

    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        this.testRecipe();
    }

    protected void func_146976_a(float v, int x, int y) {
        this.drawWindow();
        CrafterBaseTE cfr_ignored_0 = (CrafterBaseTE)this.tileEntity;
        int currentRF = CrafterBaseTE.getCurrentRF();
        this.energyBar.setValue(currentRF);
        ((CrafterBaseTE)this.tileEntity).requestRfFromServer(RFToolsMessages.INSTANCE);
        this.drawGhostSlots();
    }

    private void drawGhostSlots() {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        ItemStack[] ghostSlots = ((CrafterBaseTE)this.tileEntity).getGhostSlots();
        this.field_73735_i = 100.0f;
        GuiCrafter.field_146296_j.field_77023_b = 100.0f;
        GL11.glEnable((int)2929);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        for (int i = 0; i < ghostSlots.length; ++i) {
            int slotIdx;
            Slot slot;
            ItemStack stack = ghostSlots[i];
            if (stack == null || (slot = this.field_147002_h.func_75139_a(slotIdx = i < 26 ? i + 10 : i + 36 - 26)).func_75216_d()) continue;
            field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), stack, slot.field_75223_e, slot.field_75221_f);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2929);
            this.field_146297_k.func_110434_K().func_110577_a(iconGuiElements);
            RenderHelper.drawTexturedModalRect((int)slot.field_75223_e, (int)slot.field_75221_f, (int)224, (int)48, (int)16, (int)16);
            GL11.glEnable((int)2929);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
        }
        GuiCrafter.field_146296_j.field_77023_b = 0.0f;
        this.field_73735_i = 0.0f;
        GL11.glPopMatrix();
    }
}

